/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.meggy;

import java.util.HashMap;
import java.util.Map;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.ui.internal.meggy.PropertySelector;

public class StyleDescriptor {
    private final String type;
    private final Map<String, PropertySelector> properties;

    public StyleDescriptor(String type) {
        this.type = type;
        this.properties = new HashMap<String, PropertySelector>();
    }

    public String getType() {
        return this.type;
    }

    public void add(String key, String value, int weight) {
        PropertySelector property = this.properties.get(key);
        if (property == null) {
            property = new PropertySelector();
            this.properties.put(key, property);
        }
        property.add(value, weight);
    }

    public IStyle createStyle(IStyleSheet styleSheet) {
        IStyle style = styleSheet.createStyle(this.type);
        for (Map.Entry<String, PropertySelector> en : this.properties.entrySet()) {
            style.setProperty(en.getKey(), en.getValue().getResult());
        }
        styleSheet.addStyle(style, "automatic-styles");
        return style;
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }
}

