/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.brainstorm;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.Viewport;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.xmind.gef.EditDomain;
import org.xmind.gef.GEF;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IInputChangedListener;
import org.xmind.gef.IViewer;
import org.xmind.gef.service.FeedbackService;
import org.xmind.gef.service.IFeedbackService;
import org.xmind.gef.service.IRevealService;
import org.xmind.gef.service.IViewerService;
import org.xmind.gef.service.StyleOverrideService;
import org.xmind.gef.ui.actions.IActionRegistry;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.gef.util.Properties;
import org.xmind.ui.actions.MindMapActionFactory;
import org.xmind.ui.brainstorm.Activator;
import org.xmind.ui.brainstorm.actions.DrillUpAction;
import org.xmind.ui.internal.TopicContextService;
import org.xmind.ui.internal.brainstorm.BrainstormEditDomain;
import org.xmind.ui.internal.brainstorm.BrainstormMenuService;
import org.xmind.ui.internal.brainstorm.BrainstormTopicContextService;
import org.xmind.ui.internal.brainstorm.BrainstormViewer;
import org.xmind.ui.internal.brainstorm.ContextMenuService;
import org.xmind.ui.internal.brainstorm.KeyboardListenerService;
import org.xmind.ui.internal.brainstorm.TimerService;
import org.xmind.ui.internal.browser.BrowserPlugin;
import org.xmind.ui.internal.mindmap.DrillDownTraceService;
import org.xmind.ui.internal.mindmap.MindMapRevealService;
import org.xmind.ui.internal.mindmap.UndoRedoTipsService;
import org.xmind.ui.mindmap.IDrillDownTraceService;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.util.ICancelable;

public class BrainstormWindow
extends Window
implements IColorProvider {
    public static final String BRAINSTORM_VIEWER_KEY = "org.xmind.ui.brainstorm.BrainstormViewer";
    private static final String PREF_BROWSER_CHOICE_KEY = "browserChoice";
    private int PREF_BROWSER = 0;
    private IGraphicalEditor sourceEditor;
    private IPageChangedListener pageChangedListener;
    private IInputChangedListener viewerInputChangedListener;
    private BrainstormViewer viewer;
    private EditDomain editDomain;
    private Properties properties;
    private ICancelable openJob = null;
    private boolean wasParentFullScreen;

    protected BrainstormWindow(Shell parentShell) {
        super(parentShell);
        this.wasParentFullScreen = parentShell.getFullScreen();
        this.setBlockOnOpen(true);
        this.setShellStyle(8);
        this.initProperties();
    }

    private void initProperties() {
        this.properties = new Properties();
        this.properties.set("scrollSmooth", (Object)Boolean.TRUE);
        this.properties.set("ignoreScrollEvent", (Object)Boolean.TRUE);
        this.properties.set("centered", (Object)Boolean.TRUE);
        this.properties.set("cornered", (Object)Boolean.TRUE);
        this.properties.set("gradient", MindMapUI.isGradientColor());
        this.properties.set("margin", (Object)500);
        this.properties.set("selectCentralTopic", (Object)Boolean.TRUE);
    }

    public void setSourceEditor(IGraphicalEditor sourceEditor) {
        this.sourceEditor = sourceEditor;
        this.pageChangedListener = new IPageChangedListener(){

            public void pageChanged(PageChangedEvent event) {
                if (BrainstormWindow.this.viewer != null) {
                    BrainstormWindow.this.viewer.setInput(BrainstormWindow.this.findMindMap());
                }
            }
        };
        sourceEditor.addPageChangedListener(this.pageChangedListener);
        try {
            IPreferenceStore browserPrefStore = BrowserPlugin.getDefault().getPreferenceStore();
            this.PREF_BROWSER = browserPrefStore.getInt(PREF_BROWSER_CHOICE_KEY);
            browserPrefStore.setValue(PREF_BROWSER_CHOICE_KEY, 0);
        }
        catch (NullPointerException e) {
            Activator.log(e, "The plugin called 'org.xmind.ui.browser' was not taken.");
        }
    }

    protected Point getInitialLocation(Point initialSize) {
        Rectangle bound = this.getShell().getMonitor().getBounds();
        return new Point(bound.x, bound.y);
    }

    protected Rectangle getConstrainedShellBounds(Rectangle preferredSize) {
        return preferredSize;
    }

    protected Point getInitialSize() {
        Rectangle bound = this.getShell().getMonitor().getBounds();
        return new Point(bound.width, bound.height);
    }

    protected void configureShell(final Shell newShell) {
        Shell[] oldShells;
        super.configureShell(newShell);
        final Listener oldShellActivationListener = new Listener(){

            public void handleEvent(Event event) {
                if (newShell.isDisposed() || !newShell.isVisible()) {
                    return;
                }
                event.display.asyncExec(new Runnable(){

                    public void run() {
                        if (!newShell.isDisposed()) {
                            newShell.forceActive();
                        }
                    }
                });
            }
        };
        Shell[] shellArray = oldShells = newShell.getDisplay().getShells();
        int n = oldShells.length;
        int n2 = 0;
        while (n2 < n) {
            Shell oldShell = shellArray[n2];
            if (oldShell != newShell) {
                oldShell.addListener(26, oldShellActivationListener);
            }
            ++n2;
        }
        newShell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                Shell parentShell;
                if (newShell != null && !newShell.isDisposed()) {
                    newShell.setFullScreen(true);
                }
                if ((parentShell = BrainstormWindow.this.getParentShell()) != null && !parentShell.isDisposed() && !BrainstormWindow.this.wasParentFullScreen) {
                    parentShell.setFullScreen(true);
                }
            }
        });
        newShell.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                newShell.setFullScreen(false);
                Shell[] shellArray = oldShells;
                int n = oldShells.length;
                int n2 = 0;
                while (n2 < n) {
                    Shell oldShell = shellArray[n2];
                    if (oldShell != null && !oldShell.isDisposed() && oldShell != newShell && oldShell.getDisplay() != null) {
                        oldShell.removeListener(26, oldShellActivationListener);
                    }
                    ++n2;
                }
            }
        });
    }

    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        GridData layoutData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)layoutData);
        this.createContent(composite);
        return composite;
    }

    private void createContent(final Composite parent) {
        final IMindMap mindmap = this.findMindMap();
        if (mindmap == null) {
            return;
        }
        this.viewer = new BrainstormViewer();
        this.viewer.setProperties(this.properties);
        this.editDomain = new BrainstormEditDomain();
        this.viewer.createControl(parent);
        this.editDomain.setCommandStack(this.sourceEditor.getCommandStack());
        this.viewer.setEditDomain(this.editDomain);
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle clientArea = parent.getClientArea();
                if (BrainstormWindow.this.viewer != null && !BrainstormWindow.this.viewer.getControl().isDisposed()) {
                    Composite parent2 = BrainstormWindow.this.viewer.getControl().getParent();
                    if (parent2 != null && !parent2.isDisposed() && parent2 != parent) {
                        parent2.setBounds(clientArea);
                    }
                    BrainstormWindow.this.viewer.getControl().setBounds(clientArea);
                }
            }
        });
        this.viewerInputChangedListener = new IInputChangedListener(){

            public void inputChanged(IViewer viewer, Object newInput, Object oldInput) {
                if (viewer instanceof BrainstormViewer) {
                    BrainstormWindow.this.viewer.refresh();
                }
            }
        };
        this.viewer.addInputChangedListener(this.viewerInputChangedListener);
        this.viewer.getZoomManager().setScale(1.2);
        this.viewer.getZoomManager().zoomIn();
        FigureCanvas canvas = this.viewer.getCanvas();
        canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        canvas.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16 || e.detail == 8) {
                    e.doit = false;
                } else if (e.detail == 2) {
                    e.doit = BrainstormWindow.this.canHandleShellCloseEvent();
                }
            }
        });
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.installServices();
        this.installScrollListener();
        this.getShell().setData(BRAINSTORM_VIEWER_KEY, (Object)this.viewer);
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                BrainstormWindow.this.viewer.setInput(mindmap);
            }
        });
    }

    private void installScrollListener() {
        FigureCanvas canvas = this.viewer.getCanvas();
        final ScrollBar horizontalBar = canvas.getHorizontalBar();
        horizontalBar.removeListener(13, horizontalBar.getListeners(13)[0]);
        horizontalBar.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Viewport viewport = BrainstormWindow.this.viewer.getCanvas().getViewport();
                RangeModel model = viewport.getHorizontalRangeModel();
                int hBarOffset = Math.max(0, -model.getMinimum());
                int hOffset = horizontalBar.getSelection() - hBarOffset;
                hOffset = this.verifyScrollBarOffset(model, hOffset);
                viewport.setHorizontalLocation(hOffset);
            }

            private int verifyScrollBarOffset(RangeModel model, int value) {
                value = Math.max(model.getMinimum(), value);
                return Math.min(model.getMaximum() - model.getExtent(), value);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final ScrollBar vBar = canvas.getVerticalBar();
        vBar.removeListener(13, vBar.getListeners(13)[0]);
        vBar.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Viewport viewport = BrainstormWindow.this.viewer.getCanvas().getViewport();
                RangeModel model = viewport.getVerticalRangeModel();
                int vBarOffset = Math.max(0, -model.getMinimum());
                int vOffset = vBar.getSelection() - vBarOffset;
                vOffset = this.verifyScrollBarOffset(model, vOffset);
                viewport.setVerticalLocation(vOffset);
            }

            private int verifyScrollBarOffset(RangeModel model, int value) {
                value = Math.max(model.getMinimum(), value);
                return Math.min(model.getMaximum() - model.getExtent(), value);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected boolean canHandleShellCloseEvent() {
        if (this.editDomain.getActiveTool() != this.editDomain.getDefaultTool()) {
            return false;
        }
        return super.canHandleShellCloseEvent();
    }

    public boolean close() {
        if (this.sourceEditor != null && this.pageChangedListener != null) {
            this.sourceEditor.removePageChangedListener(this.pageChangedListener);
        }
        if (this.openJob != null) {
            this.openJob.cancel();
            this.openJob = null;
        }
        if (this.viewer != null) {
            this.unInstallServices();
            this.viewer.removeInputChangedListener(this.viewerInputChangedListener);
            this.viewer.setEditDomain(null);
            this.viewer = null;
        }
        try {
            IPreferenceStore browserPrefStore = BrowserPlugin.getDefault().getPreferenceStore();
            browserPrefStore.setValue(PREF_BROWSER_CHOICE_KEY, this.PREF_BROWSER);
        }
        catch (NullPointerException e) {
            Activator.log(e, "The plugin called 'org.xmind.ui.browser' was not taken.");
        }
        Shell parentShell = this.getParentShell();
        if (parentShell != null && !parentShell.isDisposed()) {
            parentShell.setFullScreen(this.wasParentFullScreen);
        }
        return super.close();
    }

    private void installServices() {
        IDrillDownTraceService sourceTraceService;
        Layer undoLayer;
        MindMapRevealService revealService = new MindMapRevealService((IGraphicalViewer)this.viewer);
        this.viewer.installService(IRevealService.class, (IViewerService)revealService);
        revealService.setActive(true);
        Layer feedbackLayer = this.viewer.getLayer(GEF.LAYER_FEEDBACK);
        if (feedbackLayer != null) {
            FeedbackService feedbackService = new FeedbackService((IGraphicalViewer)this.viewer);
            this.viewer.installService(IFeedbackService.class, (IViewerService)feedbackService);
            feedbackService.setLayer((IFigure)feedbackLayer);
            feedbackService.setSelectionColorProvider((IColorProvider)this);
            feedbackService.setSelectionLineWidth(4);
            feedbackService.setSelectionCorner(5);
            feedbackService.setActive(true);
        }
        if ((undoLayer = this.viewer.getLayer(MindMapUI.LAYER_UNDO)) != null) {
            UndoRedoTipsService undoService = new UndoRedoTipsService((IGraphicalViewer)this.viewer);
            this.viewer.installService(UndoRedoTipsService.class, (IViewerService)undoService);
            undoService.setLayer((IFigure)undoLayer);
            undoService.setActive(true);
        }
        BrainstormMenuService brainstormMenuService = new BrainstormMenuService(this, (IGraphicalViewer)this.viewer);
        this.viewer.installService(BrainstormMenuService.class, (IViewerService)brainstormMenuService);
        brainstormMenuService.setActive(true);
        TimerService timerService = new TimerService((IGraphicalViewer)this.viewer);
        this.viewer.installService(TimerService.class, (IViewerService)timerService);
        timerService.setActive(true);
        timerService.setActive(false);
        ContextMenuService menuService = new ContextMenuService((IGraphicalViewer)this.viewer, this.sourceEditor);
        this.viewer.installService(ContextMenuService.class, (IViewerService)menuService);
        menuService.setActive(true);
        BrainstormTopicContextService topicContextService = new BrainstormTopicContextService((IViewer)this.viewer, this.sourceEditor);
        this.viewer.installService(TopicContextService.class, (IViewerService)topicContextService);
        topicContextService.setActive(true);
        DrillDownTraceService traceService = new DrillDownTraceService((IGraphicalViewer)this.viewer);
        this.viewer.installService(IDrillDownTraceService.class, (IViewerService)traceService);
        traceService.setActive(true);
        IActionRegistry actionRegistry = (IActionRegistry)this.viewer.getAdapter(IActionRegistry.class);
        IAction action = actionRegistry.getAction(MindMapActionFactory.DRILL_UP.getId());
        if (action instanceof DrillUpAction) {
            ((DrillUpAction)action).setTraceServce((IDrillDownTraceService)traceService);
        }
        if ((sourceTraceService = (IDrillDownTraceService)this.sourceEditor.getActivePageInstance().getViewer().getService(IDrillDownTraceService.class)) != null) {
            traceService.init(sourceTraceService.getCentralTopics());
        }
    }

    private void unInstallServices() {
        this.viewer.uninstallService(IRevealService.class);
        this.viewer.uninstallService(IFeedbackService.class);
        this.viewer.uninstallService(UndoRedoTipsService.class);
        this.viewer.uninstallService(BrainstormMenuService.class);
        this.viewer.uninstallService(TimerService.class);
        this.viewer.uninstallService(ContextMenuService.class);
        this.viewer.uninstallService(BrainstormTopicContextService.class);
        this.viewer.uninstallService(DrillDownTraceService.class);
        this.viewer.uninstallService(KeyboardListenerService.class);
        this.viewer.uninstallService(StyleOverrideService.class);
    }

    private IMindMap findMindMap() {
        Object o;
        if (this.sourceEditor == null) {
            return null;
        }
        IGraphicalEditorPage page = this.sourceEditor.getActivePageInstance();
        if (page == null) {
            return null;
        }
        Object input = page.getInput();
        if (input instanceof IMindMap) {
            return (IMindMap)input;
        }
        if (input instanceof IAdaptable && (o = ((IAdaptable)input).getAdapter(IMindMap.class)) instanceof IMindMap) {
            return (IMindMap)o;
        }
        return (IMindMap)page.getAdapter(IMindMap.class);
    }

    public Color getBackground(Object element) {
        if (IFeedbackService.PreselectionColor.equals(element) || IFeedbackService.DisabledPreselectionColor.equals(element)) {
            return ColorUtils.getColor((String)"#80c0d0");
        }
        return null;
    }

    public Color getForeground(Object element) {
        if (IFeedbackService.FocusColor.equals(element)) {
            return ColorUtils.getColor((String)"#1020f0");
        }
        if (IFeedbackService.SelectionColor.equals(element)) {
            return ColorUtils.getColor((String)"#1040a8");
        }
        if (IFeedbackService.PreselectionColor.equals(element) || IFeedbackService.DisabledPreselectionColor.equals(element)) {
            return ColorUtils.getColor((String)"#a8c0d8");
        }
        if (IFeedbackService.DisabledFocusColor.equals(element)) {
            return ColorUtils.getColor((String)"#606060");
        }
        if (IFeedbackService.DisabledSelectionColor.equals(element)) {
            return ColorUtils.getColor((String)"#808080");
        }
        return null;
    }
}

