/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.xmindresource;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.IManifest;
import org.xmind.core.IWorkbook;
import org.xmind.core.internal.dom.MarkerResourceProvider;
import org.xmind.core.internal.dom.StyleSheetImpl;
import org.xmind.core.internal.gallery.DownloadedGalleryItem;
import org.xmind.core.internal.gallery.GalleryCore;
import org.xmind.core.internal.gallery.IGalleryGroup;
import org.xmind.core.internal.gallery.IGalleryItem;
import org.xmind.core.internal.gallery.LocalGalleryGroup;
import org.xmind.core.internal.gallery.LocalGalleryItem;
import org.xmind.core.internal.zip.ZipStreamOutputTarget;
import org.xmind.core.io.DirectoryInputSource;
import org.xmind.core.io.DirectoryOutputTarget;
import org.xmind.core.io.DirectoryStorage;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.io.IStorage;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerResourceProvider;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.util.FileUtils;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.mindmap.ITemplate;
import org.xmind.ui.mindmap.IWorkbookRef;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.xmindresource.XMindResourcePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMindResourceImpExpUtils {
    public static final String PATH_RESOURCE_BUNDLE_TEMP = "Import Resource Bundle";
    public static final String PATH_THEMES = "themes";
    public static final String PATH_TEMPLATES = "templates";
    public static final String PATH_CLIPARTS = "cliparts";
    public static final String PATH_MARKERS = "markers";

    private XMindResourceImpExpUtils() {
    }

    public static int exportResourceBundle(Collection<Object> resourceToExpor, String targetPath) {
        int status = 0;
        if (resourceToExpor == null || resourceToExpor.isEmpty()) {
            return status;
        }
        LinkedList<IStyle> sourceThemes = new LinkedList<IStyle>();
        LinkedList<ITemplate> sourceTemplates = new LinkedList<ITemplate>();
        LinkedList<IGalleryGroup> sourceClipArtGroups = new LinkedList<IGalleryGroup>();
        LinkedList<IMarkerGroup> sourceMarkerGroups = new LinkedList<IMarkerGroup>();
        for (Object resource : resourceToExpor) {
            if (resource instanceof IStyle) {
                sourceThemes.add((IStyle)resource);
                continue;
            }
            if (resource instanceof ITemplate) {
                sourceTemplates.add((ITemplate)resource);
                continue;
            }
            if (resource instanceof IGalleryGroup) {
                sourceClipArtGroups.add((IGalleryGroup)resource);
                continue;
            }
            if (!(resource instanceof IMarkerGroup)) continue;
            sourceMarkerGroups.add((IMarkerGroup)resource);
        }
        return status |= XMindResourceImpExpUtils.exportResourceBundle(targetPath, sourceThemes, sourceTemplates, sourceClipArtGroups, sourceMarkerGroups);
    }

    public static int exportResourceBundle(String targetPath, List<IStyle> sourceThemes, List<ITemplate> sourceTemplates, List<IGalleryGroup> sourceClipArtGroups, List<IMarkerGroup> sourceMarkerGroups) {
        File root;
        int status;
        block45: {
            status = 0;
            root = XMindResourcePlugin.getDefault().getStateLocation().toFile();
            root = new File(root, "Export Resource Bundle");
            root.mkdirs();
            FileUtils.clearDir((File)root);
            if (sourceThemes != null && !sourceThemes.isEmpty()) {
                File themesDir = new File(root, PATH_THEMES);
                themesDir.mkdirs();
                DirectoryStorage workbookStorage = new DirectoryStorage(themesDir);
                IWorkbook workbook = Core.getWorkbookBuilder().createWorkbook((IStorage)workbookStorage);
                IStyleSheet styleSheet = workbook.getStyleSheet();
                for (IStyle theme : sourceThemes) {
                    styleSheet.importStyle(theme);
                }
                try {
                    workbook.saveTemp();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    status |= 2;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    status |= 2;
                }
            }
            if (sourceTemplates != null && !sourceTemplates.isEmpty()) {
                File templatesDir = new File(root, PATH_TEMPLATES);
                templatesDir.mkdirs();
                for (ITemplate template : sourceTemplates) {
                    String destPath = String.valueOf(templatesDir.getAbsolutePath()) + File.separator + template.getName() + ".xmt";
                    IWorkbookRef sourceWR = template.createWorkbookRef();
                    IWorkbookRef targetWR = MindMapUIPlugin.getDefault().getWorkbookRefFactory().createWorkbookRef(new File(destPath).toURI(), null);
                    if (!targetWR.canImportFrom(sourceWR)) continue;
                    try {
                        sourceWR.open((IProgressMonitor)new NullProgressMonitor());
                        try {
                            targetWR.importFrom(null, sourceWR);
                        }
                        finally {
                            sourceWR.close((IProgressMonitor)new NullProgressMonitor());
                        }
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        status |= 4;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        status |= 4;
                    }
                }
            }
            if (sourceMarkerGroups != null && !sourceMarkerGroups.isEmpty()) {
                File markerGroupsDir = new File(root, PATH_MARKERS);
                DirectoryOutputTarget markerGroupsTarget = new DirectoryOutputTarget(markerGroupsDir);
                IMarkerSheet targetSheet = Core.getMarkerSheetBuilder().createMarkerSheet((IMarkerResourceProvider)new MarkerResourceProvider(null, (IOutputTarget)markerGroupsTarget));
                for (IMarkerGroup group : sourceMarkerGroups) {
                    targetSheet.importGroup(group);
                }
                OutputStream entryStream = markerGroupsTarget.getEntryStream("markerSheet.xml");
                try {
                    targetSheet.save(entryStream);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    status |= 0x10;
                    try {
                        entryStream.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                        status |= 0x10;
                    }
                    break block45;
                }
                catch (CoreException e) {
                    try {
                        e.printStackTrace();
                        status |= 0x10;
                        break block45;
                    }
                    catch (Throwable targetWR) {
                        throw targetWR;
                    }
                    finally {
                        try {
                            entryStream.close();
                        }
                        catch (IOException e3) {
                            e3.printStackTrace();
                            status |= 0x10;
                        }
                    }
                }
                try {
                    entryStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    status |= 0x10;
                }
            }
        }
        if (sourceClipArtGroups != null && !sourceClipArtGroups.isEmpty()) {
            File clipArtDir = new File(root, PATH_CLIPARTS);
            clipArtDir.mkdirs();
            for (IGalleryGroup group : sourceClipArtGroups) {
                for (IGalleryItem clipArt : group.getItems()) {
                    String clipArtName = ".png";
                    if (clipArt instanceof LocalGalleryItem) {
                        clipArtName = ((LocalGalleryItem)clipArt).getFile().getName();
                    } else if (clipArt instanceof DownloadedGalleryItem) {
                        clipArtName = new File(((DownloadedGalleryItem)clipArt).getPath()).getName();
                    }
                    try {
                        FileUtils.transfer((InputStream)clipArt.getURL().openStream(), (OutputStream)new FileOutputStream(String.valueOf(clipArtDir.getAbsolutePath()) + File.separator + clipArtName));
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                        status |= 8;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        status |= 8;
                    }
                }
            }
        }
        ZipStreamOutputTarget exportTarget = null;
        try {
            exportTarget = new ZipStreamOutputTarget(new ZipOutputStream(new FileOutputStream(targetPath)), true);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            status |= 0x20;
        }
        if (exportTarget == null) {
            return status |= 0x20;
        }
        try {
            FileUtils.transfer((IInputSource)new DirectoryInputSource(root), (IOutputTarget)exportTarget);
            exportTarget.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            status |= 0x20;
        }
        if (root != null) {
            FileUtils.clearDir((File)root);
        }
        return status;
    }

    public static int importResourceBundle(String sourcePath) {
        int status = 0;
        status |= XMindResourceImpExpUtils.createTempDiretoryHasUnZipResource(sourcePath);
        return status |= XMindResourceImpExpUtils.importResourceBundleFromTempDir(XMindResourceImpExpUtils.getSpecialDir(sourcePath).getAbsolutePath());
    }

    public static int importResourceBundleFromTempDir(String tempDir) {
        File markerFile;
        File clipartDir;
        File templateDirectory;
        int status = 0;
        if (tempDir == null) {
            return status;
        }
        File root = new File(tempDir);
        if (!root.isDirectory()) {
            return status;
        }
        File themeDir = new File(String.valueOf(tempDir) + File.separator + PATH_THEMES);
        if (themeDir.isDirectory() && new File(themeDir, "content.xml").exists()) {
            status |= XMindResourceImpExpUtils.importThemes(themeDir);
        }
        if ((templateDirectory = new File(String.valueOf(tempDir) + File.separator + PATH_TEMPLATES)).isDirectory()) {
            File[] templateFiles;
            File[] fileArray = templateFiles = templateDirectory.listFiles();
            int n = templateFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                try {
                    MindMapUI.getResourceManager().addUserTemplateFromWorkbookURI(file.toURI());
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                    status |= 4;
                }
                ++n2;
            }
        }
        if ((clipartDir = new File(String.valueOf(tempDir) + File.separator + PATH_CLIPARTS)).isDirectory()) {
            File[] cliparts = clipartDir.listFiles();
            String[] paths = new String[cliparts.length];
            int i = 0;
            while (i < cliparts.length) {
                paths[i] = cliparts[i].getAbsolutePath();
                ++i;
            }
            File dir = new File(String.valueOf(GalleryCore.getPath((String)"gallery")) + File.separator + "Imported");
            FileUtils.ensureDirectory((File)dir);
            GalleryCore.getInstance().addImagesToUserGroup(paths, (IGalleryGroup)new LocalGalleryGroup(dir, dir.getName()));
        }
        if ((markerFile = new File(String.valueOf(tempDir) + File.separator + PATH_MARKERS + File.separator + "markerSheet.xml")).exists()) {
            status |= XMindResourceImpExpUtils.importMarkers(String.valueOf(tempDir) + File.separator + PATH_MARKERS, markerFile);
        } else {
            markerFile = new File(String.valueOf(tempDir) + File.separator + "markerSheet.xml");
            if (markerFile.exists()) {
                status |= XMindResourceImpExpUtils.importMarkers(tempDir, markerFile);
            }
        }
        if (root != null) {
            FileUtils.clearDir((File)root);
        }
        return status;
    }

    public static int createTempDiretoryHasUnZipResource(String sourcePath) {
        int status;
        block7: {
            File sourceFile;
            File root;
            block6: {
                File[] files;
                status = 0;
                root = XMindResourceImpExpUtils.getSpecialDir(sourcePath);
                FileUtils.clearDir((File)root);
                sourceFile = new File(sourcePath);
                if (!sourceFile.isDirectory()) break block6;
                File[] fileArray = files = sourceFile.listFiles();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.getAbsolutePath().endsWith(".xrb")) {
                        try {
                            FileUtils.extractZipFile((File)file, (IOutputTarget)new DirectoryOutputTarget(root));
                        }
                        catch (IOException iOException) {
                            status |= 0x20;
                        }
                    }
                    ++n2;
                }
                break block7;
            }
            if (!sourceFile.isFile() || !sourcePath.endsWith(".xrb")) break block7;
            try {
                FileUtils.extractZipFile((File)sourceFile, (IOutputTarget)new DirectoryOutputTarget(root));
            }
            catch (IOException iOException) {
                status |= 0x20;
            }
        }
        return status;
    }

    public static int createTempDiretoryHasUnZipMarkerPackage(String sourcePath) {
        int status;
        block7: {
            File sourceFile;
            File root;
            block6: {
                File[] files;
                status = 0;
                root = XMindResourceImpExpUtils.getSpecialDir(sourcePath);
                FileUtils.clearDir((File)root);
                sourceFile = new File(sourcePath);
                if (!sourceFile.isDirectory()) break block6;
                File[] fileArray = files = sourceFile.listFiles();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.getAbsolutePath().endsWith(".xmp")) {
                        try {
                            FileUtils.extractZipFile((File)file, (IOutputTarget)new DirectoryOutputTarget(root));
                        }
                        catch (IOException iOException) {
                            status |= 0x20;
                        }
                    }
                    ++n2;
                }
                break block7;
            }
            if (!sourceFile.isFile() || !sourcePath.endsWith(".xmp")) break block7;
            try {
                FileUtils.extractZipFile((File)sourceFile, (IOutputTarget)new DirectoryOutputTarget(root));
            }
            catch (IOException iOException) {
                status |= 0x20;
            }
        }
        return status;
    }

    public static File getSpecialDir(String abstractPath) {
        File dir = XMindResourcePlugin.getDefault().getStateLocation().toFile();
        dir = new File(dir, PATH_RESOURCE_BUNDLE_TEMP);
        dir = new File(dir, PATH_RESOURCE_BUNDLE_TEMP + abstractPath.hashCode());
        dir.mkdirs();
        return dir;
    }

    private static int importThemes(File themeDir) {
        try {
            IStyleSheet userThemeSheet = MindMapUI.getResourceManager().getUserThemeSheet();
            IWorkbook stylesContainer = Core.getWorkbookBuilder().loadFromStorage((IStorage)new DirectoryStorage(themeDir));
            IStyleSheet styleSheet = stylesContainer.getStyleSheet();
            IManifest manifest = stylesContainer.getManifest();
            ((StyleSheetImpl)styleSheet).setManifest(manifest);
            Set styles = styleSheet.getStyles("master-styles");
            for (IStyle style : styles) {
                userThemeSheet.importStyle(style);
            }
            MindMapUI.getResourceManager().saveUserThemeSheet();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 2;
        }
        return 0;
    }

    private static int importMarkers(String rootPath, File markerFile) {
        try {
            DirectoryInputSource inputSource = new DirectoryInputSource(new File(rootPath));
            IMarkerSheet sourceMarkerSheet = Core.getMarkerSheetBuilder().loadFromFile(markerFile, (IMarkerResourceProvider)new MarkerResourceProvider((IInputSource)inputSource, null));
            for (IMarkerGroup markerGroup : sourceMarkerSheet.getMarkerGroups()) {
                Iterator iterator = markerGroup.getMarkers().iterator();
                while (iterator.hasNext()) {
                    IMarker cfr_ignored_0 = (IMarker)iterator.next();
                    MindMapUIPlugin.getDefault().getUsageDataCollector().increase("UserMarkerCount");
                }
            }
            MindMapUI.getResourceManager().getUserMarkerSheet().importFrom(sourceMarkerSheet);
            MindMapUI.getResourceManager().saveUserMarkerSheet();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 16;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return 16;
        }
        return 0;
    }

    public static StringBuffer getFailureType(int status) {
        StringBuffer failureType = new StringBuffer();
        if ((status & 2) != 0) {
            if (failureType.length() != 0) {
                failureType.append(',');
            }
            failureType.append(XMindResourcePlugin.RESOURCE_TYPE_THEME);
        }
        if ((status & 4) != 0) {
            if (failureType.length() != 0) {
                failureType.append(',');
            }
            failureType.append(XMindResourcePlugin.RESOURCE_TYPE_TEMPLATE);
        }
        if ((status & 8) != 0) {
            if (failureType.length() != 0) {
                failureType.append(',');
            }
            failureType.append(XMindResourcePlugin.RESOURCE_TYPE_CLIPART);
        }
        if ((status & 0x10) != 0) {
            if (failureType.length() != 0) {
                failureType.append(',');
            }
            failureType.append(XMindResourcePlugin.RESOURCE_TYPE_MARKER);
        }
        return failureType;
    }
}

