/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.xmindresource;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.xmind.core.internal.gallery.DownloadedGalleryItem;
import org.xmind.core.internal.gallery.IGalleryItem;
import org.xmind.core.internal.gallery.LocalGalleryItem;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.style.IStyle;
import org.xmind.ui.mindmap.ITemplate;
import org.xmind.ui.xmindresource.XMindResourcePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceConfirmPageViewer
extends TreeViewer {
    private List<Object> elementsToConfirm;

    public ResourceConfirmPageViewer(Composite parent, int style) {
        super(parent, style);
    }

    public void initViewer() {
        this.getTree().setHeaderVisible(false);
        this.setContentProvider((IContentProvider)new ResourceConfirmPageContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new ResourceConfirmPageLabelProvider());
        this.setAutoExpandLevel(2);
    }

    public void setNeedConfirmSelection(List<Object> elementsToConfim) {
        this.elementsToConfirm = elementsToConfim;
        HashSet<String> input = new HashSet<String>();
        if (elementsToConfim != null) {
            for (Object element : elementsToConfim) {
                if (element instanceof IStyle) {
                    input.add(XMindResourcePlugin.RESOURCE_TYPE_THEME);
                    continue;
                }
                if (element instanceof ITemplate) {
                    input.add(XMindResourcePlugin.RESOURCE_TYPE_TEMPLATE);
                    continue;
                }
                if (element instanceof IGalleryItem) {
                    input.add(XMindResourcePlugin.RESOURCE_TYPE_CLIPART);
                    continue;
                }
                if (!(element instanceof IMarkerGroup)) continue;
                input.add(XMindResourcePlugin.RESOURCE_TYPE_MARKER);
            }
        }
        this.setInput(input.toArray());
    }

    private class ResourceConfirmPageContentProvider
    implements ITreeContentProvider {
        private List<Object> concreteInput;

        private ResourceConfirmPageContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.concreteInput = ResourceConfirmPageViewer.this.elementsToConfirm;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Object[]) {
                return (Object[])inputElement;
            }
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            ArrayList<Object> children;
            block6: {
                block8: {
                    block7: {
                        block5: {
                            if (this.concreteInput == null) {
                                return null;
                            }
                            children = new ArrayList<Object>();
                            if (XMindResourcePlugin.RESOURCE_TYPE_THEME != parentElement) break block5;
                            for (Object obj : this.concreteInput) {
                                if (!(obj instanceof IStyle)) continue;
                                children.add(obj);
                            }
                            break block6;
                        }
                        if (XMindResourcePlugin.RESOURCE_TYPE_TEMPLATE != parentElement) break block7;
                        for (Object obj : this.concreteInput) {
                            if (!(obj instanceof ITemplate)) continue;
                            children.add(obj);
                        }
                        break block6;
                    }
                    if (XMindResourcePlugin.RESOURCE_TYPE_CLIPART != parentElement) break block8;
                    for (Object obj : this.concreteInput) {
                        if (!(obj instanceof IGalleryItem)) continue;
                        children.add(obj);
                    }
                    break block6;
                }
                if (XMindResourcePlugin.RESOURCE_TYPE_MARKER != parentElement) break block6;
                for (Object obj : this.concreteInput) {
                    if (!(obj instanceof IMarkerGroup)) continue;
                    children.add(obj);
                }
            }
            return children.toArray();
        }

        public Object getParent(Object element) {
            if (element instanceof IStyle) {
                return XMindResourcePlugin.RESOURCE_TYPE_THEME;
            }
            if (element instanceof ITemplate) {
                return XMindResourcePlugin.RESOURCE_TYPE_TEMPLATE;
            }
            if (element instanceof IGalleryItem) {
                return XMindResourcePlugin.RESOURCE_TYPE_CLIPART;
            }
            if (element instanceof IMarkerGroup) {
                return XMindResourcePlugin.RESOURCE_TYPE_MARKER;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return XMindResourcePlugin.RESOURCE_TYPE_THEME == element || XMindResourcePlugin.RESOURCE_TYPE_CLIPART == element || XMindResourcePlugin.RESOURCE_TYPE_TEMPLATE == element || XMindResourcePlugin.RESOURCE_TYPE_MARKER == element;
        }
    }

    private static class ResourceConfirmPageLabelProvider
    extends LabelProvider {
        private ResourceConfirmPageLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IStyle) {
                return ((IStyle)element).getName();
            }
            if (element instanceof ITemplate) {
                return ((ITemplate)element).getName();
            }
            if (element instanceof IGalleryItem) {
                File file;
                if (element instanceof DownloadedGalleryItem) {
                    String path = ((DownloadedGalleryItem)element).getPath();
                    File file2 = new File(path);
                    if (file2.exists()) {
                        return file2.getName();
                    }
                } else if (element instanceof LocalGalleryItem && (file = ((LocalGalleryItem)element).getFile()) != null) {
                    return file.getName();
                }
            } else if (element instanceof IMarkerGroup) {
                return ((IMarkerGroup)element).getName();
            }
            return super.getText(element);
        }
    }
}

