/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.fishbone.structures;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.draw2d.geometry.Point;
import org.xmind.gef.draw2d.geometry.HorizontalFlipper;
import org.xmind.gef.draw2d.geometry.IPrecisionTransformer;
import org.xmind.gef.draw2d.geometry.ITransformer;
import org.xmind.gef.draw2d.geometry.PrecisionHorizontalFlipper;
import org.xmind.gef.draw2d.geometry.PrecisionVerticalFlipper;
import org.xmind.ui.branch.BranchStructureData;
import org.xmind.ui.internal.fishbone.structures.Side;
import org.xmind.ui.mindmap.IBranchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainFishboneData
extends BranchStructureData {
    private Set<Integer> upwardBranches = null;
    public final ITransformer hf = new HorizontalFlipper();
    public final IPrecisionTransformer phf = new PrecisionHorizontalFlipper();
    public final IPrecisionTransformer pvf = new PrecisionVerticalFlipper();
    public final Side upSide = new Side();
    public final Side downSide = new Side();

    public MainFishboneData(IBranchPart branch, boolean transformerEnabled) {
        super(branch);
        this.hf.setEnabled(transformerEnabled);
        this.phf.setEnabled(transformerEnabled);
    }

    public void setOrigin(Point origin) {
        this.hf.setOrigin(origin);
        this.phf.setOrigin((double)origin.x, (double)origin.y);
        this.pvf.setOrigin(this.phf.getOrigin());
    }

    public boolean isUpwardBranch(int index) {
        return this.getUpwardBranches().contains(index);
    }

    private Set<Integer> getUpwardBranches() {
        if (this.upwardBranches == null) {
            this.upwardBranches = this.calcUpwardBranches();
        }
        return this.upwardBranches;
    }

    private Set<Integer> calcUpwardBranches() {
        HashSet<Integer> set = new HashSet<Integer>();
        int i = 0;
        IBranchPart lastChild = null;
        boolean upwards = true;
        for (IBranchPart subBranch : this.getBranch().getSubBranches()) {
            if (lastChild == null) {
                set.add(i);
            } else {
                if (!this.isInSameRange(lastChild, subBranch)) {
                    boolean bl = upwards = !upwards;
                }
                if (upwards) {
                    set.add(i);
                }
            }
            lastChild = subBranch;
            ++i;
        }
        return set;
    }
}

