/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d.graphics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.draw2d.graphics.GradientPattern;

public class ScaledGraphics
extends Graphics {
    public static boolean SCALED_GRAPHICS_ENABLED = false;
    private static int[][] intArrayCache = new int[8][];
    private final Rectangle tempRECT = new Rectangle();
    private boolean allowText = true;
    private Map<FontKey, Font> fontCache = new HashMap<FontKey, Font>();
    private Map<Font, FontData> fontDataCache = new HashMap<Font, FontData>();
    private FontKey fontKey = new FontKey();
    private double fractionalX;
    private double fractionalY;
    private Graphics graphics;
    private FontHeightCache localCache = new FontHeightCache();
    private Font localFont;
    private float localLineWidth;
    private List<State> stack = new ArrayList<State>();
    private int stackPointer = 0;
    private FontHeightCache targetCache = new FontHeightCache();
    private double zoom = 1.0;
    private int[] localDash = null;
    private Pattern localBackground = null;
    private Pattern localForeground = null;
    private Map<PatternKey, GradientPattern> patternCache = new HashMap<PatternKey, GradientPattern>();
    private PatternKey patternKey = new PatternKey();
    private Path lastClipPath = null;

    static {
        int i = 0;
        while (i < intArrayCache.length) {
            ScaledGraphics.intArrayCache[i] = new int[i + 1];
            ++i;
        }
    }

    public ScaledGraphics(Graphics g) {
        this.graphics = g;
        this.localFont = g.getFont();
        this.localLineWidth = g.getLineWidth();
    }

    public void clipRect(Rectangle r) {
        this.graphics.clipRect(this.zoomClipRect(r));
    }

    Font createFont(FontData data) {
        return new Font((Device)Display.getCurrent(), data);
    }

    public void dispose() {
        while (this.stackPointer > 0) {
            this.popState();
        }
        for (Font font : this.fontCache.values()) {
            font.dispose();
        }
        for (Pattern pattern : this.patternCache.values()) {
            pattern.dispose();
        }
    }

    public void drawArc(int x, int y, int w, int h, int offset, int sweep) {
        Rectangle z = this.zoomRect(x, y, w, h);
        if (z.isEmpty() || sweep == 0) {
            return;
        }
        this.graphics.drawArc(z, offset, sweep);
    }

    public void drawFocus(int x, int y, int w, int h) {
        this.graphics.drawFocus(this.zoomRect(x, y, w, h));
    }

    public void drawImage(Image srcImage, int x, int y) {
        org.eclipse.swt.graphics.Rectangle size = srcImage.getBounds();
        this.graphics.drawImage(srcImage, 0, 0, size.width, size.height, (int)Math.floor((double)x * this.zoom + this.fractionalX), (int)Math.floor((double)y * this.zoom + this.fractionalY), (int)Math.floor((double)size.width * this.zoom + this.fractionalX), (int)Math.floor((double)size.height * this.zoom + this.fractionalY));
    }

    public void drawImage(Image srcImage, int sx, int sy, int sw, int sh, int tx, int ty, int tw, int th) {
        Rectangle t = this.zoomRect(tx, ty, tw, th);
        if (!t.isEmpty()) {
            this.graphics.drawImage(srcImage, sx, sy, sw, sh, t.x, t.y, t.width, t.height);
        }
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.graphics.drawLine((int)Math.floor((double)x1 * this.zoom + this.fractionalX), (int)Math.floor((double)y1 * this.zoom + this.fractionalY), (int)Math.floor((double)x2 * this.zoom + this.fractionalX), (int)Math.floor((double)y2 * this.zoom + this.fractionalY));
    }

    public void drawOval(int x, int y, int w, int h) {
        this.graphics.drawOval(this.zoomRect(x, y, w, h));
    }

    public void drawPoint(int x, int y) {
        this.graphics.drawPoint((int)Math.floor((double)x * this.zoom + this.fractionalX), (int)Math.floor((double)y * this.zoom + this.fractionalY));
    }

    public void drawPolygon(int[] points) {
        this.graphics.drawPolygon(this.zoomPointList(points));
    }

    public void drawPolygon(PointList points) {
        this.graphics.drawPolygon(this.zoomPointList(points.toIntArray()));
    }

    public void drawPolyline(int[] points) {
        this.graphics.drawPolyline(this.zoomPointList(points));
    }

    public void drawPolyline(PointList points) {
        this.graphics.drawPolyline(this.zoomPointList(points.toIntArray()));
    }

    public void drawRectangle(int x, int y, int w, int h) {
        this.graphics.drawRectangle(this.zoomRect(x, y, w, h));
    }

    public void drawRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        this.graphics.drawRoundRectangle(this.zoomRect(r.x, r.y, r.width, r.height), (int)((double)arcWidth * this.zoom), (int)((double)arcHeight * this.zoom));
    }

    public void drawString(String s, int x, int y) {
        if (this.allowText) {
            this.graphics.drawString(s, this.zoomTextPoint(x, y));
        }
    }

    public void drawText(String s, int x, int y) {
        if (this.allowText) {
            this.graphics.drawText(s, this.zoomTextPoint(x, y));
        }
    }

    public void drawText(String s, int x, int y, int style) {
        if (this.allowText) {
            this.graphics.drawText(s, this.zoomTextPoint(x, y), style);
        }
    }

    public void drawTextLayout(TextLayout layout, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        TextLayout scaled = this.zoomTextLayout(layout);
        this.graphics.drawTextLayout(scaled, (int)Math.floor((double)x * this.zoom + this.fractionalX), (int)Math.floor((double)y * this.zoom + this.fractionalY), selectionStart, selectionEnd, selectionBackground, selectionForeground);
        scaled.dispose();
    }

    public void fillArc(int x, int y, int w, int h, int offset, int sweep) {
        Rectangle z = this.zoomFillRect(x, y, w, h);
        if (z.isEmpty() || sweep == 0) {
            return;
        }
        this.graphics.fillArc(z, offset, sweep);
    }

    public void fillGradient(int x, int y, int w, int h, boolean vertical) {
        this.graphics.fillGradient(this.zoomFillRect(x, y, w, h), vertical);
    }

    public void fillOval(int x, int y, int w, int h) {
        this.graphics.fillOval(this.zoomFillRect(x, y, w, h));
    }

    public void fillPolygon(int[] points) {
        this.graphics.fillPolygon(this.zoomPointList(points));
    }

    public void fillPolygon(PointList points) {
        this.graphics.fillPolygon(this.zoomPointList(points.toIntArray()));
    }

    public void fillRectangle(int x, int y, int w, int h) {
        this.graphics.fillRectangle(this.zoomFillRect(x, y, w, h));
    }

    public void fillRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        this.graphics.fillRoundRectangle(this.zoomFillRect(r.x, r.y, r.width, r.height), (int)((double)arcWidth * this.zoom), (int)((double)arcHeight * this.zoom));
    }

    public void fillString(String s, int x, int y) {
        if (this.allowText) {
            this.graphics.fillString(s, this.zoomTextPoint(x, y));
        }
    }

    public void fillText(String s, int x, int y) {
        if (this.allowText) {
            this.graphics.fillText(s, this.zoomTextPoint(x, y));
        }
    }

    public double getAbsoluteScale() {
        return this.zoom * this.graphics.getAbsoluteScale();
    }

    public int getAlpha() {
        return this.graphics.getAlpha();
    }

    public int getAntialias() {
        return this.graphics.getAntialias();
    }

    public Color getBackgroundColor() {
        return this.graphics.getBackgroundColor();
    }

    private Font getCachedFont(FontKey key) {
        Font font = this.fontCache.get(key);
        if (font != null) {
            return font;
        }
        key = new FontKey(key.font, key.height);
        Font zoomedFont = this.createZoomedFont(key.font, key.height);
        this.fontCache.put(key, zoomedFont);
        return zoomedFont;
    }

    private Font createZoomedFont(Font font, int height) {
        FontData[] fontData;
        FontData[] fontDataArray = fontData = font.getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData f = fontDataArray[n2];
            f.setHeight(height);
            ++n2;
        }
        return new Font((Device)Display.getCurrent(), fontData);
    }

    private FontData getCachedFontData(Font f) {
        FontData data = this.fontDataCache.get(f);
        if (data != null) {
            return data;
        }
        data = this.getLocalFont().getFontData()[0];
        this.fontDataCache.put(f, data);
        return data;
    }

    private Pattern getCachedPattern(PatternKey key) {
        GradientPattern pattern = this.patternCache.get(key);
        if (pattern != null) {
            return pattern;
        }
        key = new PatternKey(key.pattern, key.zoom);
        pattern = this.createZoomedPattern(key.pattern);
        this.patternCache.put(key, pattern);
        return pattern;
    }

    private GradientPattern createZoomedPattern(GradientPattern p1) {
        return new GradientPattern(p1.getDevice(), (float)(this.zoom * (double)p1.x1), (float)(this.zoom * (double)p1.y1), (float)(this.zoom * (double)p1.x2), (float)(this.zoom * (double)p1.y2), p1.color1, p1.alpha1, p1.color2, p1.alpha2);
    }

    public Rectangle getClip(Rectangle rect) {
        this.graphics.getClip(rect);
        int x = (int)((double)rect.x / this.zoom);
        int y = (int)((double)rect.y / this.zoom);
        rect.width = (int)Math.ceil((double)rect.right() / this.zoom) - x;
        rect.height = (int)Math.ceil((double)rect.bottom() / this.zoom) - y;
        rect.x = x;
        rect.y = y;
        return rect;
    }

    public int getFillRule() {
        return this.graphics.getFillRule();
    }

    public Font getFont() {
        return this.getLocalFont();
    }

    public FontMetrics getFontMetrics() {
        return FigureUtilities.getFontMetrics((Font)this.localFont);
    }

    public Color getForegroundColor() {
        return this.graphics.getForegroundColor();
    }

    public int getInterpolation() {
        return this.graphics.getInterpolation();
    }

    public int getLineCap() {
        return this.graphics.getLineCap();
    }

    public int getLineJoin() {
        return this.graphics.getLineJoin();
    }

    public int getLineStyle() {
        return this.graphics.getLineStyle();
    }

    public int getLineWidth() {
        return (int)this.getLocalLineWidth();
    }

    public float getLineWidthFloat() {
        return this.getLocalLineWidth();
    }

    protected final Font getLocalFont() {
        return this.localFont;
    }

    protected final float getLocalLineWidth() {
        return this.localLineWidth;
    }

    public int getTextAntialias() {
        return this.graphics.getTextAntialias();
    }

    public boolean getXORMode() {
        return this.graphics.getXORMode();
    }

    public void popState() {
        this.graphics.popState();
        --this.stackPointer;
        this.restoreLocalState(this.stack.get(this.stackPointer));
        if (this.lastClipPath != null) {
            this.lastClipPath.dispose();
            this.lastClipPath = null;
        }
    }

    public void pushState() {
        if (this.stack.size() > this.stackPointer) {
            State s = this.stack.get(this.stackPointer);
            s.setValues(this.zoom, this.fractionalX, this.fractionalY, this.getLocalFont(), this.getLocalLineWidth(), this.localDash, this.localBackground, this.localForeground);
        } else {
            this.stack.add(new State(this.zoom, this.fractionalX, this.fractionalY, this.getLocalFont(), this.getLocalLineWidth(), this.localDash, this.localBackground, this.localForeground));
        }
        ++this.stackPointer;
        this.graphics.pushState();
    }

    protected void restoreLocalState(State state) {
        this.fractionalX = state.appliedX;
        this.fractionalY = state.appliedY;
        this.setScale(state.zoom);
        this.setLocalFont(state.font);
        this.setLocalLineWidth(state.lineWidth);
        this.setLocalLineDash(state.lineDash);
        this.setLocalBackgroundPattern(state.background);
        this.setLocalForegroundPattern(state.foreground);
    }

    public void restoreState() {
        this.graphics.restoreState();
        this.restoreLocalState(this.stack.get(this.stackPointer - 1));
    }

    public void scale(double amount) {
        this.setScale(this.zoom * amount);
    }

    public void setAlpha(int alpha) {
        this.graphics.setAlpha(alpha);
    }

    public void setAntialias(int value) {
        this.graphics.setAntialias(value);
    }

    public void setBackgroundColor(Color rgb) {
        this.graphics.setBackgroundColor(rgb);
    }

    public void setClip(Rectangle r) {
        this.graphics.setClip(this.zoomClipRect(r));
    }

    public void setFillRule(int rule) {
        this.graphics.setFillRule(rule);
    }

    public void setFont(Font f) {
        this.setLocalFont(f);
    }

    public void setForegroundColor(Color rgb) {
        this.graphics.setForegroundColor(rgb);
    }

    public void setInterpolation(int interpolation) {
        this.graphics.setInterpolation(interpolation);
    }

    public void setLineCap(int cap) {
        this.graphics.setLineCap(cap);
    }

    public void setLineDash(int[] dash) {
        this.setLocalLineDash(dash);
    }

    private void setLocalLineDash(int[] dash) {
        this.localDash = dash;
        if (dash != null) {
            this.graphics.setLineDash(this.zoomDash(dash));
        }
    }

    public void setLineJoin(int join) {
        this.graphics.setLineJoin(join);
    }

    public void setLineStyle(int style) {
        this.graphics.setLineStyle(style);
    }

    public void setLineWidth(int width) {
        this.setLineWidthFloat(width);
    }

    public void setLineWidthFloat(float width) {
        this.setLocalLineWidth(width);
    }

    private void setLocalFont(Font f) {
        this.localFont = f;
        this.graphics.setFont(this.zoomFont(f));
    }

    private void setLocalLineWidth(float width) {
        this.localLineWidth = width;
        this.graphics.setLineWidth((int)this.zoomLineWidth(width));
    }

    void setScale(double value) {
        if (this.zoom == value) {
            return;
        }
        this.zoom = value;
        this.graphics.setFont(this.zoomFont(this.getLocalFont()));
        this.graphics.setLineWidth((int)this.zoomLineWidth(this.getLocalLineWidth()));
        if (this.localDash != null) {
            this.graphics.setLineDash(this.zoomDash(this.localDash));
        }
        if (this.localBackground != null) {
            this.graphics.setBackgroundPattern(this.zoomPattern(this.localBackground));
        }
        if (this.localForeground != null) {
            this.graphics.setForegroundPattern(this.zoomPattern(this.localForeground));
        }
    }

    public void setTextAntialias(int value) {
        this.graphics.setTextAntialias(value);
    }

    public void setXORMode(boolean b) {
        this.graphics.setXORMode(b);
    }

    public void translate(int dx, int dy) {
        double dxFloat = (double)dx * this.zoom + this.fractionalX;
        double dyFloat = (double)dy * this.zoom + this.fractionalY;
        this.fractionalX = dxFloat - Math.floor(dxFloat);
        this.fractionalY = dyFloat - Math.floor(dyFloat);
        this.graphics.translate((int)Math.floor(dxFloat), (int)Math.floor(dyFloat));
    }

    private Rectangle zoomClipRect(Rectangle r) {
        this.tempRECT.x = (int)Math.floor((double)r.x * this.zoom + this.fractionalX);
        this.tempRECT.y = (int)Math.floor((double)r.y * this.zoom + this.fractionalY);
        this.tempRECT.width = (int)Math.ceil((double)(r.x + r.width) * this.zoom + this.fractionalX) - this.tempRECT.x;
        this.tempRECT.height = (int)Math.ceil((double)(r.y + r.height) * this.zoom + this.fractionalY) - this.tempRECT.y;
        return this.tempRECT;
    }

    private Rectangle zoomFillRect(int x, int y, int w, int h) {
        this.tempRECT.x = (int)Math.floor((double)x * this.zoom + this.fractionalX);
        this.tempRECT.y = (int)Math.floor((double)y * this.zoom + this.fractionalY);
        this.tempRECT.width = (int)Math.floor((double)(x + w - 1) * this.zoom + this.fractionalX) - this.tempRECT.x + 1;
        this.tempRECT.height = (int)Math.floor((double)(y + h - 1) * this.zoom + this.fractionalY) - this.tempRECT.y + 1;
        return this.tempRECT;
    }

    private Font zoomFont(Font f) {
        FontData data;
        int zoomedFontHeight;
        if (f == null) {
            f = Display.getCurrent().getSystemFont();
        }
        this.allowText = (zoomedFontHeight = this.zoomFontHeight((data = this.getCachedFontData(f)).getHeight())) > 0;
        this.fontKey.setValues(f, zoomedFontHeight);
        return this.getCachedFont(this.fontKey);
    }

    protected int zoomFontHeight(int height) {
        return (int)(this.zoom * (double)height);
    }

    protected float zoomLineWidth(float w) {
        return (float)(this.zoom * (double)w);
    }

    private int[] zoomPointList(int[] points) {
        int[] scaled = null;
        int i = 0;
        while (i < intArrayCache.length) {
            if (intArrayCache[i].length == points.length) {
                scaled = intArrayCache[i];
                if (i != 0) {
                    int[] temp = intArrayCache[i - 1];
                    ScaledGraphics.intArrayCache[i - 1] = scaled;
                    ScaledGraphics.intArrayCache[i] = temp;
                }
            }
            ++i;
        }
        if (scaled == null) {
            ScaledGraphics.intArrayCache[ScaledGraphics.intArrayCache.length - 1] = new int[points.length];
            scaled = intArrayCache[intArrayCache.length - 1];
        }
        i = 0;
        while (i + 1 < points.length) {
            scaled[i] = (int)Math.floor((double)points[i] * this.zoom + this.fractionalX);
            scaled[i + 1] = (int)Math.floor((double)points[i + 1] * this.zoom + this.fractionalY);
            i += 2;
        }
        return scaled;
    }

    protected Rectangle zoomRect(int x, int y, int w, int h) {
        this.tempRECT.x = (int)Math.floor((double)x * this.zoom + this.fractionalX);
        this.tempRECT.y = (int)Math.floor((double)y * this.zoom + this.fractionalY);
        this.tempRECT.width = (int)Math.floor((double)(x + w) * this.zoom + this.fractionalX) - this.tempRECT.x;
        this.tempRECT.height = (int)Math.floor((double)(y + h) * this.zoom + this.fractionalY) - this.tempRECT.y;
        return this.tempRECT;
    }

    private TextLayout zoomTextLayout(TextLayout layout) {
        TextLayout zoomed = new TextLayout((Device)Display.getCurrent());
        zoomed.setText(layout.getText());
        int zoomWidth = -1;
        if (layout.getWidth() != -1) {
            zoomWidth = (int)((double)layout.getWidth() * this.zoom);
        }
        if (zoomWidth < -1 || zoomWidth == 0) {
            return null;
        }
        zoomed.setFont(this.zoomFont(layout.getFont()));
        zoomed.setAlignment(layout.getAlignment());
        zoomed.setAscent(layout.getAscent());
        zoomed.setDescent(layout.getDescent());
        zoomed.setOrientation(layout.getOrientation());
        zoomed.setSegments(layout.getSegments());
        zoomed.setSpacing(layout.getSpacing());
        zoomed.setTabs(layout.getTabs());
        zoomed.setWidth(zoomWidth);
        int length = layout.getText().length();
        if (length > 0) {
            int start = 0;
            int offset = 1;
            TextStyle style = null;
            TextStyle lastStyle = layout.getStyle(0);
            while (offset <= length) {
                if (offset == length || (style = layout.getStyle(offset)) != lastStyle) {
                    int end = offset - 1;
                    if (lastStyle != null) {
                        TextStyle zoomedStyle = new TextStyle(this.zoomFont(lastStyle.font), lastStyle.foreground, lastStyle.background);
                        zoomedStyle.metrics = lastStyle.metrics;
                        zoomedStyle.rise = lastStyle.rise;
                        zoomedStyle.strikeout = lastStyle.strikeout;
                        zoomedStyle.underline = lastStyle.underline;
                        zoomed.setStyle(zoomedStyle, start, end);
                    }
                    lastStyle = style;
                    start = offset;
                }
                ++offset;
            }
        }
        return zoomed;
    }

    private Point zoomTextPoint(int x, int y) {
        FontMetrics metric;
        if (this.localCache.font != this.localFont) {
            metric = FigureUtilities.getFontMetrics((Font)this.localFont);
            this.localCache.height = metric.getHeight() - metric.getDescent();
            this.localCache.font = this.localFont;
        }
        if (this.targetCache.font != this.graphics.getFont()) {
            metric = this.graphics.getFontMetrics();
            this.targetCache.font = this.graphics.getFont();
            this.targetCache.height = metric.getHeight() - metric.getDescent();
        }
        return new Point((int)Math.floor((double)x * this.zoom + this.fractionalX), (int)Math.floor((double)(y + this.localCache.height - 1) * this.zoom - (double)this.targetCache.height + 1.0 + this.fractionalY));
    }

    protected Graphics getGraphics() {
        return this.graphics;
    }

    public void drawPath(Path path) {
        Path zoomPath = this.zoomPath(path);
        this.getGraphics().drawPath(zoomPath);
        zoomPath.dispose();
    }

    public void fillPath(Path path) {
        Path zoomPath = this.zoomPath(path);
        this.getGraphics().fillPath(zoomPath);
        zoomPath.dispose();
    }

    private Path zoomPath(Path path) {
        PathData data = path.getPathData();
        Path newPath = new Path(path.getDevice());
        int index = 0;
        byte[] byArray = data.types;
        int n = data.types.length;
        int n2 = 0;
        while (n2 < n) {
            byte type = byArray[n2];
            switch (type) {
                case 1: {
                    newPath.moveTo((float)(this.zoom * (double)data.points[index++]), (float)(this.zoom * (double)data.points[index++]));
                    break;
                }
                case 2: {
                    newPath.lineTo((float)(this.zoom * (double)data.points[index++]), (float)(this.zoom * (double)data.points[index++]));
                    break;
                }
                case 4: {
                    newPath.cubicTo((float)(this.zoom * (double)data.points[index++]), (float)(this.zoom * (double)data.points[index++]), (float)(this.zoom * (double)data.points[index++]), (float)(this.zoom * (double)data.points[index++]), (float)(this.zoom * (double)data.points[index++]), (float)(this.zoom * (double)data.points[index++]));
                    break;
                }
                case 3: {
                    newPath.quadTo((float)(this.zoom * (double)data.points[index++]), (float)(this.zoom * (double)data.points[index++]), (float)(this.zoom * (double)data.points[index++]), (float)(this.zoom * (double)data.points[index++]));
                    break;
                }
                case 5: {
                    newPath.close();
                }
            }
            ++n2;
        }
        return newPath;
    }

    public void setBackgroundPattern(Pattern pattern) {
        this.setLocalBackgroundPattern(pattern);
    }

    public void setForegroundPattern(Pattern pattern) {
        this.setLocalForegroundPattern(pattern);
    }

    private void setLocalBackgroundPattern(Pattern pattern) {
        this.localBackground = pattern;
        this.graphics.setBackgroundPattern(this.zoomPattern(pattern));
    }

    private void setLocalForegroundPattern(Pattern pattern) {
        this.localForeground = pattern;
        this.graphics.setForegroundPattern(this.zoomPattern(pattern));
    }

    private int[] zoomDash(int[] dash) {
        if (dash == null || dash.length == 0) {
            dash = new int[]{1};
            return dash;
        }
        int[] d = new int[dash.length];
        int i = 0;
        while (i < d.length) {
            d[i] = Math.max(1, (int)(this.zoom * (double)dash[i]));
            ++i;
        }
        return d;
    }

    protected Pattern zoomPattern(Pattern pattern) {
        if (!(pattern instanceof GradientPattern)) {
            return pattern;
        }
        this.patternKey.setValues((GradientPattern)pattern, this.zoom);
        return this.getCachedPattern(this.patternKey);
    }

    public void rotate(float degrees) {
        this.graphics.rotate(degrees);
    }

    public void translate(float dx, float dy) {
        this.graphics.translate(dx, dy);
    }

    public void setClip(Path path) {
        Path p = path == null ? null : this.zoomPath(path);
        this.graphics.setClip(p);
        if (this.lastClipPath != null) {
            this.lastClipPath.dispose();
            this.lastClipPath = null;
        }
        if (p != path) {
            this.lastClipPath = p;
        }
    }

    public void clipPath(Path path) {
        Path scaledPath = this.createScaledPath(path);
        try {
            this.graphics.clipPath(scaledPath);
        }
        finally {
            scaledPath.dispose();
        }
    }

    private Path createScaledPath(Path path) {
        PathData p = path.getPathData();
        int i = 0;
        while (i < p.points.length) {
            p.points[i] = (float)((double)p.points[i] * this.zoom + this.fractionalX);
            p.points[i + 1] = (float)((double)p.points[i + 1] * this.zoom + this.fractionalY);
            i += 2;
        }
        Path scaledPath = new Path(path.getDevice());
        int index = 0;
        int i2 = 0;
        while (i2 < p.types.length) {
            byte type = p.types[i2];
            switch (type) {
                case 1: {
                    scaledPath.moveTo(p.points[index], p.points[index + 1]);
                    index += 2;
                    break;
                }
                case 2: {
                    scaledPath.lineTo(p.points[index], p.points[index + 1]);
                    index += 2;
                    break;
                }
                case 4: {
                    scaledPath.cubicTo(p.points[index], p.points[index + 1], p.points[index + 2], p.points[index + 3], p.points[index + 4], p.points[index + 5]);
                    index += 6;
                    break;
                }
                case 3: {
                    scaledPath.quadTo(p.points[index], p.points[index + 1], p.points[index + 2], p.points[index + 3]);
                    index += 4;
                    break;
                }
                case 5: {
                    scaledPath.close();
                }
            }
            ++i2;
        }
        return scaledPath;
    }

    public boolean getAdvanced() {
        return this.graphics.getAdvanced();
    }

    public LineAttributes getLineAttributes() {
        LineAttributes a = this.graphics.getLineAttributes();
        a.width = this.getLocalLineWidth();
        return a;
    }

    public float getLineMiterLimit() {
        return this.graphics.getLineMiterLimit();
    }

    public void setAdvanced(boolean advanced) {
        this.graphics.setAdvanced(advanced);
    }

    public void setLineMiterLimit(float miterLimit) {
        this.graphics.setLineMiterLimit(miterLimit);
    }

    public void setLineAttributes(LineAttributes attributes) {
        this.graphics.setLineAttributes(attributes);
        this.setLocalLineWidth(attributes.width);
    }

    public void setLineDash(float[] value) {
        this.graphics.setLineDash(value);
    }

    private static class FontHeightCache {
        Font font;
        int height;

        private FontHeightCache() {
        }
    }

    protected static class FontKey {
        Font font;
        int height;

        protected FontKey() {
        }

        protected FontKey(Font font, int height) {
            this.font = font;
            this.height = height;
        }

        public boolean equals(Object obj) {
            return ((FontKey)obj).font.equals((Object)this.font) && ((FontKey)obj).height == this.height;
        }

        public int hashCode() {
            return this.font.hashCode() ^ this.height;
        }

        protected void setValues(Font font, int height) {
            this.font = font;
            this.height = height;
        }
    }

    private static class PatternKey {
        GradientPattern pattern;
        double zoom;

        PatternKey() {
        }

        PatternKey(GradientPattern pattern, double zoom) {
            this.pattern = pattern;
            this.zoom = zoom;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof PatternKey)) {
                return false;
            }
            PatternKey that = (PatternKey)obj;
            return ((Object)((Object)this.pattern)).equals((Object)that.pattern) && this.zoom == that.zoom;
        }

        public int hashCode() {
            long bits = Double.doubleToLongBits(this.zoom);
            int hc = (int)(bits ^ bits >>> 32);
            return ((Object)((Object)this.pattern)).hashCode() ^ hc;
        }

        void setValues(GradientPattern pattern, double zoom) {
            this.pattern = pattern;
            this.zoom = zoom;
        }
    }

    protected static class State {
        private double appliedX;
        private double appliedY;
        private Font font;
        private float lineWidth;
        private double zoom;
        private int[] lineDash;
        private Pattern background;
        private Pattern foreground;

        protected State() {
        }

        protected State(double zoom, double x, double y, Font font, float lineWidth, int[] lineDash, Pattern background, Pattern foreground) {
            this.zoom = zoom;
            this.appliedX = x;
            this.appliedY = y;
            this.font = font;
            this.lineWidth = lineWidth;
            this.lineDash = lineDash;
            this.background = background;
            this.foreground = foreground;
        }

        protected void setValues(double zoom, double x, double y, Font font, float lineWidth, int[] lineDash, Pattern background, Pattern foreground) {
            this.zoom = zoom;
            this.appliedX = x;
            this.appliedY = y;
            this.font = font;
            this.lineWidth = lineWidth;
            this.lineDash = lineDash;
            this.background = background;
            this.foreground = foreground;
        }
    }
}

