/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.IOriginBased;
import org.xmind.gef.draw2d.IReferenceDescriptor;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.draw2d.IReferencedLayout;
import org.xmind.gef.draw2d.geometry.Geometry;

public class ReferencedFigure
extends Figure
implements IReferencedFigure {
    private IReferenceDescriptor referenceDescriptor = null;
    private Insets refDesc = null;
    private Point reference = null;
    private Point lastReference = null;

    public int getOrientation() {
        return Geometry.getOrientation(this.getReference(), this.getOrigin());
    }

    public Rectangle getPreferredBounds(Point reference) {
        return Geometry.getExpanded(reference, this.getReferenceDescription());
    }

    public Rectangle getPreferredBounds(Rectangle rect, Point reference) {
        Insets ins = this.getReferenceDescription();
        rect.setLocation(reference.x - ins.left, reference.y - ins.top);
        rect.setSize(ins.getWidth(), ins.getHeight());
        return rect;
    }

    public Rectangle getPreferredClientArea(Point reference) {
        if (this.getLayoutManager() instanceof IReferencedLayout) {
            Rectangle area = ((IReferencedLayout)this.getLayoutManager()).getPreferredClientArea(this);
            return area.getTranslated(reference);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public Point getReference() {
        if (this.reference == null) {
            this.lastReference = this.reference = this.calculateReference(this.getBounds());
        }
        return this.reference;
    }

    protected Point calculateReference(Rectangle bounds) {
        Insets ins = this.getReferenceDescription();
        int insWidth = ins.getWidth();
        int insHeight = ins.getHeight();
        int x = bounds.x;
        int y = bounds.y;
        if (bounds.width == insWidth) {
            x += ins.left;
        } else if (insWidth > 0) {
            x += bounds.width * ins.left / insWidth;
        }
        if (bounds.height == insHeight) {
            y += ins.top;
        } else if (insHeight > 0) {
            y += bounds.height * ins.top / insHeight;
        }
        return new Point(x, y);
    }

    public Insets getReferenceDescription() {
        if (this.refDesc != null) {
            return this.refDesc;
        }
        IReferenceDescriptor descriptor = this.getReferenceDescriptor();
        if (descriptor != null) {
            this.refDesc = descriptor.getReferenceDescription(this);
        }
        if (this.refDesc == null) {
            this.refDesc = this.calculateDefaultReferenceDescription(this.getPreferredSize());
        }
        return this.refDesc;
    }

    protected Insets calculateDefaultReferenceDescription(Dimension preferredSize) {
        int h = preferredSize.height / 2;
        int w = preferredSize.width / 2;
        return new Insets(h, w, preferredSize.height - h, preferredSize.width - w);
    }

    public IReferenceDescriptor getReferenceDescriptor() {
        return this.referenceDescriptor;
    }

    public void setReference(Point reference) {
        if (reference != null) {
            this.setReference(reference.x, reference.y);
        }
    }

    public void setReference(int referenceX, int referenceY) {
        this.setLocation(this.calculateLocation(referenceX, referenceY));
    }

    protected Point calculateLocation(int refX, int refY) {
        int width = this.bounds.width;
        int height = this.bounds.height;
        Insets ins = this.getReferenceDescription();
        int insWidth = ins.getWidth();
        int insHeight = ins.getHeight();
        if (width == insWidth) {
            refX -= ins.left;
        } else if (insWidth > 0) {
            refX -= width * ins.left / insWidth;
        }
        if (height == insHeight) {
            refY -= ins.top;
        } else if (insHeight > 0) {
            refY -= height * ins.top / insHeight;
        }
        return new Point(refX, refY);
    }

    public void setReferenceDescriptor(IReferenceDescriptor descriptor) {
        if (descriptor == this.referenceDescriptor) {
            return;
        }
        this.referenceDescriptor = descriptor;
        this.revalidate();
    }

    public Point getOrigin() {
        IOriginBased originBased = this.getOriginBasedAncestor(this);
        if (originBased != null) {
            return originBased.getOrigin();
        }
        return this.getReference();
    }

    private IOriginBased getOriginBasedAncestor(IFigure fig) {
        IFigure parent = fig.getParent();
        if (parent == null) {
            return null;
        }
        if (parent instanceof IOriginBased) {
            return (IOriginBased)parent;
        }
        return this.getOriginBasedAncestor(parent);
    }

    protected void fireFigureMoved() {
        this.reference = null;
        super.fireFigureMoved();
    }

    public void invalidate() {
        super.invalidate();
        this.reference = null;
        this.refDesc = null;
    }

    public Point getLastReference() {
        if (this.lastReference == null) {
            this.lastReference = this.getReference();
        }
        return this.lastReference;
    }
}

