/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d;

import java.util.Iterator;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.IDecoratedFigure;
import org.xmind.gef.draw2d.IDecoratedFigureListener;
import org.xmind.gef.draw2d.IReferencedLayout;
import org.xmind.gef.draw2d.ReferencedFigure;
import org.xmind.gef.draw2d.decoration.IDecoration;
import org.xmind.gef.draw2d.decoration.IShapeDecorationEx;
import org.xmind.gef.draw2d.graphics.GraphicsUtils;

public class DecoratedShapeFigure
extends ReferencedFigure
implements IDecoratedFigure {
    private IShapeDecorationEx shape = null;
    private Insets prefInsets = null;
    private Insets insets = null;

    public IShapeDecorationEx getDecoration() {
        return this.shape;
    }

    public void setDecoration(IShapeDecorationEx shape) {
        IShapeDecorationEx oldShape = this.shape;
        if (shape == oldShape) {
            return;
        }
        if (oldShape != null) {
            oldShape.invalidate();
        }
        this.shape = shape;
        this.revalidate();
        this.fireDecorationChanged(oldShape, shape);
        this.repaint();
    }

    public void addDecoratedFigureListener(IDecoratedFigureListener listener) {
        this.addListener(IDecoratedFigureListener.class, listener);
    }

    public void removeDecoratedFigureListener(IDecoratedFigureListener listener) {
        this.removeListener(IDecoratedFigureListener.class, listener);
    }

    protected void fireDecorationChanged(IDecoration oldDecoration, IDecoration newDecoration) {
        Iterator listeners = this.getListeners(IDecoratedFigureListener.class);
        while (listeners.hasNext()) {
            ((IDecoratedFigureListener)listeners.next()).decorationChanged(this, oldDecoration, newDecoration);
        }
    }

    public boolean containsPoint(int x, int y) {
        if (this.shape != null) {
            return this.shape.containsPoint(this, x, y);
        }
        return super.containsPoint(x, y);
    }

    public Insets getInsets() {
        if (this.insets != null) {
            return this.insets;
        }
        return this.getPreferredInsets();
    }

    public void setInsets(Insets ins) {
        if (ins == this.insets || ins != null && ins.equals((Object)this.insets)) {
            return;
        }
        if (ins == null) {
            this.insets = null;
        } else if (this.insets != null) {
            this.insets.top = ins.top;
            this.insets.bottom = ins.bottom;
            this.insets.left = ins.left;
            this.insets.right = ins.right;
        } else {
            this.insets = new Insets(ins);
        }
        this.revalidate();
    }

    public Insets getPreferredInsets() {
        if (this.prefInsets == null) {
            this.prefInsets = this.calculatePreferredInsets();
        }
        return this.prefInsets;
    }

    protected Insets calculatePreferredInsets() {
        if (this.shape != null) {
            int hHint;
            int wHint;
            if (this.getLayoutManager() instanceof IReferencedLayout) {
                Rectangle area = ((IReferencedLayout)this.getLayoutManager()).getPreferredClientArea(this);
                wHint = area.width;
                hHint = area.height;
            } else {
                wHint = 0;
                hHint = 0;
            }
            return this.shape.getPreferredInsets(this, wHint, hHint);
        }
        return NO_INSETS;
    }

    public void invalidate() {
        if (this.shape != null) {
            this.shape.invalidate();
        }
        this.prefInsets = null;
        super.invalidate();
    }

    public void paint(Graphics graphics) {
        GraphicsUtils.fixGradientBugForCarbon(graphics, this);
        super.paint(graphics);
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        graphics.setAntialias(1);
        if (this.shape != null) {
            this.shape.paint(this, graphics);
        }
    }
}

