/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.command;

import java.util.ArrayList;
import java.util.List;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CommandStackBase;
import org.xmind.gef.command.CommandStackEvent;
import org.xmind.gef.command.ICommandStack2;
import org.xmind.gef.command.ICommandStack3;
import org.xmind.gef.command.ICommandStackDelegate;
import org.xmind.gef.command.ICommandStackListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandStack
extends CommandStackBase
implements ICommandStack2,
ICommandStack3 {
    protected List<Command> commandList;
    private int currentLocation = -1;
    private int saveLocation = -1;
    private boolean alwaysDirty = false;
    private ICommandStackDelegate delegate = null;
    private DelegateListener delegateListener = null;
    private boolean inCompoundCommand = false;
    private Command compoundCommand = null;

    public CommandStack() {
        this(DEFAULT_UNDO_LIMIT);
    }

    public CommandStack(int undoLimit) {
        super(undoLimit);
        this.commandList = new ArrayList<Command>(undoLimit);
    }

    @Override
    public void startCompoundCommand() {
        if (this.delegate instanceof ICommandStack3) {
            ((ICommandStack3)((Object)this.delegate)).startCompoundCommand();
            return;
        }
        this.inCompoundCommand = true;
    }

    @Override
    public void endCompoundCommand() {
        if (this.delegate instanceof ICommandStack3) {
            ((ICommandStack3)((Object)this.delegate)).endCompoundCommand();
            return;
        }
        this.inCompoundCommand = false;
        if (this.compoundCommand != null) {
            Command command = this.compoundCommand;
            this.compoundCommand = null;
            this.postExecute(command);
        }
    }

    @Override
    public void execute(Command command) {
        if (this.delegate != null && this.delegate.canExecute(command)) {
            this.delegate.execute(command);
            return;
        }
        if (command == null || !command.canExecute()) {
            return;
        }
        this.fireEvent(command, 1);
        this.beginTransaction();
        command.execute();
        if (this.inCompoundCommand) {
            if (this.compoundCommand == null) {
                this.compoundCommand = command;
                return;
            }
            this.endCompoundCommand();
        }
        this.endTransaction(command, 1);
        this.postExecute(command);
    }

    private void postExecute(Command command) {
        this.fireEvent(command, 8);
        if (command.canUndo()) {
            this.pushCommand(command);
        }
        this.fireEvent(null, 128);
    }

    private void pushCommand(Command cmd) {
        this.discardRedoables();
        this.commandList.add(cmd);
        if (this.saveLocation > this.currentLocation) {
            this.saveLocation = -1;
        }
        ++this.currentLocation;
        this.fireEvent(cmd, 64);
        if (this.getUndoLimit() > 0 && this.currentLocation >= this.getUndoLimit()) {
            Command discarded = this.commandList.remove(0);
            if (discarded != null) {
                discarded.dispose();
            }
            --this.currentLocation;
            if (this.saveLocation >= 0) {
                --this.saveLocation;
            }
            this.alwaysDirty = true;
        }
    }

    private void discardRedoables() {
        while (this.commandList.size() - 1 > this.currentLocation) {
            Command discarded = this.commandList.remove(this.commandList.size() - 1);
            if (discarded == null) continue;
            discarded.dispose();
        }
    }

    public List<Command> getCommandList() {
        return this.commandList;
    }

    @Override
    public boolean canUndo() {
        if (this.delegate != null) {
            return this.delegate.canUndo();
        }
        return this.currentLocation >= 0;
    }

    @Override
    public void undo() {
        if (this.delegate != null && this.delegate.canUndo()) {
            this.delegate.undo();
            return;
        }
        Command undoCmd = this.commandList.get(this.currentLocation);
        if (undoCmd.canUndo()) {
            this.beginTransaction();
            this.fireEvent(undoCmd, 4);
            undoCmd.undo();
            this.endTransaction(undoCmd, 4);
            --this.currentLocation;
            this.fireEvent(undoCmd, 32);
        } else {
            --this.currentLocation;
        }
        this.fireEvent(null, 128);
    }

    public void undo(boolean discard) {
        this.undo();
        if (discard) {
            this.discardRedoables();
        }
    }

    @Override
    public boolean canRedo() {
        if (this.delegate != null) {
            return this.delegate.canRedo();
        }
        return this.currentLocation < this.commandList.size() - 1;
    }

    @Override
    public void redo() {
        if (this.delegate != null && this.delegate.canRedo()) {
            this.delegate.redo();
            return;
        }
        Command redoCmd = this.commandList.get(this.currentLocation + 1);
        if (redoCmd.canExecute()) {
            this.fireEvent(redoCmd, 2);
            this.beginTransaction();
            redoCmd.redo();
            this.endTransaction(redoCmd, 2);
            ++this.currentLocation;
            this.fireEvent(redoCmd, 16);
        } else {
            ++this.currentLocation;
        }
        this.fireEvent(null, 128);
    }

    @Override
    public boolean isDirty() {
        if (this.delegate != null) {
            return this.delegate.isDirty();
        }
        return this.saveLocation != this.currentLocation || this.alwaysDirty;
    }

    @Override
    public void markSaved() {
        this.saveLocation = this.currentLocation;
        this.alwaysDirty = false;
    }

    @Override
    public void clear() {
        this.currentLocation = -1;
        this.saveLocation = -1;
        for (Command c : this.commandList) {
            c.dispose();
        }
        this.commandList.clear();
        this.fireEvent(null, 128);
    }

    @Override
    public String getRedoLabel() {
        if (this.delegate != null && this.delegate.canRedo()) {
            return this.delegate.getRedoLabel();
        }
        return this.commandList.get(this.currentLocation + 1).getLabel();
    }

    @Override
    public String getUndoLabel() {
        if (this.delegate != null && this.delegate.canUndo()) {
            return this.delegate.getUndoLabel();
        }
        return this.commandList.get(this.currentLocation).getLabel();
    }

    @Override
    public void setUndoLimit(int undoLimit) {
        super.setUndoLimit(undoLimit);
        while (undoLimit > 0 && this.commandList.size() > undoLimit) {
            this.deleteFirst();
        }
        this.fireEvent(null, 128);
    }

    private void deleteFirst() {
        Command cmd;
        if (this.commandList.size() > 0 && (cmd = this.commandList.remove(0)) != null) {
            cmd.dispose();
            if (this.saveLocation >= 0) {
                --this.saveLocation;
            }
            if (this.currentLocation >= 0) {
                --this.currentLocation;
            }
            this.alwaysDirty = true;
        }
    }

    @Override
    public void setDelegate(ICommandStackDelegate delegate) {
        if (delegate == this.delegate) {
            return;
        }
        if (this.delegate != null && this.delegateListener != null) {
            this.delegate.removeCSListener(this.delegateListener);
        }
        this.delegate = delegate;
        if (delegate != null) {
            if (this.delegateListener == null) {
                this.delegateListener = new DelegateListener();
            }
            delegate.addCSListener(this.delegateListener);
        } else {
            this.delegateListener = null;
        }
        this.fireEvent(null, 128);
    }

    @Override
    public ICommandStackDelegate getDelegate() {
        return this.delegate;
    }

    @Override
    public void dispose() {
        this.setDelegate(null);
        super.dispose();
    }

    private class DelegateListener
    implements ICommandStackListener {
        private DelegateListener() {
        }

        public void handleCommandStackEvent(CommandStackEvent event) {
            CommandStack.this.fireEvent(event);
        }
    }
}

