/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.dashboard;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.xmind.cathy.internal.WorkbenchMessages;
import org.xmind.core.util.FileUtils;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IViewer;
import org.xmind.gef.event.KeyEvent;
import org.xmind.gef.part.IPart;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.ui.internal.SpaceCollaborativeEngine;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.CategorizedGalleryViewer;
import org.xmind.ui.gallery.GalleryEditTool;
import org.xmind.ui.gallery.GalleryLayout;
import org.xmind.ui.gallery.GallerySelectTool;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.internal.ClonedTemplate;
import org.xmind.ui.internal.TemplateGroup;
import org.xmind.ui.internal.wizards.TemplateLabelProvider;
import org.xmind.ui.mindmap.ITemplate;
import org.xmind.ui.mindmap.ITemplateGroup;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.texteditor.FloatingTextEditor;

public class CategorizedTemplateViewer
extends CategorizedGalleryViewer
implements IAdaptable {
    private static final int FRAME_WIDTH = 210;
    private static final int FRAME_HEIGHT = 130;
    private List<ITemplateGroup> sysTemplateGroups;
    private ResourceManager localResourceManager;

    public CategorizedTemplateViewer(Composite container) {
        this.setSectionStyle(16482);
        this.create(container);
    }

    private void create(Composite parent) {
        this.localResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.setContentProvider((IContentProvider)new CategorizedTemplateContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new CategorizedTemplateLabelProvider());
        EditDomain domain = new EditDomain();
        domain.installTool("select tool", (ITool)new TemplateGallerySelectTool());
        domain.installTool("edit tool", (ITool)new TemplateNameEditTool());
        this.setEditDomain(domain);
        this.initProperties();
        this.createControl(parent, 64);
        this.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CategorizedTemplateViewer.this.handleDispose();
            }
        });
        this.setInput(this.getViewerInput());
        this.registerHelper(parent.getShell());
    }

    private void handleDispose() {
        this.unregisterHelper(this.getControl().getShell());
    }

    private void initProperties() {
        Properties properties = this.getProperties();
        properties.set("org.xmind.ui.gallery.horizontal", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.wrap", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.titlePlacement", (Object)GalleryViewer.TITLE_BOTTOM);
        properties.set("org.xmind.ui.gallery.singleClickToOpen", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.solidFrames", true);
        properties.set("org.xmind.ui.gallery.flatFrames", true);
        properties.set("constrained", true);
        properties.set("stretched", true);
        properties.set("org.xmind.ui.gallery.layout", (Object)new GalleryLayout(1, 1, 30, 0, new Insets(10, 0, 20, 65)));
        properties.set("org.xmind.ui.gallery.contentPaneBorderWidth", 1);
        properties.set("org.xmind.ui.gallery.contentPaneBorderColor", (Object)((Color)this.localResourceManager.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#cccccc"))));
        properties.set("org.xmind.ui.gallery.frameContentSize", (Object)new Dimension(210, 130));
        properties.set("org.xmind.ui.gallery.contentPaneSpaceCollaborativeEngine", (Object)new SpaceCollaborativeEngine());
    }

    protected void configureContainer(ScrolledForm container) {
        super.configureContainer(container);
        container.setBackground(container.getParent().getBackground());
    }

    private Object[] getViewerInput() {
        ArrayList<Object> groups = new ArrayList<Object>();
        if (this.sysTemplateGroups == null || this.sysTemplateGroups.isEmpty()) {
            this.sysTemplateGroups = MindMapUI.getResourceManager().getSystemTemplateGroups();
        }
        groups.addAll(this.sysTemplateGroups);
        List userTemplates = MindMapUI.getResourceManager().getUserTemplates();
        if (userTemplates.size() != 0) {
            TemplateGroup userGroup = new TemplateGroup(WorkbenchMessages.TemplateViewer_UserGroup_title, userTemplates);
            groups.add(userGroup);
        }
        return groups.toArray(new ITemplateGroup[groups.size()]);
    }

    protected Control createSectionContent(Composite parent, Object category) {
        parent.setBackground(parent.getParent().getBackground());
        this.getWidgetFactory().setBackground(parent.getBackground());
        return super.createSectionContent(parent, category);
    }

    protected GalleryViewer createNestedViewer() {
        return new GalleryViewer();
    }

    private void registerHelper(Shell shell) {
        shell.setData("org.xmind.ui.helper.template.rename", (Object)new Runnable(){

            @Override
            public void run() {
                Object obj;
                ISelection selection = CategorizedTemplateViewer.this.getSelection();
                if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof ITemplate) {
                    ITemplate template = (ITemplate)obj;
                    CategorizedTemplateViewer.this.startEditing(template);
                }
            }
        });
    }

    private void unregisterHelper(Shell shell) {
        shell.setData("org.xmind.ui.helper.template.rename", null);
    }

    public void userTemplateAdded(ITemplate template) {
        if (template == null || this.getControl() == null || this.getControl().isDisposed()) {
            return;
        }
        this.setInput(this.getViewerInput());
        this.refresh();
        this.reveal(new ClonedTemplate(template.getSourceWorkbookURI(), null));
    }

    public void userTemplateRemoved(ITemplate template) {
        if (template == null || this.getControl() == null || this.getControl().isDisposed()) {
            return;
        }
        this.setInput(this.getViewerInput());
    }

    private void startEditing(ITemplate template) {
        Object input = this.getInput();
        if (input instanceof ITemplateGroup[]) {
            ITemplateGroup[] groups;
            ITemplateGroup[] iTemplateGroupArray = groups = (ITemplateGroup[])input;
            int n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                ITemplateGroup group = iTemplateGroupArray[n2];
                if (group.getTemplates().contains(template)) {
                    GalleryViewer galleryViewer = this.getNestedViewer(group);
                    EditDomain domain = galleryViewer.getEditDomain();
                    ITool tool = domain.getDefaultTool();
                    ((GallerySelectTool)tool).getStatus().setStatus(1, true);
                    domain.handleRequest("edit", (IViewer)galleryViewer);
                    break;
                }
                ++n2;
            }
        }
    }

    private boolean modifyTemplateName(ITemplate template, String newName) {
        if (template == null || newName == null || newName.equals("") || newName.equals(template.getName())) {
            return false;
        }
        List userTemplates = MindMapUI.getResourceManager().getUserTemplates();
        for (ITemplate t : userTemplates) {
            if (!newName.equals(t.getName())) continue;
            return false;
        }
        URI uri = template.getSourceWorkbookURI();
        File sourceFile = URIUtil.toFile((URI)uri);
        File targetFile = new File(sourceFile.getParent(), String.valueOf(newName) + FileUtils.getExtension((String)sourceFile.getAbsolutePath()));
        boolean renameSuccess = sourceFile.renameTo(targetFile);
        Object[] input = this.getViewerInput();
        this.setInput(input);
        this.setSelection((ISelection)new StructuredSelection((Object)new ClonedTemplate(targetFile.toURI(), null)), true);
        return true;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (ISelectionProvider.class.equals(adapter)) {
            return adapter.cast((Object)this);
        }
        return null;
    }

    protected void unmapAllElements() {
    }

    private class CategorizedTemplateContentProvider
    implements ITreeContentProvider {
        private CategorizedTemplateContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ITemplateGroup[]) {
                return (ITemplateGroup[])inputElement;
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ITemplateGroup) {
                return ((ITemplateGroup)parentElement).getTemplates().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            Object input;
            if (element instanceof ITemplate && (input = CategorizedTemplateViewer.this.getInput()) instanceof ITemplateGroup[]) {
                ITemplateGroup[] groups;
                ITemplateGroup[] iTemplateGroupArray = groups = (ITemplateGroup[])input;
                int n = groups.length;
                int n2 = 0;
                while (n2 < n) {
                    ITemplateGroup group = iTemplateGroupArray[n2];
                    for (ITemplate template : group.getTemplates()) {
                        if (!template.equals(element)) continue;
                        return group;
                    }
                    ++n2;
                }
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof ITemplateGroup && ((ITemplateGroup)element).getTemplates().size() > 0;
        }
    }

    private static class CategorizedTemplateLabelProvider
    extends TemplateLabelProvider {
        private CategorizedTemplateLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ITemplateGroup) {
                String name = ((ITemplateGroup)element).getName();
                if (name == null) {
                    name = WorkbenchMessages.CategorizedTemplateViewer_group_untitiledName;
                }
                return name.length() <= 20 ? name : String.valueOf(name.substring(0, 20)) + "...";
            }
            if (element instanceof ITemplate) {
                String name = ((ITemplate)element).getName();
                if (name == null) {
                    name = WorkbenchMessages.CategorizedTemplateViewer_template_untitiledName;
                }
                return name.length() <= 20 ? name : String.valueOf(name.substring(0, 20)) + "...";
            }
            return super.getText(element);
        }
    }

    private class TemplateGallerySelectTool
    extends GallerySelectTool {
        private TemplateGallerySelectTool() {
        }

        protected boolean handleKeyUp(KeyEvent ke) {
            Object element;
            ISelection selection;
            int state = ke.getState();
            int key = ke.keyCode;
            if (state == 0 && key == 127 && (selection = CategorizedTemplateViewer.this.getSelection()) instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof ITemplate) {
                ITemplate template = (ITemplate)element;
                if (MindMapUI.getResourceManager().isUserTemplate(template) && MessageDialog.openConfirm((Shell)CategorizedTemplateViewer.this.getControl().getShell(), (String)WorkbenchMessages.ConfirmDeleteTemplateDialog_title, (String)NLS.bind((String)WorkbenchMessages.ConfirmDeleteTemplateDialog_message_withTemplateName, (Object)template.getName()))) {
                    MindMapUI.getResourceManager().removeUserTemplate(template);
                }
            }
            return super.handleKeyUp(ke);
        }
    }

    private class TemplateNameEditTool
    extends GalleryEditTool {
        private TemplateNameEditTool() {
        }

        protected IDocument getTextContents(IPart source) {
            return new Document(((ITemplate)source.getModel()).getName());
        }

        protected void handleTextModified(IPart source, IDocument document) {
            ITemplate template = (ITemplate)source.getModel();
            if (template != null) {
                CategorizedTemplateViewer.this.modifyTemplateName(template, document.get());
            }
        }

        protected void hookEditor(FloatingTextEditor editor) {
            super.hookEditor(editor);
            this.getHelper().setPrefWidth(130);
        }
    }
}

