/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.AbstractStatusHandler;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.xmind.cathy.internal.CathyPlugin;
import org.xmind.ui.internal.ToolkitPlugin;
import org.xmind.ui.internal.statushandlers.RuntimeErrorDialog;

public class CathyStatusHandler
extends AbstractStatusHandler {
    private static final String PROPERTY_PREFIX = "org.xmind.cathy.statusHandlers.adapters";
    private static final QualifiedName BLOCK = new QualifiedName("org.xmind.cathy.statusHandlers.adapters", "block");
    private List<StatusAdapter> statusQueue = new ArrayList<StatusAdapter>(4);
    private RuntimeErrorDialog currentDialog = null;

    public boolean supportsNotification(int type) {
        if (type == 1) {
            return true;
        }
        return super.supportsNotification(type);
    }

    public void handle(final StatusAdapter statusAdapter, int style) {
        if ((style & 2) == 2 || (style & 4) == 4) {
            boolean block = (style & 4) == 4;
            this.addProperties(statusAdapter, block);
            if (Display.getCurrent() != null) {
                this.showStatusAdapter(statusAdapter);
            } else if (block) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        CathyStatusHandler.this.showStatusAdapter(statusAdapter);
                    }
                });
            } else {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CathyStatusHandler.this.showStatusAdapter(statusAdapter);
                    }
                });
            }
        }
        if ((style & 1) == 1) {
            StatusManager.getManager().addLoggedStatus(statusAdapter.getStatus());
            ToolkitPlugin.getDefault().getLog().log(statusAdapter.getStatus());
        }
    }

    private void addProperties(StatusAdapter statusAdapter, boolean block) {
        if (statusAdapter.getProperty(IStatusAdapterConstants.TIMESTAMP_PROPERTY) == null) {
            statusAdapter.setProperty(IStatusAdapterConstants.TIMESTAMP_PROPERTY, (Object)System.currentTimeMillis());
        }
        statusAdapter.setProperty(BLOCK, (Object)block);
    }

    private void showStatusAdapter(StatusAdapter statusAdapter) {
        Display display;
        if (!PlatformUI.isWorkbenchRunning()) {
            ToolkitPlugin.getDefault().getLog().log(statusAdapter.getStatus());
            return;
        }
        this.statusQueue.add(statusAdapter);
        if (this.currentDialog == null) {
            this.currentDialog = this.showErrorDialogFor(statusAdapter);
        }
        if (((Boolean)statusAdapter.getProperty(BLOCK)).booleanValue() && (display = Display.getCurrent()) != null && !display.isDisposed()) {
            while (this.statusQueue.contains(statusAdapter) && !display.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
    }

    private RuntimeErrorDialog showErrorDialogFor(final StatusAdapter statusAdapter) {
        StatusManager.getManager().fireNotification(1, new StatusAdapter[]{statusAdapter});
        int style = 0;
        if (((Boolean)statusAdapter.getProperty(BLOCK)).booleanValue()) {
            style |= 1;
        }
        RuntimeErrorDialog dialog = new RuntimeErrorDialog(style, statusAdapter, null, CathyPlugin.getDefault().getErrorReporter());
        dialog.create();
        dialog.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CathyStatusHandler.this.statusQueue.remove(statusAdapter);
                if (CathyStatusHandler.this.statusQueue.size() > 0) {
                    CathyStatusHandler.this.currentDialog = CathyStatusHandler.this.showErrorDialogFor((StatusAdapter)CathyStatusHandler.this.statusQueue.get(0));
                } else {
                    CathyStatusHandler.this.currentDialog = null;
                }
            }
        });
        dialog.open();
        return dialog;
    }
}

