/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal;

import java.awt.Toolkit;
import java.io.File;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.xmind.cathy.internal.BetaVerifier;
import org.xmind.cathy.internal.CathyPlugin;
import org.xmind.cathy.internal.CathyWorkbenchAdvisor;
import org.xmind.cathy.internal.Log;
import org.xmind.cathy.internal.OpenDocumentQueue;
import org.xmind.cathy.internal.WorkbenchMessages;
import org.xmind.core.Core;
import org.xmind.core.usagedata.IUsageDataSampler;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.app.IApplicationValidator;

public class CathyApplication
implements IApplication {
    public static final String SYS_VERSION = "org.xmind.product.version";
    public static final String SYS_BUILDID = "org.xmind.product.buildid";
    public static final String SYS_BRANDING_VERSION = "org.xmind.product.brandingVersion";
    public static final String SYS_APP_STATUS = "org.xmind.cathy.app.status";

    public Object start(IApplicationContext context) throws Exception {
        String appVersion;
        String buildId = System.getProperty(SYS_BUILDID);
        if (buildId == null || "".equals(buildId)) {
            buildId = CathyApplication.calculateBuildId(context);
            System.setProperty(SYS_BUILDID, buildId);
        }
        if ((appVersion = System.getProperty(SYS_VERSION)) == null || "".equals(appVersion)) {
            appVersion = CathyApplication.extractVersionNumber(buildId);
            System.setProperty(SYS_VERSION, appVersion);
        }
        System.setProperty("org.xmind.product.about.copyright", WorkbenchMessages.About_Copyright);
        System.setProperty("org.xmind.product.about.homepage", WorkbenchMessages.About_Homepage);
        IPreferenceStore pref = MindMapUIPlugin.getDefault().getPreferenceStore();
        String name = pref.getString("org.xmind.ui.mindmap.author.name");
        if (name == null || "".equals(name)) {
            name = System.getProperty("user.name");
        }
        if (name != null) {
            System.setProperty("org.xmind.author.name", name);
        }
        if (pref.getString("org.xmind.ui.mindmap.author.email") != null) {
            System.setProperty("org.xmind.author.email", pref.getString("org.xmind.ui.mindmap.author.email"));
        }
        if (pref.getString("org.xmind.ui.mindmap.author.org") != null) {
            System.setProperty("org.xmind.author.org", pref.getString("org.xmind.ui.mindmap.author.org"));
        }
        Core.getWorkbookBuilder().setCreator("XMind", buildId);
        Display display = PlatformUI.createDisplay();
        try {
            block18: {
                Integer n;
                OpenDocumentQueue.getInstance().hook(display);
                CathyPlugin.getDefault().activateNetworkSettings();
                if (new BetaVerifier(display).shouldExitAfterBetaExpired()) {
                    Integer n2 = EXIT_OK;
                    return n2;
                }
                if (this.shouldExitEarly(context)) {
                    this.logApplicationArgs();
                    Integer n3 = EXIT_OK;
                    return n3;
                }
                this.logApplicationArgs();
                System.setProperty(SYS_APP_STATUS, "starting");
                this.initializeInternalBrowserCookies();
                WorkbenchPlugin.getDefault().getPreferenceStore().setValue("WORKBENCH_SAVE_INTERVAL", 0);
                try {
                    this.captureAppSessionInfo(CathyPlugin.getDefault().getUsageDataCollector(), context, buildId);
                    int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new CathyWorkbenchAdvisor());
                    if (returnCode != 1) break block18;
                    n = EXIT_RESTART;
                }
                catch (Throwable throwable) {
                    CathyPlugin.getDefault().getUsageDataCollector().put("ShutDownTime", System.currentTimeMillis());
                    throw throwable;
                }
                CathyPlugin.getDefault().getUsageDataCollector().put("ShutDownTime", System.currentTimeMillis());
                return n;
            }
            Integer n = EXIT_OK;
            CathyPlugin.getDefault().getUsageDataCollector().put("ShutDownTime", System.currentTimeMillis());
            return n;
        }
        finally {
            display.dispose();
        }
    }

    private void captureAppSessionInfo(IUsageDataSampler sampler, IApplicationContext context, String buildId) {
        sampler.put("StartUpTime", System.currentTimeMillis());
        sampler.put("AppId", context.getBrandingApplication());
        sampler.put("BuildId", buildId);
        sampler.put("DistributionId", System.getProperty("org.xmind.product.distribution.id", null));
        sampler.put("NL", Platform.getNL());
        sampler.put("OS", Platform.getOS());
        sampler.put("Arch", Platform.getOSArch());
        sampler.put("OSName", System.getProperty("os.name", null));
        sampler.put("OSVersion", System.getProperty("os.version", null));
        sampler.put("Country", System.getProperty("user.country", null));
        sampler.put("JavaVersion", System.getProperty("java.version", null));
        sampler.put("JavaVendor", System.getProperty("java.vendor", null));
        sampler.put("ScreenWidth", (long)Toolkit.getDefaultToolkit().getScreenSize().width);
        sampler.put("ScreenHeight", (long)Toolkit.getDefaultToolkit().getScreenSize().height);
        sampler.put("ScreenResolution", (long)Toolkit.getDefaultToolkit().getScreenResolution());
    }

    private static String calculateBuildId(IApplicationContext context) {
        String buildId = System.getProperty("eclipse.buildId");
        if (buildId != null && !"".equals(buildId)) {
            return buildId;
        }
        return context.getBrandingBundle().getVersion().toString();
    }

    private static String extractVersionNumber(String buildId) {
        String[] numbers = buildId.split("\\.");
        StringBuilder buffer = new StringBuilder(10);
        int i = 0;
        while (i < 3) {
            if (i >= numbers.length) break;
            if (buffer.length() > 0) {
                buffer.append('.');
            }
            buffer.append(numbers[i]);
            ++i;
        }
        return buffer.toString();
    }

    private void initializeInternalBrowserCookies() {
        String appVersion = System.getProperty(SYS_VERSION);
        Browser.setCookie((String)("_env=xmind_" + appVersion + "; path=/; domain=.xmind.net"), (String)"http://www.xmind.net/");
    }

    private void logApplicationArgs() {
        String[] args = Platform.getApplicationArgs();
        if (args == null || args.length == 0) {
            return;
        }
        Log openingLog = Log.get(".opening");
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if ("-p".equals(arg)) {
                System.setProperty("org.xmind.cathy.startup.presentation", "true");
            } else if (arg.startsWith("xmind:") || new File(arg).exists()) {
                openingLog.append(arg);
            } else if (!arg.startsWith("-psn_0_")) {
                CathyPlugin.log("Skip unrecognized command line argument: '" + arg + "'");
            }
            ++n2;
        }
    }

    private boolean shouldExitEarly(IApplicationContext appContext) throws Exception {
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint("org.xmind.ui.toolkit.applicationValidators");
        if (extPoint != null) {
            IExtension[] iExtensionArray = extPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object validator;
                    IConfigurationElement validatorElement = iConfigurationElementArray[n4];
                    if ("applicationValidator".equals(validatorElement.getName()) && (validator = validatorElement.createExecutableExtension("class")) instanceof IApplicationValidator && ((IApplicationValidator)validator).shouldApplicationExitEarly(appContext)) {
                        return true;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return false;
    }

    public void stop() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        final IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        Display display = workbench.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                workbench.close();
            }
        });
    }
}

