/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.makers;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import net.coobird.thumbnailator.builders.BufferedImageBuilder;
import net.coobird.thumbnailator.resizers.DefaultResizerFactory;
import net.coobird.thumbnailator.resizers.FixedResizerFactory;
import net.coobird.thumbnailator.resizers.Resizer;
import net.coobird.thumbnailator.resizers.ResizerFactory;

public abstract class ThumbnailMaker {
    private static final String NOT_READY_FOR_MAKE = "Maker not ready to make thumbnail.";
    private static final String PARAM_IMAGE_TYPE = "imageType";
    private static final String PARAM_RESIZER = "resizer";
    private static final String PARAM_RESIZERFACTORY = "resizerFactory";
    protected final ReadinessTracker ready = new ReadinessTracker();
    private static final int DEFAULT_IMAGE_TYPE = 2;
    protected int imageType;
    protected ResizerFactory resizerFactory;

    public ThumbnailMaker() {
        this.ready.unset(PARAM_IMAGE_TYPE);
        this.ready.unset(PARAM_RESIZER);
        this.ready.unset(PARAM_RESIZERFACTORY);
        this.defaultImageType();
        this.defaultResizerFactory();
    }

    public abstract BufferedImage make(BufferedImage var1);

    protected BufferedImage makeThumbnail(BufferedImage img, int width, int height) {
        if (!this.ready.isReady()) {
            throw new IllegalStateException(NOT_READY_FOR_MAKE);
        }
        if (width <= 0) {
            throw new IllegalArgumentException("Width must be greater than zero.");
        }
        if (height <= 0) {
            throw new IllegalArgumentException("Height must be greater than zero.");
        }
        BufferedImage thumbnailImage = new BufferedImageBuilder(width, height, this.imageType).build();
        Dimension imgSize = new Dimension(img.getWidth(), img.getHeight());
        Dimension thumbnailSize = new Dimension(width, height);
        Resizer resizer = this.resizerFactory.getResizer(imgSize, thumbnailSize);
        resizer.resize(img, thumbnailImage);
        return thumbnailImage;
    }

    public ThumbnailMaker imageType(int imageType) {
        this.imageType = imageType;
        this.ready.set(PARAM_IMAGE_TYPE);
        return this;
    }

    public ThumbnailMaker defaultImageType() {
        return this.imageType(2);
    }

    public ThumbnailMaker resizer(Resizer resizer) {
        this.resizerFactory = new FixedResizerFactory(resizer);
        this.ready.set(PARAM_RESIZER);
        this.ready.set(PARAM_RESIZERFACTORY);
        return this;
    }

    public ThumbnailMaker defaultResizer() {
        return this.defaultResizerFactory();
    }

    public ThumbnailMaker resizerFactory(ResizerFactory resizerFactory) {
        this.resizerFactory = resizerFactory;
        this.ready.set(PARAM_RESIZER);
        this.ready.set(PARAM_RESIZERFACTORY);
        return this;
    }

    public ThumbnailMaker defaultResizerFactory() {
        this.resizerFactory = DefaultResizerFactory.getInstance();
        this.ready.set(PARAM_RESIZER);
        this.ready.set(PARAM_RESIZERFACTORY);
        return this;
    }

    protected static final class ReadinessTracker {
        private final Map<String, Boolean> alreadySetMap = new HashMap<String, Boolean>();

        protected ReadinessTracker() {
        }

        protected boolean isReady() {
            for (Map.Entry<String, Boolean> entry : this.alreadySetMap.entrySet()) {
                if (entry.getValue().booleanValue()) continue;
                return false;
            }
            return true;
        }

        protected void unset(String parameterName) {
            this.alreadySetMap.put(parameterName, false);
        }

        protected void set(String parameterName) {
            this.alreadySetMap.put(parameterName, true);
        }

        protected boolean isSet(String parameterName) {
            return this.alreadySetMap.get(parameterName);
        }
    }
}

