/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.mindmap;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.xmind.core.Core;
import org.xmind.core.IRelationship;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.io.DirectoryStorage;
import org.xmind.core.io.IStorage;
import org.xmind.core.util.CloneHandler;
import org.xmind.ui.mindmap.IMindMapViewer;
import org.xmind.ui.mindmap.IRelationshipPart;
import org.xmind.ui.mindmap.MindMapUI;

public class MindMapExtractor {
    private static final String SUBDIR_EXPORT = "export";
    private static String DefaultDirectory = null;
    private ISheet sourceSheet;
    private ITopic sourceTopic;
    private Collection<IRelationship> sourceRels;
    private IWorkbook result;
    private IStorage tempStorage;

    public MindMapExtractor(IMindMapViewer viewer) {
        this(viewer, MindMapExtractor.newTempStorage());
    }

    public MindMapExtractor(IMindMapViewer viewer, String tempLocation) {
        this(viewer, (IStorage)new DirectoryStorage(new File(tempLocation)));
    }

    public MindMapExtractor(IMindMapViewer viewer, IStorage tempStorage) {
        this.sourceSheet = viewer.getSheet();
        this.sourceTopic = viewer.getCentralTopic();
        List<IRelationshipPart> relParts = viewer.getSheetPart().getRelationships();
        this.sourceRels = new ArrayList<IRelationship>(relParts.size());
        for (IRelationshipPart relPart : relParts) {
            this.sourceRels.add(relPart.getRelationship());
        }
        this.tempStorage = tempStorage;
    }

    public IWorkbook extract() throws IOException {
        if (this.result == null) {
            this.result = Core.getWorkbookBuilder().createWorkbook(this.tempStorage);
            this.result.getMarkerSheet().setParentSheet(MindMapUI.getResourceManager().getSystemMarkerSheet());
            CloneHandler cloner = new CloneHandler().withWorkbooks(this.sourceSheet.getOwnedWorkbook(), this.result);
            ISheet newSheet = (ISheet)cloner.cloneObject((Object)this.sourceSheet);
            this.result.addSheet(newSheet);
            this.result.removeSheet(this.result.getPrimarySheet());
        }
        return this.result;
    }

    public void delete() {
        this.tempStorage.clear();
    }

    @Deprecated
    public String getTempLocation() {
        if (this.tempStorage instanceof DirectoryStorage) {
            return ((DirectoryStorage)this.tempStorage).getFullPath();
        }
        return null;
    }

    public IStorage getTempStorage() {
        return this.tempStorage;
    }

    private static IStorage newTempStorage() {
        if (DefaultDirectory == null) {
            DefaultDirectory = Core.getWorkspace().getTempDir(SUBDIR_EXPORT);
        }
        String fileName = String.valueOf(Core.getIdFactory().createId()) + ".xmind.temp";
        File dir = new File(DefaultDirectory, fileName);
        dir.mkdirs();
        return new DirectoryStorage(dir);
    }
}

