/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.xmind.core.Core;
import org.xmind.core.IWorkbook;
import org.xmind.core.io.DirectoryStorage;
import org.xmind.core.io.IStorage;
import org.xmind.core.util.CloneHandler;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.wizards.MindMapImporter;

public class XMind2008Importer
extends MindMapImporter {
    public XMind2008Importer(String sourcePath, IWorkbook targetWorkbook) {
        super(sourcePath, targetWorkbook);
    }

    @Override
    public void build() throws InvocationTargetException, InterruptedException {
        MindMapUIPlugin.getDefault().getUsageDataCollector().increase("ImportFromXMind2008Count");
        try {
            IStorage storage = this.createStorage();
            try {
                IWorkbook sourceWorkbook = Core.getWorkbookBuilder().loadFromPath(this.getSourcePath(), storage, null);
                new CloneHandler().withWorkbooks(sourceWorkbook, this.getTargetWorkbook()).copyWorkbookContents();
            }
            finally {
                storage.clear();
            }
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
        this.postBuilded();
    }

    private IStorage createStorage() {
        String tempFile = String.valueOf(Core.getIdFactory().createId()) + ".xmind.temp";
        String tempLocation = Core.getWorkspace().getTempDir("workbooks/" + tempFile);
        File tempDir = new File(tempLocation);
        return new DirectoryStorage(tempDir);
    }
}

