/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.wizards;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.xmind.ui.internal.wizards.ExportPage;
import org.xmind.ui.internal.wizards.ImportExportPage;
import org.xmind.ui.internal.wizards.ImportPage;
import org.xmind.ui.mindmap.MindMapUI;

public class ImportExportWizard
extends Wizard {
    public static final String IMPORT = "import";
    public static final String EXPORT = "export";
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private ImportExportPage importExportPage;
    private String page = null;

    public ImportExportWizard(String pageId) {
        this.page = pageId;
    }

    public boolean performFinish() {
        this.importExportPage.saveWidgetValues();
        return true;
    }

    public void addPages() {
        if (this.page.equals(IMPORT)) {
            this.importExportPage = new ImportPage(this.workbench, this.selection);
        } else if (this.page.equals(EXPORT)) {
            this.importExportPage = new ExportPage(this.workbench, this.selection);
        }
        if (this.importExportPage != null) {
            this.addPage((IWizardPage)this.importExportPage);
        }
    }

    public void init(IWorkbench aWorkbench, IStructuredSelection currentSelection) {
        this.workbench = aWorkbench;
        this.selection = currentSelection;
        ImageDescriptor wizardBannerImage = null;
        if (IMPORT.equals(this.page)) {
            wizardBannerImage = MindMapUI.getImages().getWizBan("import_wiz.png");
            this.setWindowTitle(WorkbenchMessages.ImportWizard_title);
        } else if (EXPORT.equals(this.page)) {
            wizardBannerImage = MindMapUI.getImages().getWizBan("export_wiz.png");
            this.setWindowTitle(WorkbenchMessages.ExportWizard_title);
        }
        if (wizardBannerImage != null) {
            this.setDefaultPageImageDescriptor(wizardBannerImage);
        }
        this.setNeedsProgressMonitor(true);
    }
}

