/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.wizards;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.internal.DPIUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmind.core.CoreException;
import org.xmind.core.IFileEntry;
import org.xmind.core.IImage;
import org.xmind.core.INotesContent;
import org.xmind.core.ISheet;
import org.xmind.core.ISummary;
import org.xmind.core.ITopic;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.core.marker.IMarkerResource;
import org.xmind.core.marker.IMarkerVariation;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyled;
import org.xmind.core.util.DOMUtils;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.core.util.Property;
import org.xmind.ui.internal.wizards.HtmlConstants;
import org.xmind.ui.internal.wizards.HtmlExportPart;
import org.xmind.ui.mindmap.MindMapImageExporter;
import org.xmind.ui.util.ImageFormat;
import org.xmind.ui.util.MindMapUtils;
import org.xmind.ui.wizards.ExportUtils;
import org.xmind.ui.wizards.Exporter;
import org.xmind.ui.wizards.IExportPart;
import org.xmind.ui.wizards.RelationshipDescription;

public class HtmlExporter
extends Exporter {
    private static final Object NULL = new Object();
    private static final String IMAGES = "images";
    private static final String FILES = "_files";
    private String title;
    private String targetPath;
    private String filesPath;
    private String imagesPath;
    private String relativeFilesPath;
    private String relativeImagesPath;
    private Document document;
    private Element headEle;
    private Element bodyEle;
    private Map<String, List<String>> usedStyles = null;
    private Map<String, IStyle> styleMap = null;
    private Map<String, String> styleIdMap = null;
    private Map<String, Object> files = null;
    private Map<String, Object> markerPaths = null;

    public HtmlExporter(ISheet sheet, ITopic centralTopic, String targetPath, String title) {
        super(sheet, centralTopic);
        this.targetPath = targetPath;
        this.title = title;
    }

    @Override
    public void init() {
        this.appendTopic(this.getCentralTopic(), 0, null);
    }

    private void appendTopic(ITopic topic, int level, HtmlExportPart parent) {
        TitlePart topicPart = new TitlePart(this, topic, level);
        topicPart.setParent(parent);
        this.append(topicPart);
        this.appendTopicContent(topic, level, parent);
    }

    private void appendTopicContent(ITopic topic, int level, HtmlExportPart parent) {
        List<RelationshipDescription> relationships;
        IImage image;
        boolean hasLabel;
        Set markers = topic.getMarkerRefs();
        Set labels = topic.getLabels();
        boolean hasMarker = this.getBoolean("includeMarkers") && !markers.isEmpty();
        boolean bl = hasLabel = this.getBoolean("includeLabels") && !labels.isEmpty();
        if (hasMarker || hasLabel) {
            TagsPart tags = new TagsPart(this, topic, hasMarker ? markers : null, hasLabel ? labels : null);
            tags.setParent(parent);
            this.append(tags);
        }
        if (this.hasOverview(topic)) {
            OverviewPart overview = new OverviewPart(this, topic);
            overview.setParent(parent);
            this.append(overview);
        }
        if (this.getBoolean("includeImage") && (image = topic.getImage()).getSource() != null) {
            ImagePart imagePart = new ImagePart(this, image);
            imagePart.setParent(parent);
            this.append(imagePart);
        }
        if (this.getBoolean("includeNotes")) {
            INotesContent content = topic.getNotes().getContent("html");
            if (content == null) {
                content = topic.getNotes().getContent("plain");
            }
            if (content != null) {
                NotesPart notesPart = new NotesPart(this, content);
                notesPart.setParent(parent);
                this.append(notesPart);
            }
        }
        if (this.getBoolean("includeRelationships") && !(relationships = ExportUtils.getRelationships(topic, this.getRelationships())).isEmpty()) {
            RelationshipsPart relsPart = new RelationshipsPart(this, topic, relationships);
            relsPart.setParent(parent);
            this.append(relsPart);
        }
        int nextLevel = level + 1;
        for (ITopic sub : topic.getChildren("attached")) {
            this.appendTopic(sub, nextLevel, parent);
        }
        if (this.getBoolean("includeSummaries")) {
            for (ISummary summary : topic.getSummaries()) {
                this.appendSummary(summary, topic, nextLevel, parent);
            }
        }
        if (this.getBoolean("includeFloatingTopics")) {
            for (ITopic sub : topic.getChildren("detached")) {
                this.appendTopic(sub, nextLevel, parent);
            }
        }
    }

    private void appendSummary(ISummary summary, ITopic topic, int nextLevel, HtmlExportPart parent) {
        ITopic summaryTopic = summary.getTopic();
        if (summaryTopic == null) {
            return;
        }
        TitlePart topicPart = new TitlePart(this, summaryTopic, nextLevel);
        topicPart.setParent(parent);
        this.append(topicPart);
        SummaryPart summaryPart = new SummaryPart(this, summary);
        summaryPart.setParent(parent);
        this.append(summaryPart);
        this.appendTopicContent(summaryTopic, nextLevel, parent);
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public String getFilesPath() {
        if (this.filesPath == null) {
            this.filesPath = this.createFilesPath();
        }
        return this.filesPath;
    }

    private String createFilesPath() {
        File f = new File(this.getTargetPath());
        String name = f.getName();
        String parent = f.getParent();
        int index = name.lastIndexOf(46);
        name = index >= 0 ? String.valueOf(name.substring(0, index)) + FILES : String.valueOf(name) + FILES;
        return new File(parent, name).getAbsolutePath();
    }

    public String getImagesPath() {
        if (this.imagesPath == null) {
            this.imagesPath = this.createImagesPath();
        }
        return this.imagesPath;
    }

    private String createImagesPath() {
        String path = this.getFilesPath();
        return new File(path, IMAGES).getAbsolutePath();
    }

    public String getRelativeFilesPath() {
        if (this.relativeFilesPath == null) {
            this.relativeFilesPath = new File(this.getFilesPath()).getName();
        }
        return this.relativeFilesPath;
    }

    public String getRelativeImagesPath() {
        if (this.relativeImagesPath == null) {
            this.relativeImagesPath = this.connectPath(this.getRelativeFilesPath(), IMAGES);
        }
        return this.relativeImagesPath;
    }

    public String connectPath(String parent, String child) {
        return String.valueOf(parent) + "/" + child;
    }

    public String newPath(String parent, String name, String ext) {
        File f = new File(parent, String.valueOf(name) + ext);
        int i = 1;
        while (f.exists()) {
            String newName = String.valueOf(name) + " " + ++i;
            f = new File(parent, String.valueOf(newName) + ext);
        }
        return f.getAbsolutePath();
    }

    public Document getDocument() {
        if (this.document == null) {
            this.document = this.createDocument();
        }
        return this.document;
    }

    protected Element getHeadElement() {
        if (this.headEle == null) {
            this.headEle = DOMUtils.ensureChildElement((Node)this.getDocument().getDocumentElement(), (String)"head");
        }
        return this.headEle;
    }

    private Document createDocument() {
        Document doc = DOMUtils.createDocument();
        Element ele = DOMUtils.createElement((Node)doc, (String)"html");
        Element head = DOMUtils.createElement((Node)ele, (String)"head");
        this.createMeta(head, "Content-Type", "text/html; charset=utf-8");
        this.createMeta(head, "Content-Style-Type", "text/css");
        if (this.title != null) {
            Element titleEle = DOMUtils.createElement((Node)head, (String)"title");
            titleEle.setTextContent(this.title);
        }
        return doc;
    }

    private Element createMeta(Element head, String httpEquiv, String content) {
        Element meta = DOMUtils.createElement((Node)head, (String)"meta");
        meta.setAttribute("http-equiv", httpEquiv);
        meta.setAttribute("content", content);
        return meta;
    }

    protected Node getBodyNode() {
        if (this.bodyEle == null) {
            this.bodyEle = this.createBodyNode();
        }
        return this.bodyEle;
    }

    private Element createBodyNode() {
        return DOMUtils.createElement((Node)this.getDocument().getDocumentElement(), (String)"body");
    }

    public String addStyle(String styleId) {
        List<String> list;
        String cachedStyleId;
        if (styleId == null) {
            return null;
        }
        String string = cachedStyleId = this.styleIdMap == null ? null : this.styleIdMap.get(styleId);
        if (cachedStyleId != null) {
            return cachedStyleId;
        }
        IStyle style = this.getStyle(styleId);
        if (style == null) {
            return null;
        }
        String type = style.getType();
        if (!this.isStyleInteresting(style, type)) {
            return null;
        }
        if (this.usedStyles == null) {
            this.usedStyles = new HashMap<String, List<String>>();
        }
        if ((list = this.usedStyles.get(type)) == null) {
            list = new ArrayList<String>();
            this.usedStyles.put(type, list);
        }
        String newStyleId = this.newStyleId(type, list.size() + 1);
        list.add(newStyleId);
        if (this.styleIdMap == null) {
            this.styleIdMap = new HashMap<String, String>();
        }
        this.styleIdMap.put(styleId, newStyleId);
        if (this.styleMap == null) {
            this.styleMap = new HashMap<String, IStyle>();
        }
        this.styleMap.put(newStyleId, style);
        return newStyleId;
    }

    private String newStyleId(String type, int index) {
        if ("paragraph".equals(type)) {
            return "p" + index;
        }
        return "s" + index;
    }

    private boolean isStyleInteresting(IStyle style, String type) {
        return "paragraph".equals(type) || "text".equals(type);
    }

    @Override
    protected void write(IProgressMonitor monitor, IExportPart part) throws InvocationTargetException, InterruptedException {
        HtmlExportPart child = (HtmlExportPart)part;
        HtmlExportPart parent = child.getParent();
        if (parent != null) {
            child.addToParent(parent);
        } else {
            this.getBodyNode().appendChild(child.getNode());
        }
    }

    @Override
    public void end() throws InvocationTargetException {
        this.createStyles();
        try {
            try {
                FileOutputStream out = new FileOutputStream(this.targetPath);
                try {
                    DOMUtils.save((Node)this.getDocument(), (OutputStream)out, (boolean)true);
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
            catch (FileNotFoundException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            super.end();
        }
    }

    private void createStyles() {
        List<String> ts;
        if (this.usedStyles == null || this.usedStyles.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\r");
        List<String> ps = this.usedStyles.get("paragraph");
        if (ps != null && !ps.isEmpty()) {
            this.createStyles("p", ps, sb);
        }
        if ((ts = this.usedStyles.get("text")) != null && !ts.isEmpty()) {
            this.createStyles("span", ts, sb);
        }
        String content = sb.toString();
        Element styleEle = DOMUtils.ensureChildElement((Node)this.getHeadElement(), (String)"style");
        styleEle.setAttribute("type", "text/css");
        styleEle.setTextContent(content);
    }

    private void createStyles(String tag, List<String> styleIds, StringBuilder sb) {
        for (String styleId : styleIds) {
            IStyle style;
            IStyle iStyle = style = this.styleMap == null ? null : this.styleMap.get(styleId);
            if (style == null) continue;
            this.createStyle(tag, styleId, style, sb);
        }
    }

    private void createStyle(String tag, String styleId, IStyle style, StringBuilder sb) {
        sb.append(tag);
        sb.append('.');
        sb.append(styleId);
        sb.append(' ');
        sb.append('{');
        Iterator properties = style.properties();
        while (properties.hasNext()) {
            Property property = (Property)properties.next();
            String name = DOMUtils.getLocalName((String)property.key);
            String value = property.value;
            sb.append(name);
            sb.append(':');
            sb.append(' ');
            sb.append(value);
            if (!properties.hasNext()) continue;
            sb.append(';');
            sb.append(' ');
        }
        sb.append('}');
        sb.append("\r");
    }

    public String createOverview(ITopic topic, ImageFormat format) {
        String title = topic.getTitleText();
        String path = this.newPath(this.getImagesPath(), MindMapUtils.trimFileName(title), (String)format.getExtensions().get(0));
        FileUtils.ensureFileParent((File)new File(path));
        String relativePath = this.connectPath(this.getRelativeImagesPath(), new File(path).getName());
        MindMapImageExporter exporter = this.createOverviewExporter(topic);
        exporter.setTargetFile(new File(path));
        exporter.export();
        return relativePath;
    }

    public String createFilePath(String hyperlink, String suggestedName) {
        Object cache;
        Object object = cache = this.files == null ? null : this.files.get(hyperlink);
        if (cache == NULL) {
            return null;
        }
        if (cache instanceof String) {
            return (String)cache;
        }
        String entryPath = HyperlinkUtils.toAttachmentPath((String)hyperlink);
        IFileEntry entry = this.getFileEntry(entryPath);
        if (entry == null) {
            return this.cacheFile(hyperlink, NULL);
        }
        if (suggestedName == null) {
            suggestedName = FileUtils.getFileName((String)entryPath);
        }
        String name = FileUtils.getNoExtensionFileName((String)suggestedName);
        String ext = FileUtils.getExtension((String)suggestedName);
        String path = this.newPath(this.getFilesPath(), name, ext);
        InputStream in = entry.getInputStream();
        if (in != null) {
            FileUtils.ensureFileParent((File)new File(path));
            try {
                FileUtils.transfer((InputStream)in, (OutputStream)new FileOutputStream(path), (boolean)true);
            }
            catch (IOException e) {
                String message = NLS.bind((String)Message_FailedToCopyAttachment, (Object)suggestedName);
                this.log(e, message);
            }
        }
        String fileName = new File(path).getName();
        String relativePath = this.connectPath(this.getRelativeFilesPath(), fileName);
        return this.cacheFile(hyperlink, relativePath);
    }

    private String cacheFile(String hyperlink, Object path) {
        if (this.files == null) {
            this.files = new HashMap<String, Object>();
        }
        this.files.put(hyperlink, path);
        return path == NULL ? null : (String)path;
    }

    public String createMarkerPath(String markerId) {
        Object cache;
        if (markerId == null) {
            return null;
        }
        Object object = cache = this.markerPaths == null ? null : this.markerPaths.get(markerId);
        if (cache == NULL) {
            return null;
        }
        if (cache instanceof String) {
            return (String)cache;
        }
        IMarker marker = this.getMarker(markerId);
        if (marker == null) {
            return this.cacheMarker(markerId, NULL);
        }
        IMarkerResource resource = marker.getResource();
        if (resource == null) {
            return this.cacheMarker(markerId, NULL);
        }
        String name = FileUtils.getFileName((String)resource.getPath());
        String ext = FileUtils.getExtension((String)name);
        name = FileUtils.getNoExtensionFileName((String)name);
        String path = this.newPath(this.getImagesPath(), name, ext);
        FileUtils.ensureFileParent((File)new File(path));
        int zoom = DPIUtil.getDeviceZoom();
        List variations = resource.getVariations();
        InputStream in = null;
        try {
            in = variations.size() > 0 ? resource.openInputStream((IMarkerVariation)variations.get(variations.size() - 1), zoom) : resource.openInputStream(zoom);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (in != null) {
            try {
                FileUtils.transfer((InputStream)in, (OutputStream)new FileOutputStream(path), (boolean)true);
            }
            catch (IOException e) {
                this.log(e, NLS.bind((String)Message_FailedToCopyMarker, (Object)markerId));
            }
        }
        String fileName = new File(path).getName();
        String relativePath = this.connectPath(this.getRelativeImagesPath(), fileName);
        return this.cacheMarker(markerId, relativePath);
    }

    private String cacheMarker(String markerId, Object path) {
        if (this.markerPaths == null) {
            this.markerPaths = new HashMap<String, Object>();
        }
        this.markerPaths.put(markerId, path);
        return path == NULL ? null : (String)path;
    }

    private static class ImagePart
    extends HtmlExportPart {
        public ImagePart(HtmlExporter exporter, IImage element) {
            super(exporter, (Object)element);
        }

        @Override
        protected Node createNode() {
            String url;
            IImage image = (IImage)this.getElement();
            Element ele = this.createDOMElement("p");
            ele.setAttribute("class", "topicImage");
            if (this.isCentralTopic(image.getParent())) {
                ele.setAttribute("align", "center");
            }
            if (HyperlinkUtils.isAttachmentURL((String)(url = image.getSource()))) {
                url = this.getExporter().createFilePath(url, null);
            }
            if (url != null) {
                int height;
                Element img = this.createDOMElement("img");
                img.setAttribute("src", url);
                int width = image.getWidth();
                if (width != -1) {
                    img.setAttribute("width", String.valueOf(width));
                }
                if ((height = image.getHeight()) != -1) {
                    img.setAttribute("height", String.valueOf(height));
                }
                ele.appendChild(img);
            }
            return ele;
        }
    }

    private static class NotesPart
    extends HtmlExportPart {
        public NotesPart(HtmlExporter exporter, INotesContent element) {
            super(exporter, (Object)element);
        }

        @Override
        protected Node createNode() {
            Element ele = this.createDOMElement("div");
            ele.setAttribute("class", "notesContainer");
            INotesContent content = (INotesContent)this.getElement();
            Element contentEle = (Element)content.getAdapter(Element.class);
            if (contentEle != null) {
                String format = content.getFormat();
                if ("plain".equals(format)) {
                    this.appendPlainNotes(ele, content, contentEle);
                } else {
                    this.appendHtmlNotes(ele, content, contentEle);
                }
            }
            return ele;
        }

        private void appendPlainNotes(Element ele, INotesContent content, Element contentEle) {
            String[] lines;
            String textContent = contentEle.getTextContent();
            String[] stringArray = lines = textContent.split("\\r\\n|\\r|\\n");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                Element p = this.createDOMElement("p");
                p.setTextContent(line);
                ele.appendChild(p);
                ++n2;
            }
        }

        private void appendHtmlNotes(Element ele, INotesContent content, Element contentEle) {
            Document doc = ele.getOwnerDocument();
            NodeList children = contentEle.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node n = children.item(i);
                n = this.importNode(doc, n);
                ele.appendChild(n);
                ++i;
            }
        }

        private Node importNode(Document doc, Node n) {
            if (n instanceof Element) {
                return this.importElement(doc, (Element)n);
            }
            return doc.importNode(n, true);
        }

        private Element importElement(Document doc, Element e) {
            String tag = DOMUtils.getLocalName((String)e.getTagName());
            Element e2 = doc.createElement(tag);
            NamedNodeMap attrs = e.getAttributes();
            int i = 0;
            while (i < attrs.getLength()) {
                Node item = attrs.item(i);
                String name = item.getNodeName();
                String value = item.getNodeValue();
                if ("style-id".equals(name)) {
                    name = "class";
                    value = this.getExporter().addStyle(value);
                } else if ("xhtml:src".equals(name) && HyperlinkUtils.isAttachmentURL((String)value)) {
                    value = this.getExporter().createFilePath(value, null);
                }
                e2.setAttribute(DOMUtils.getLocalName((String)name), value);
                ++i;
            }
            NodeList children = e.getChildNodes();
            int i2 = 0;
            while (i2 < children.getLength()) {
                Node c = children.item(i2);
                Node c2 = this.importNode(doc, c);
                e2.appendChild(c2);
                ++i2;
            }
            return e2;
        }
    }

    private static class OverviewPart
    extends HtmlExportPart {
        private static final ImageFormat FORMAT = ImageFormat.JPEG;

        public OverviewPart(HtmlExporter exporter, ITopic topic) {
            super(exporter, (Object)topic);
        }

        @Override
        protected Node createNode() {
            ITopic topic = (ITopic)this.getElement();
            boolean root = this.isCentralTopic(topic);
            String path = this.getExporter().createOverview(topic, FORMAT);
            Element div = this.createDOMElement("div");
            div.setAttribute("class", root ? "globalOverview" : "overview");
            if (root) {
                div.setAttribute("align", "center");
            }
            Element img = this.createDOMElement("img");
            img.setAttribute("src", path);
            div.appendChild(img);
            return div;
        }
    }

    private static class RelationshipsPart
    extends HtmlExportPart {
        private List<RelationshipDescription> relationships;

        public RelationshipsPart(HtmlExporter exporter, ITopic element, List<RelationshipDescription> relationships) {
            super(exporter, (Object)element);
            this.relationships = relationships;
        }

        @Override
        protected Node createNode() {
            Element ele = this.createDOMElement("p");
            ele.setAttribute("class", "relationships");
            ele.appendChild(this.createText(SEE_ALSO));
            ele.appendChild(this.createText(" "));
            Iterator<RelationshipDescription> relIt = this.relationships.iterator();
            while (relIt.hasNext()) {
                RelationshipDescription rel = relIt.next();
                Element anchor = this.createDOMElement("a");
                anchor.setAttribute("href", "#" + rel.target.getId());
                anchor.setTextContent(rel.description);
                ele.appendChild(anchor);
                if (!relIt.hasNext()) continue;
                ele.appendChild(this.createText(", "));
            }
            return ele;
        }
    }

    private static class SummaryPart
    extends HtmlExportPart {
        public SummaryPart(HtmlExporter exporter, ISummary summary) {
            super(exporter, (Object)summary);
        }

        @Override
        protected Node createNode() {
            Element ele = this.createDOMElement("p");
            ele.setAttribute("class", "summary");
            ele.appendChild(this.createText("("));
            ISummary summary = (ISummary)this.getElement();
            List topics = summary.getEnclosingTopics();
            Iterator topicIt = topics.iterator();
            while (topicIt.hasNext()) {
                ITopic topic = (ITopic)topicIt.next();
                Element anchor = this.createDOMElement("a");
                anchor.setAttribute("href", "#" + topic.getId());
                anchor.setTextContent(topic.getTitleText());
                ele.appendChild(anchor);
                if (!topicIt.hasNext()) continue;
                ele.appendChild(this.createText(", "));
            }
            ele.appendChild(this.createText(")"));
            return ele;
        }
    }

    private static class TagsPart
    extends HtmlExportPart {
        private Set<IMarkerRef> markers;
        private Set<String> labels;

        public TagsPart(HtmlExporter exporter, ITopic topic, Set<IMarkerRef> markers, Set<String> labels) {
            super(exporter, (Object)topic);
            this.markers = markers;
            this.labels = labels;
        }

        @Override
        protected Node createNode() {
            boolean hasLabels;
            Element ele = this.createDOMElement("p");
            ele.setAttribute("class", "labelsAndMarkers");
            ITopic topic = (ITopic)this.getElement();
            boolean isRoot = this.isCentralTopic(topic);
            if (isRoot) {
                ele.setAttribute("align", "center");
            }
            boolean hasMarkers = false;
            boolean bl = hasLabels = this.labels != null;
            if (this.markers != null) {
                Iterator<IMarkerRef> markerIt = this.markers.iterator();
                while (markerIt.hasNext()) {
                    IMarkerRef m = markerIt.next();
                    String markerId = m.getMarkerId();
                    String path = this.getExporter().createMarkerPath(markerId);
                    if (path == null) continue;
                    hasMarkers = true;
                    Element img = this.createDOMElement("img");
                    img.setAttribute("class", "marker");
                    img.setAttribute("src", path);
                    ele.appendChild(img);
                    if (!markerIt.hasNext()) continue;
                    ele.appendChild(this.createText(" "));
                }
            }
            if (hasMarkers && hasLabels && !isRoot) {
                ele.appendChild(this.createText(", "));
            }
            if (hasLabels) {
                Iterator<String> labelIt = this.labels.iterator();
                while (labelIt.hasNext()) {
                    String label = labelIt.next();
                    Element span = this.createDOMElement("span");
                    span.setAttribute("class", "label");
                    span.appendChild(this.createText(label));
                    ele.appendChild(span);
                    if (!labelIt.hasNext()) continue;
                    ele.appendChild(this.createText(", "));
                }
            }
            return ele;
        }
    }

    private static class TitlePart
    extends HtmlExportPart {
        private final int level;
        private static final String SPACE = "\u00a0";

        public TitlePart(HtmlExporter exporter, ITopic topic, int level) {
            super(exporter, (Object)topic);
            this.level = level;
        }

        @Override
        protected Node createNode() {
            ITopic topic = (ITopic)this.getElement();
            String tag = HtmlConstants.TAGS_H[Math.min(HtmlConstants.TAGS_H.length - 1, this.level)];
            Element ele = this.createDOMElement(tag);
            boolean isRoot = this.isCentralTopic(topic);
            ele.setAttribute("class", isRoot ? "root" : "topic");
            if (isRoot) {
                ele.setAttribute("align", "center");
            }
            this.writeStyle(ele, (IStyled)topic);
            String num = ExportUtils.getNumberingText(topic, this.getExporter().getCentralTopic());
            if (num != null) {
                ele.appendChild(this.createText(num));
                ele.appendChild(this.createText(" "));
            }
            String title = String.valueOf(this.getLeftIndent()) + topic.getTitleText();
            Element titleAnchor = this.createDOMElement("a");
            titleAnchor.setAttribute("name", topic.getId());
            String hyperlink = topic.getHyperlink();
            if (HyperlinkUtils.isAttachmentURL((String)hyperlink) && !this.isLinkToWeb(hyperlink)) {
                hyperlink = this.getExporter().getBoolean("includeAttachment") ? this.getExporter().createFilePath(hyperlink, title) : null;
            } else if (!this.getExporter().getBoolean("includeHyperlink")) {
                hyperlink = null;
            } else if (hyperlink != null && hyperlink.startsWith("xmind:")) {
                hyperlink = hyperlink.substring(6);
            } else if (this.isLinkToWeb(hyperlink) && !hyperlink.startsWith("http:") && !hyperlink.startsWith("https:")) {
                hyperlink = "http://" + hyperlink;
            }
            if (hyperlink != null) {
                titleAnchor.setAttribute("href", hyperlink);
            }
            titleAnchor.appendChild(this.createText(title));
            ele.appendChild(titleAnchor);
            return ele;
        }

        private String getLeftIndent() {
            StringBuffer sb = new StringBuffer();
            int i = 1;
            while (i < this.level) {
                sb.append(SPACE);
                ++i;
            }
            return sb.toString();
        }

        private boolean isLinkToWeb(String hyperlink) {
            if (hyperlink == null) {
                return false;
            }
            return hyperlink.contains("www.") || hyperlink.contains(".com") || hyperlink.contains(".cn") || hyperlink.contains(".org") || hyperlink.contains(".cc") || hyperlink.contains(".net");
        }
    }
}

