/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.UpdateManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.graphics.Cursor;
import org.xmind.core.ISummary;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicRange;
import org.xmind.gef.GEF;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.draw2d.DecoratedShapeFigure;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.draw2d.decoration.IShapeDecorationEx;
import org.xmind.gef.draw2d.decoration.PathShapeDecoration;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.gef.event.MouseDragEvent;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.status.IStatusListener;
import org.xmind.gef.status.StatusEvent;
import org.xmind.gef.tool.ITool;
import org.xmind.ui.branch.IInsertableBranchStructureExtension;
import org.xmind.ui.branch.ILockableBranchStructureExtension;
import org.xmind.ui.branch.IMovableBranchStructureExtension;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.tools.BranchDummy;
import org.xmind.ui.internal.tools.TopicMoveToolHelper;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IMindMapImages;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.tools.DummyMoveTool;
import org.xmind.ui.tools.ITopicMoveToolHelper;
import org.xmind.ui.tools.ParentSearchKey;
import org.xmind.ui.tools.ParentSearcher;
import org.xmind.ui.util.MindMapUtils;

public class TopicMoveTool
extends DummyMoveTool
implements IStatusListener {
    private static final int INVENT_WIDTH = 60;
    private static final int INVENT_HEIGHT = 16;
    private static ITopicMoveToolHelper defaultHelper = null;
    private IFigure invent = null;
    private Point inventStartLoc = null;
    private ParentSearcher parentSearcher = null;
    private boolean slightMove = false;
    private boolean specialMove = false;
    private ITopicMoveToolHelper helper = null;
    private ParentSearchKey key = null;
    private BranchDummy branchDummy = null;
    private IBranchPart targetParent = null;
    private List<IFigure> disabledFigures = null;
    private IPart specialTargetPart = null;
    private int specialIndex = -1;

    public TopicMoveTool() {
        this.initMoveTopicMoveTool();
        this.getStatus().addStatusListener((IStatusListener)this);
    }

    private void initMoveTopicMoveTool() {
        IPreferenceStore prefStore = MindMapUIPlugin.getDefault().getPreferenceStore();
        boolean status = prefStore.getBoolean("manualLayoutAllowed");
        this.getStatus().setStatus(4096, status);
    }

    public void setSource(IGraphicalEditPart source) {
        Assert.isTrue((boolean)(source instanceof ITopicPart));
        super.setSource(source);
    }

    protected ITopicPart getSourceTopic() {
        return (ITopicPart)super.getSource();
    }

    protected IBranchPart getSourceBranch() {
        return (IBranchPart)this.getSourceTopic().getParent();
    }

    public IFigure getInvent() {
        return this.invent;
    }

    private void doCreateInvent() {
        if (this.invent != null) {
            return;
        }
        if (!this.getStatus().isStatus(1)) {
            return;
        }
        this.invent = this.createInvent();
    }

    private Point getInventStartLoc() {
        IFigure fig;
        if (this.inventStartLoc == null && (fig = this.getInvent()) != null) {
            this.inventStartLoc = fig instanceof IReferencedFigure ? ((IReferencedFigure)fig).getReference() : fig.getBounds().getLocation();
        }
        return this.inventStartLoc;
    }

    protected void onActivated(ITool prevTool) {
        super.onActivated(prevTool);
        this.lockBranchStructures((IPart)this.getTargetViewer().getRootPart());
        this.collectDisabledBranches();
        if (!this.isCopyMove()) {
            this.disableFigures();
        }
    }

    private void lockBranchStructures(IPart part) {
        IBranchPart branch;
        IStructure sa;
        if (part instanceof IBranchPart && (sa = (branch = (IBranchPart)part).getBranchPolicy().getStructure(branch)) instanceof ILockableBranchStructureExtension) {
            ((ILockableBranchStructureExtension)sa).lock(branch);
        }
        for (IPart child : part.getChildren()) {
            this.lockBranchStructures(child);
        }
    }

    private void unlockBranchStructures(IPart part) {
        IBranchPart branch;
        IStructure sa;
        if (part instanceof IBranchPart && (sa = (branch = (IBranchPart)part).getBranchPolicy().getStructure(branch)) instanceof ILockableBranchStructureExtension) {
            ((ILockableBranchStructureExtension)sa).unlock(branch);
        }
        for (IPart child : part.getChildren()) {
            this.unlockBranchStructures(child);
        }
    }

    @Override
    protected IFigure createDummy() {
        this.slightMove = true;
        if (this.branchDummy == null) {
            this.branchDummy = new BranchDummy(this.getTargetViewer(), this.getSourceBranch());
        }
        return this.branchDummy.getBranch().getFigure();
    }

    @Override
    protected void destroyDummy(IFigure dummy) {
        if (this.branchDummy != null) {
            this.branchDummy.dispose();
            this.branchDummy = null;
        }
        super.destroyDummy(dummy);
    }

    private void destroyInvent() {
        if (this.invent != null) {
            this.destroyInvent(this.invent);
            this.invent = null;
        }
    }

    private IFigure createInvent() {
        DecoratedShapeFigure figure = new DecoratedShapeFigure();
        Point loc = this.getDummyStartLoc();
        if (loc != null) {
            figure.setLocation(loc.getTranslated(-30, -8));
        }
        figure.setSize(60, 16);
        figure.setDecoration((IShapeDecorationEx)new RoundedRectDecoration());
        Layer layer = this.getTargetViewer().getLayer(GEF.LAYER_PRESENTATION);
        if (layer != null) {
            layer.add((IFigure)figure);
        }
        return figure;
    }

    private void collectDisabledBranches() {
        List selectedParts = this.getSelectedParts((IViewer)this.getTargetViewer());
        for (IPart part : selectedParts) {
            this.addDisabledPart(part);
        }
        List<ITopic> topics = MindMapUtils.getTopics(selectedParts);
        Set<ITopicRange> ranges = MindMapUtils.findContainedRanges(topics, true, false);
        if (!ranges.isEmpty()) {
            for (ITopicRange r : ranges) {
                ITopic st = ((ISummary)r).getTopic();
                if (st == null) continue;
                this.addDisabledPart(this.getTargetViewer().findPart((Object)st));
            }
        }
    }

    private void addDisabledPart(IPart part) {
        if (part instanceof ITopicPart) {
            ITopicPart topic = (ITopicPart)part;
            this.addDisabledFigure(topic.getFigure());
            IBranchPart branch = topic.getOwnerBranch();
            if (branch != null) {
                this.addDisabledFigure(branch.getFigure());
            }
        }
    }

    private void addDisabledFigure(IFigure figure) {
        if (this.disabledFigures == null) {
            this.disabledFigures = new ArrayList<IFigure>();
        }
        this.disabledFigures.add(figure);
    }

    private void clearDisabledFigures() {
        this.disabledFigures = null;
    }

    private void disableFigures() {
        if (this.disabledFigures != null) {
            for (IFigure figure : this.disabledFigures) {
                figure.setEnabled(false);
            }
        }
    }

    private void enableFigures() {
        if (this.disabledFigures != null) {
            for (IFigure figure : this.disabledFigures) {
                figure.setEnabled(true);
            }
        }
    }

    @Override
    protected void onMoving(Point currentPos, MouseDragEvent me) {
        if (this.slightMove && !((IGraphicalEditPart)this.getSourceTopic()).containsPoint(currentPos)) {
            this.slightMove = false;
        }
        super.onMoving(currentPos, me);
        if (this.branchDummy != null) {
            this.key = new ParentSearchKey(this.getSourceTopic(), (IReferencedFigure)this.branchDummy.getBranch().getTopicPart().getFigure(), currentPos);
            this.key.setFeedback(this.branchDummy.getBranch());
            this.targetParent = this.updateTargetParent();
            if (this.specialIndex < 0) {
                if (this.invent == null) {
                    this.invent = this.createInvent();
                }
                this.key.setInvent(this.invent);
                this.updateInventPosition(currentPos);
            }
            this.updateWithParent(this.targetParent);
        }
    }

    private void updateInventPosition(Point pos) {
        IFigure fig = this.getInvent();
        int x = 0;
        int y = 0;
        if (fig != null) {
            Point cursorStart = this.getStartingPosition();
            Point inventStart = this.getInventStartLoc();
            if (this.usesRelativeLocation() && cursorStart != null && inventStart != null) {
                if (this.targetParent != null && this.key != null) {
                    Point insertionPosition = this.calcInsertionPosition(this.targetParent, this.getSourceBranch(), this.key);
                    x = insertionPosition.x;
                    y = insertionPosition.y;
                } else {
                    x = pos.x - cursorStart.x + inventStart.x;
                    y = pos.y - cursorStart.y + inventStart.y;
                }
                if (fig instanceof IReferencedFigure) {
                    ((IReferencedFigure)fig).setReference(x, y);
                } else {
                    fig.setLocation(new Point(x, y));
                }
            } else if (fig instanceof IReferencedFigure) {
                ((IReferencedFigure)fig).setReference(pos.x, pos.y);
            } else {
                fig.setLocation(pos);
            }
        }
    }

    private Point calcInsertionPosition(IBranchPart parent, IBranchPart child, ParentSearchKey key) {
        IStructure structure;
        UpdateManager um = key.getFigure().getUpdateManager();
        if (um != null) {
            um.performValidation();
        }
        if (parent != null && (structure = parent.getBranchPolicy().getStructure(parent)) instanceof IInsertableBranchStructureExtension) {
            return ((IInsertableBranchStructureExtension)structure).calcInsertionPosition(parent, child, key);
        }
        return new Point(0, 0);
    }

    private boolean isBranchMoved(IBranchPart parent, IBranchPart child, ParentSearchKey key) {
        IStructure structure;
        UpdateManager um = key.getFigure().getUpdateManager();
        if (um != null) {
            um.performValidation();
        }
        if (parent != null && (structure = parent.getBranchPolicy().getStructure(parent)) instanceof IInsertableBranchStructureExtension) {
            return ((IInsertableBranchStructureExtension)structure).isBranchMoved(parent, child, key);
        }
        return true;
    }

    private IBranchPart updateTargetParent() {
        ITopicPart topicPart = this.getSourceParentTopic();
        ITopic topic = null;
        if (topicPart != null) {
            topic = topicPart.getTopic();
        }
        if (this.isFloatMove() && topic != null) {
            return null;
        }
        if (this.isSpecialFreeMove() && this.specialTargetPart instanceof IBranchPart) {
            return (IBranchPart)this.specialTargetPart;
        }
        if (this.isFreeMove() || this.isSlightMove()) {
            IPart parent = this.getSourceBranch().getParent();
            return parent instanceof IBranchPart ? (IBranchPart)parent : null;
        }
        return this.getParentSearcher().searchTargetParent((IPart)this.getTargetViewer().getRootPart(), this.key);
    }

    private void updateWithParent(IBranchPart parent) {
        this.updateDummyWithParent(parent);
        this.updateHelperWithParent(parent);
        if (this.specialIndex < 0) {
            this.updateInventVisible(parent);
        }
    }

    private void updateDummyWithParent(IBranchPart parent) {
    }

    private void updateInventVisible(IBranchPart parent) {
        if (this.invent != null) {
            this.invent.setVisible(parent != null);
        }
    }

    @Override
    protected void updateDummyPosition(Point pos) {
        super.updateDummyPosition(pos);
    }

    private void updateHelperWithParent(IBranchPart parent) {
        ITopicMoveToolHelper oldHelper = this.helper;
        ITopicMoveToolHelper newHelper = this.getHelper(parent);
        if (newHelper != oldHelper) {
            if (oldHelper != null) {
                oldHelper.deactivate(this.getDomain(), (IViewer)this.getTargetViewer());
            }
            if (newHelper != null) {
                newHelper.activate(this.getDomain(), (IViewer)this.getTargetViewer());
            }
            this.helper = newHelper;
        }
        if (this.helper != null) {
            this.helper.update(parent, this.isBranchMoved(parent, this.getSourceBranch(), this.key), this.key, this.specialIndex);
        }
    }

    private ITopicMoveToolHelper getHelper(IBranchPart parent) {
        return TopicMoveTool.getDefaultHelper();
    }

    protected static ITopicMoveToolHelper getDefaultHelper() {
        if (defaultHelper == null) {
            defaultHelper = new TopicMoveToolHelper();
        }
        return defaultHelper;
    }

    private boolean isSlightMove() {
        if (this.isFloatMove() || this.isAlreadyFloat()) {
            return false;
        }
        if (this.isSpecialFreeMove()) {
            return false;
        }
        if (this.isFreeable() && (this.isFreeMove() || this.isAlreadyFree())) {
            return false;
        }
        return this.slightMove;
    }

    private boolean isFloatMove() {
        return this.getStatus().isStatus(8);
    }

    private boolean isFreeMove() {
        if (this.isFreeMovePattern()) {
            ITopicPart topicPart = this.getSourceParentTopic();
            ITopic topic = null;
            if (topicPart != null) {
                topic = topicPart.getTopic();
            }
            return !this.isFloatMove() || topic != null;
        }
        if (this.isSpecialFreeMove()) {
            return true;
        }
        if (Util.isMac()) {
            return this.getStatus().isStatus(4);
        }
        return this.getStatus().isStatus(2);
    }

    private boolean isFreeMovePattern() {
        ITopicPart topicPart = this.getSourceParentTopic();
        ITopic topic = null;
        if (topicPart != null) {
            topic = topicPart.getTopic();
        }
        return topic == null ? this.getStatus().isStatus(4096) : this.getStatus().isStatus(4096) && topic.isRoot();
    }

    private boolean isCopyMove() {
        if (Util.isMac()) {
            return this.getStatus().isStatus(2);
        }
        return this.getStatus().isStatus(4);
    }

    private boolean isSpecialFreeMove() {
        return this.specialMove;
    }

    private boolean hasSpecicalPart() {
        List selectedParts = this.getSelectedParts((IViewer)this.getTargetViewer());
        for (IPart movedPart : selectedParts) {
            String type;
            if (!(movedPart instanceof ITopicPart) || !"callout".equals(type = ((ITopicPart)movedPart).getTopic().getType())) continue;
            IPart movedBranch = ((ITopicPart)movedPart).getParent();
            this.specialTargetPart = movedBranch.getParent();
            if (movedBranch != null && this.specialTargetPart instanceof IBranchPart) {
                this.specialIndex = ((IBranchPart)this.specialTargetPart).getCalloutBranches().indexOf(movedBranch);
            }
            return true;
        }
        return false;
    }

    protected ParentSearcher getParentSearcher() {
        if (this.parentSearcher == null) {
            this.parentSearcher = new ParentSearcher();
        }
        return this.parentSearcher;
    }

    @Override
    protected void start() {
        super.start();
        if (this.createsDummyOnActivated()) {
            this.doCreateInvent();
        }
        this.specialMove = this.hasSpecicalPart();
    }

    @Override
    protected void end() {
        if (this.helper != null) {
            this.helper.deactivate(this.getDomain(), (IViewer)this.getTargetViewer());
            this.helper = null;
        }
        super.end();
        this.destroyInvent();
        this.inventStartLoc = null;
        this.targetParent = null;
        this.parentSearcher = null;
        this.key = null;
        this.specialMove = false;
        this.specialTargetPart = null;
        this.specialIndex = -1;
        this.enableFigures();
        this.clearDisabledFigures();
        this.unlockBranchStructures((IPart)this.getTargetViewer().getRootPart());
    }

    protected void suspend() {
        if (this.helper != null) {
            this.helper.deactivate(this.getDomain(), (IViewer)this.getTargetViewer());
            this.helper = null;
        }
        super.end();
        this.destroyInvent();
    }

    private void destroyInvent(IFigure invent) {
        if (invent.getParent() != null) {
            invent.getParent().remove(invent);
        }
    }

    @Override
    protected Request createRequest() {
        IStructure structure;
        IBranchPart sourceParent;
        if (this.isSlightMove()) {
            return null;
        }
        IBranchPart targetParentBranch = this.targetParent;
        ITopicPart targetParent = targetParentBranch == null ? null : targetParentBranch.getTopicPart();
        boolean relative = true;
        Point position = relative ? this.getRelativePosition() : this.getAbsolutePosition();
        boolean copy = this.isCopyMove();
        int index = -1;
        boolean free = this.isFreeMove();
        if (!this.isFloatMove()) {
            index = this.getParentSearcher().getIndex(targetParentBranch, this.key);
            if (free) {
                if (!(this.isFreeable() || this.isAlreadyFloat() || this.isSpecialFreeMove())) {
                    free = false;
                }
            } else if (targetParent != null) {
                if (targetParent == this.getSourceParentTopic()) {
                    if (this.isFreeable()) {
                        free = this.isAlreadyFree();
                    }
                } else {
                    position = null;
                }
            }
            if (!free && targetParent != null) {
                position = null;
            }
        }
        String reqType = copy ? "copy to" : "move to";
        Request request = new Request(reqType);
        request.setDomain(this.getDomain());
        request.setViewer((IViewer)this.getTargetViewer());
        ArrayList<IPart> parts = new ArrayList<IPart>();
        for (IPart p : this.getSelectedParts((IViewer)this.getTargetViewer())) {
            if (!p.hasRole("movable role")) continue;
            parts.add(p);
        }
        request.setTargets(parts);
        request.setPrimaryTarget((IPart)this.getSourceTopic());
        request.setParameter("position", (Object)position);
        request.setParameter("positionAbsolute", (Object)this.getAbsolutePosition());
        request.setParameter("positionRelative", (Object)relative);
        request.setParameter("parent", (Object)targetParent);
        request.setParameter("index", (Object)index);
        request.setParameter("copy", (Object)copy);
        request.setParameter("free", (Object)free);
        IBranchPart sourceBranch = this.getSourceBranch();
        if (sourceBranch != null) {
            sourceParent = sourceBranch.getParentBranch();
            if (sourceParent != null && (structure = sourceParent.getBranchPolicy().getStructure(sourceParent)) instanceof IMovableBranchStructureExtension) {
                ((IMovableBranchStructureExtension)structure).decorateMoveOutRequest(sourceParent, this.key, targetParentBranch, request);
            }
        } else {
            sourceParent = null;
        }
        if (targetParentBranch != null && (structure = targetParentBranch.getBranchPolicy().getStructure(targetParentBranch)) instanceof IMovableBranchStructureExtension) {
            ((IMovableBranchStructureExtension)structure).decorateMoveInRequest(targetParentBranch, this.key, sourceParent, request);
        }
        return request;
    }

    private boolean isAlreadyFree() {
        return this.getSourceTopic().getTopic().getPosition() != null;
    }

    private boolean isAlreadyFloat() {
        return !this.getSourceTopic().getTopic().isAttached();
    }

    private boolean isFreeable() {
        if (!MindMapUI.isFreePositionMoveAllowed()) {
            return false;
        }
        IBranchPart branch = this.getSourceBranch();
        return branch != null && MindMapUtils.isSubBranchesFreeable(branch.getParentBranch());
    }

    private ITopicPart getSourceParentTopic() {
        IPart p;
        IBranchPart sourceBranch = this.getSourceBranch();
        if (sourceBranch != null && (p = sourceBranch.getParent()) instanceof IBranchPart) {
            return ((IBranchPart)p).getTopicPart();
        }
        return null;
    }

    private Point getRelativePosition() {
        Dimension off = this.getCursorPosition().getDifference(this.getStartingPosition());
        return new Point(off.width, off.height);
    }

    private Point getAbsolutePosition() {
        return this.getCursorPosition();
    }

    public void statusChanged(StatusEvent event) {
        int k = event.key;
        if (this.getStatus().isStatus(1) && (k == 8 || k == 4 || k == 2)) {
            this.updateDisabilities();
            this.updateDummyPosition(this.getCursorPosition());
            this.targetParent = this.updateTargetParent();
            this.updateWithParent(this.targetParent);
        }
    }

    private void updateDisabilities() {
        if (this.isCopyMove()) {
            this.enableFigures();
        } else {
            this.disableFigures();
        }
    }

    public Cursor getCurrentCursor(Point pos, IPart host) {
        if (this.isCopyMove()) {
            return MindMapUI.getImages().getCursor(IMindMapImages.CURSOR_ADD);
        }
        return super.getCurrentCursor(pos, host);
    }

    private class RoundedRectDecoration
    extends PathShapeDecoration {
        private RoundedRectDecoration() {
        }

        public Insets getPreferredInsets(IFigure figure, int width, int height) {
            int lineWidth = this.getLineWidth();
            return new Insets(lineWidth, lineWidth, lineWidth, lineWidth);
        }

        protected void sketch(IFigure figure, Path shape, Rectangle box, int purpose) {
            shape.addRoundedRectangle(box, 5.0f);
        }
    }
}

