/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.decorations.IDecorationDescriptor;
import org.xmind.ui.internal.properties.LinePropertySectionPartBase;
import org.xmind.ui.internal.properties.PropertyMessages;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ISummaryPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.properties.DecorationLabelProvider;
import org.xmind.ui.viewers.MComboViewer;

public class SummaryLinePropertySectionPart
extends LinePropertySectionPartBase {
    private static List<IDecorationDescriptor> LineShapes;
    private MComboViewer lineShapeViewer;

    @Override
    protected void createContent(Composite parent) {
        this.createLineShapeBar(parent);
        super.createContent(parent);
    }

    private void createLineShapeBar(Composite parent) {
        Composite line1 = new Composite(parent, 0);
        line1.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 3;
        layout.verticalSpacing = 3;
        line1.setLayout((Layout)layout);
        this.lineShapeViewer = new MComboViewer(line1, 0);
        this.lineShapeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.lineShapeViewer.getControl().setToolTipText(PropertyMessages.SummaryShape_toolTip);
        this.lineShapeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.lineShapeViewer.setLabelProvider((IBaseLabelProvider)new DecorationLabelProvider());
        this.lineShapeViewer.setInput(this.getLineShapes());
        this.lineShapeViewer.addSelectionChangedListener((ISelectionChangedListener)new LineShapeSelectionChangedListener());
    }

    protected List<IDecorationDescriptor> getLineShapes() {
        return SummaryLinePropertySectionPart.getBranchConnectionShapes();
    }

    @Override
    public void setFocus() {
        if (this.lineShapeViewer != null && !this.lineShapeViewer.getControl().isDisposed()) {
            this.lineShapeViewer.getControl().setFocus();
        } else {
            super.setFocus();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.lineShapeViewer = null;
    }

    @Override
    protected Request fillTargets(Request request) {
        request = super.fillTargets(request);
        IGraphicalViewer viewer = this.getActiveViewer();
        if (viewer != null) {
            List targets = request.getTargets();
            ArrayList<ISummaryPart> realTargets = new ArrayList<ISummaryPart>(targets.size());
            for (IPart p : targets) {
                ISummaryPart summary;
                if (!(p instanceof ITopicPart) || (summary = this.findSummaryPartByTopicPart((ITopicPart)p)) == null) continue;
                realTargets.add(summary);
            }
            request.setTargets(realTargets);
        }
        return request;
    }

    private ISummaryPart findSummaryPartByTopicPart(ITopicPart topic) {
        IBranchPart parent;
        IBranchPart branch = topic.getOwnerBranch();
        if (branch != null && (parent = branch.getParentBranch()) != null) {
            for (ISummaryPart summary : parent.getSummaries()) {
                if (summary.getNode() != topic) continue;
                return summary;
            }
        }
        return null;
    }

    @Override
    protected IGraphicalPart getGraphicalPart(Object o, IViewer viewer) {
        IGraphicalPart part = super.getGraphicalPart(o, viewer);
        if (part instanceof ITopicPart) {
            part = this.findSummaryPartByTopicPart((ITopicPart)part);
        }
        return part;
    }

    @Override
    protected String getLineShapeId() {
        return this.getStyleValue("shape-class", null);
    }

    @Override
    protected void refreshWithShapeId(String lineShapeId) {
        if (this.lineShapeViewer != null && !this.lineShapeViewer.getControl().isDisposed()) {
            IDecorationDescriptor element = this.getSelectableLineShape(lineShapeId);
            if (element == null) {
                this.lineShapeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            } else {
                this.lineShapeViewer.setSelection((ISelection)new StructuredSelection((Object)element));
            }
        }
        super.refreshWithShapeId(lineShapeId);
    }

    private IDecorationDescriptor getSelectableLineShape(String shapeId) {
        if (shapeId == null) {
            return null;
        }
        IDecorationDescriptor descriptor = MindMapUI.getDecorationManager().getDecorationDescriptor(shapeId);
        if (!this.getLineShapes().contains(descriptor)) {
            return null;
        }
        return descriptor;
    }

    private void changeLineShape(String lineShapeId) {
        Request request = this.createStyleRequest(CommandMessages.Command_ModifyLineShape);
        this.addStyle(request, "shape-class", lineShapeId);
        this.sendRequest(request);
    }

    private static List<IDecorationDescriptor> getBranchConnectionShapes() {
        if (LineShapes == null) {
            LineShapes = MindMapUI.getDecorationManager().getDescriptors("org.xmind.ui.summaryDecorations");
        }
        return LineShapes;
    }

    private class LineShapeSelectionChangedListener
    implements ISelectionChangedListener {
        private LineShapeSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (SummaryLinePropertySectionPart.this.isRefreshing()) {
                return;
            }
            Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (o instanceof IDecorationDescriptor) {
                SummaryLinePropertySectionPart.this.changeLineShape(((IDecorationDescriptor)o).getId());
            }
        }
    }
}

