/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.Core;
import org.xmind.core.IFileEntry;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.command.ModifyCommand;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.ui.commands.ModifyImageSizeCommand;
import org.xmind.ui.commands.ModifyImageSourceCommand;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.io.DownloadJob;
import org.xmind.ui.io.UIJobChangeListener;

public class ImageDownloadCenter {
    private static ImageDownloadCenter instance = new ImageDownloadCenter();
    private Map<ITopic, ImageDownloadProcess> processes = new HashMap<ITopic, ImageDownloadProcess>();

    private ImageDownloadCenter() {
    }

    public void startDownload(ITopic topic, String url, ICommandStack commandStack) {
        this.cancel(topic);
        this.processes.put(topic, new ImageDownloadProcess(topic, url, commandStack));
    }

    public void cancel(ITopic topic) {
        ImageDownloadProcess proc = this.processes.remove(topic);
        if (proc != null) {
            proc.kill();
        }
    }

    public boolean isDownloading(ITopic topic) {
        ImageDownloadProcess proc = this.processes.get(topic);
        return proc != null && !proc.isDead();
    }

    public static ImageDownloadCenter getInstance() {
        return instance;
    }

    protected class ImageDownloadProcess
    extends UIJobChangeListener {
        private ITopic topic;
        private String url;
        private ICommandStack commandStack;
        private File tempFile;
        private DownloadJob job;

        public ImageDownloadProcess(ITopic topic, String url, ICommandStack commandStack) {
            this.topic = topic;
            this.url = url;
            this.commandStack = commandStack;
            this.tempFile = this.createTempFile(FileUtils.getExtension((String)url));
            this.start();
        }

        public ITopic getTopic() {
            return this.topic;
        }

        public String getUrl() {
            return this.url;
        }

        private void start() {
            this.job = new DownloadJob(String.valueOf(MindMapMessages.ImageDownload_jobName) + this.url, this.url, this.tempFile.getAbsolutePath(), "org.xmind.ui.mindmap");
            this.job.addJobChangeListener((IJobChangeListener)this);
            this.job.schedule();
        }

        private File createTempFile(String ext) {
            return Core.getWorkspace().createTempFile("imageDownload", "", ext);
        }

        public void kill() {
            if (this.job != null) {
                this.job.cancel();
                this.job = null;
            }
        }

        public boolean isDead() {
            return this.job == null;
        }

        protected void doAboutToRun(IJobChangeEvent event) {
            super.doAboutToRun(event);
            this.notifyImageContent();
        }

        protected void doDone(IJobChangeEvent event) {
            this.job = null;
            ImageDownloadCenter.this.processes.remove(this.topic);
            int code = event.getResult().getSeverity();
            if (code == 0) {
                this.onSuccess();
            } else if (code == 8) {
                this.onCancel();
            } else {
                this.onFailed();
            }
            this.tempFile.delete();
        }

        private void onSuccess() {
            this.addImage();
        }

        private void onCancel() {
            this.notifyImageContent();
        }

        private void onFailed() {
            this.notifyImageContent();
        }

        private void notifyImageContent() {
            if (this.topic.getImage() instanceof ICoreEventSource) {
                ICoreEventSource source = (ICoreEventSource)this.topic.getImage();
                source.getCoreEventSupport().dispatchValueChange(source, "imageSource", (Object)this.topic.getImage().getSource(), (Object)this.url);
            }
        }

        private Dimension getSize() {
            try {
                Image image = new Image((Device)Display.getCurrent(), this.tempFile.getAbsolutePath());
                Rectangle size = image.getBounds();
                image.dispose();
                return Geometry.getScaledConstrainedSize((int)size.width, (int)size.height, (int)400, (int)400);
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        private void addImage() {
            final Dimension size = this.getSize();
            if (size == null) {
                if (this.topic.getImage() instanceof ICoreEventSource) {
                    ICoreEventSource source = (ICoreEventSource)this.topic.getImage();
                    source.getCoreEventSupport().dispatchValueChange(source, "imageSource", (Object)this.topic.getImage().getSource(), null);
                }
                return;
            }
            final IWorkbook workbook = this.topic.getOwnedWorkbook();
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    IFileEntry entry = workbook.getManifest().createAttachmentFromFilePath(ImageDownloadProcess.this.tempFile.getAbsolutePath());
                    if (entry != null) {
                        String source = HyperlinkUtils.toAttachmentURL((String)entry.getPath());
                        ArrayList<ModifyCommand> cmds = new ArrayList<ModifyCommand>();
                        cmds.add(new ModifyImageSourceCommand(ImageDownloadProcess.this.topic, source));
                        cmds.add(new ModifyImageSizeCommand(ImageDownloadProcess.this.topic, size.width, size.height));
                        CompoundCommand cmd = new CompoundCommand(cmds);
                        cmd.setLabel(MindMapMessages.Command_InsertImage);
                        ImageDownloadProcess.this.commandStack.execute((Command)cmd);
                    }
                }
            });
        }
    }
}

