/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.handlers;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.handlers.HandlerUtil;
import org.xmind.core.IFileEntry;
import org.xmind.core.IImage;
import org.xmind.core.ITopic;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.ui.internal.dialogs.DialogMessages;

public class SaveImageAsHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        this.saveSelectedImageAsFile(selection);
        return null;
    }

    private void saveSelectedImageAsFile(ISelection selection) {
        Program p;
        IImage image = this.getSourceImage(selection);
        if (image == null) {
            return;
        }
        ITopic sourceTopic = image.getParent();
        if (sourceTopic == null) {
            return;
        }
        String url = image.getSource();
        if (url == null || !HyperlinkUtils.isAttachmentURL((String)url)) {
            return;
        }
        String entryPath = HyperlinkUtils.toAttachmentPath((String)url);
        final IFileEntry entry = sourceTopic.getOwnedWorkbook().getManifest().getFileEntry(entryPath);
        if (entry == null) {
            return;
        }
        FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
        String ext = FileUtils.getExtension((String)entryPath);
        dialog.setFilterExtensions(new String[]{"*" + ext, "*.*"});
        String extension = ext;
        if (ext != null && (p = Program.findProgram((String)ext)) != null) {
            extension = p.getName();
        }
        dialog.setFilterNames(new String[]{extension, NLS.bind((String)"{0} (*.*)", (Object)DialogMessages.AllFilesFilterName)});
        String name = sourceTopic.getTitleText();
        if (name != null && !name.endsWith(ext)) {
            name = String.valueOf(name) + ext;
        }
        if (name != null) {
            dialog.setFileName(name);
        }
        dialog.setOverwrite(true);
        final String targetPath = dialog.open();
        if (targetPath == null) {
            return;
        }
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                InputStream is = entry.openInputStream();
                try {
                    FileOutputStream os = new FileOutputStream(targetPath);
                    try {
                        FileUtils.transfer((InputStream)is, (OutputStream)os, (boolean)true);
                    }
                    finally {
                        os.close();
                    }
                }
                finally {
                    is.close();
                }
            }
        });
    }

    private IImage getSourceImage(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            for (Object element : ((IStructuredSelection)selection).toList()) {
                ITopic topic;
                IImage image;
                if (!(element instanceof ITopic ? (image = (topic = (ITopic)element).getImage()).getSource() != null : element instanceof IImage && (image = (IImage)element).getSource() != null)) continue;
                return image;
            }
        }
        return null;
    }
}

