/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editpolicies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.xmind.core.IBoundary;
import org.xmind.core.IPositioned;
import org.xmind.core.IRange;
import org.xmind.core.IRelationship;
import org.xmind.core.ISummary;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicRange;
import org.xmind.gef.IViewer;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.commands.AddBoundaryCommand;
import org.xmind.ui.commands.AddSummaryCommand;
import org.xmind.ui.commands.AddTopicCommand;
import org.xmind.ui.commands.CloneTopicCommand;
import org.xmind.ui.commands.CommandBuilder;
import org.xmind.ui.commands.DeleteBoundaryCommand;
import org.xmind.ui.commands.DeleteSummaryCommand;
import org.xmind.ui.commands.DeleteTopicCommand;
import org.xmind.ui.commands.ModifyBoundaryMasterCommand;
import org.xmind.ui.commands.ModifyPositionCommand;
import org.xmind.ui.commands.ModifyRangeCommand;
import org.xmind.ui.internal.editpolicies.DeleteCommandBuilder;
import org.xmind.ui.util.MindMapUtils;

public class TopicMoveCommandBuilder
extends DeleteCommandBuilder {
    private static final List<ITopic> EMPTY_TOPICS = Collections.emptyList();
    private ITopic targetParent;
    private int targetIndex;
    private String targetType;
    private Point targetPosition;
    private boolean relative;
    private int insertIndex;
    private Set<ITopic> cachedParent = null;
    private Map<ITopicRange, List<ITopic>> oldRangedTopics = null;
    private Set<ITopicRange> rangesToMove = null;

    public TopicMoveCommandBuilder(IViewer viewer, CommandBuilder delegate, ITopic targetParent, int targetIndex, String targetType, Point targetPosition, boolean relative) {
        super(viewer, delegate);
        this.init(targetParent, targetIndex, targetType, targetPosition, relative);
    }

    public TopicMoveCommandBuilder(IViewer viewer, ICommandStack commandStack, ITopic targetParent, int targetIndex, String targetType, Point targetPosition, boolean relative) {
        super(viewer, commandStack);
        this.init(targetParent, targetIndex, targetType, targetPosition, relative);
    }

    private void init(ITopic targetParent, int targetIndex, String targetType, Point targetPosition, boolean relative) {
        this.targetParent = targetParent;
        this.targetIndex = targetIndex;
        this.targetType = targetType;
        this.targetPosition = targetPosition;
        this.relative = relative;
        this.insertIndex = targetIndex;
        if (this.insertIndex < 0) {
            this.insertIndex = targetParent.getChildren(targetType).size();
        }
    }

    public int getTargetIndex() {
        return this.targetIndex;
    }

    public ITopic getTargetParent() {
        return this.targetParent;
    }

    public Point getTargetPosition() {
        return this.targetPosition;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public boolean isRelative() {
        return this.relative;
    }

    public int getInsertIndex() {
        return this.insertIndex;
    }

    public void copyTopics(List<ITopic> topics) {
        for (ITopic topic : topics) {
            this.copyTopic(topic, this.insertIndex);
            ++this.insertIndex;
        }
    }

    public void moveTopics(List<ITopic> topics) {
        HashMap<ITopic, TopicInfo> oldInfo = new HashMap<ITopic, TopicInfo>(topics.size());
        for (ITopic topic : topics) {
            TopicInfo info = this.deleteTopic(topic, this.insertIndex);
            if (oldInfo.containsKey(topic)) continue;
            oldInfo.put(topic, info);
        }
        for (ITopic topic : topics) {
            this.moveTopic(topic, this.insertIndex, (TopicInfo)oldInfo.get(topic));
            ++this.insertIndex;
        }
    }

    private TopicInfo deleteTopic(ITopic topic, int toIndex) {
        TopicInfo info = new TopicInfo();
        info.oldParent = topic.getParent();
        info.oldIndex = topic.getIndex();
        info.oldType = topic.getType();
        info.newPosition = this.calculateTargetPosition(topic);
        info.needsReorganize = this.needsReorganize(topic, toIndex, info.oldParent, info.oldIndex, info.oldType);
        if (info.needsReorganize) {
            if (!this.isCached(info.oldParent)) {
                for (ITopicRange range : this.getSubRanges(info.oldParent)) {
                    this.cacheOldRangedTopics(range, info.oldParent);
                }
            }
            this.deleteTopic(topic, true);
        }
        return info;
    }

    private void moveTopic(ITopic topic, int toIndex, TopicInfo info) {
        this.add((Command)new ModifyPositionCommand((IPositioned)topic, MindMapUtils.toModelPosition(info.newPosition)), !info.needsReorganize);
        if (info.needsReorganize) {
            this.addTopic(topic, this.getTargetParent(), toIndex, this.getTargetType(), true);
            if (this.rangesToMove != null && !this.rangesToMove.isEmpty()) {
                while (!this.rangesToMove.isEmpty()) {
                    ITopicRange range = this.rangesToMove.iterator().next();
                    this.moveRange(range, range.getParent());
                    this.rangesToMove.remove(range);
                }
            }
        }
    }

    private void addTopic(ITopic topic, ITopic toParent, int toIndex, String toType, boolean topicCollectable) {
        this.add((Command)new AddTopicCommand(topic, toParent, toIndex, toType), topicCollectable);
        if ("attached".equals(toType)) {
            int topicIndex = topic.getIndex();
            this.enlargeOldBoundaries(topic, toParent, topicIndex);
            this.moveMasterBoundaries(topic, topicIndex);
        }
    }

    private void enlargeOldBoundaries(ITopic topic, ITopic parent, int index) {
        Set<ITopicRange> ranges = this.getSubRanges(parent);
        for (ITopicRange range : ranges) {
            int startIndex = range.getStartIndex();
            int endIndex = range.getEndIndex();
            if (index <= endIndex) {
                this.add((Command)new ModifyRangeCommand((IRange)range, endIndex + 1, false), false);
            }
            if (index > startIndex) continue;
            this.add((Command)new ModifyRangeCommand((IRange)range, startIndex + 1, true), false);
        }
    }

    private void moveMasterBoundaries(ITopic topic, int topicIndex) {
        IBoundary existingSingleBoundary;
        IBoundary masterBoundary = null;
        Object[] objectArray = this.getSubRanges(topic).toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBoundary boundary;
            Object o = objectArray[n2];
            ITopicRange range = (ITopicRange)o;
            if (range instanceof IBoundary && (boundary = (IBoundary)range).isMasterBoundary() && masterBoundary == null) {
                masterBoundary = boundary;
                this.addDeleteRangeCommand((ITopicRange)boundary, topic);
            }
            ++n2;
        }
        if (masterBoundary != null && (existingSingleBoundary = this.findSingleBoundary(this.getTargetParent(), topicIndex)) == null) {
            this.add((Command)new ModifyBoundaryMasterCommand(masterBoundary, false), false);
            this.add((Command)new ModifyRangeCommand((IRange)masterBoundary, topicIndex, true), false);
            this.add((Command)new ModifyRangeCommand((IRange)masterBoundary, topicIndex, false), false);
            this.addAddRangeCommand((ITopicRange)masterBoundary, this.getTargetParent());
        }
    }

    private IBoundary findSingleBoundary(ITopic parent, int childIndex) {
        for (ITopicRange range : this.getSubRanges(parent)) {
            if (!(range instanceof IBoundary) || range.getStartIndex() != childIndex || range.getEndIndex() != childIndex) continue;
            return (IBoundary)range;
        }
        return null;
    }

    private IBoundary findMasterBoundary(ITopic parent) {
        for (ITopicRange range : this.getSubRanges(parent)) {
            if (!(range instanceof IBoundary) || !((IBoundary)range).isMasterBoundary()) continue;
            return (IBoundary)range;
        }
        return null;
    }

    private void moveRange(ITopicRange range, ITopic oldParent) {
        ITopic summaryTopic = null;
        if (range instanceof ISummary && (summaryTopic = ((ISummary)range).getTopic()) != null) {
            this.add((Command)new DeleteTopicCommand(summaryTopic), false);
        }
        this.addDeleteRangeCommand(range, oldParent);
        List<ITopic> rangedTopics = this.getOldRangedTopics(range);
        if (!rangedTopics.isEmpty()) {
            ITopic topic;
            IBoundary overallBoundary;
            if ("attached".equals(this.getTargetType())) {
                int startIndex = rangedTopics.get(0).getIndex();
                int endIndex = rangedTopics.get(rangedTopics.size() - 1).getIndex();
                this.add((Command)new ModifyRangeCommand((IRange)range, startIndex, true), false);
                this.add((Command)new ModifyRangeCommand((IRange)range, endIndex, false), false);
                this.addAddRangeCommand(range, this.getTargetParent());
                if (summaryTopic != null) {
                    this.addTopic(summaryTopic, this.getTargetParent(), -1, "summary", false);
                }
            } else if (range instanceof IBoundary && rangedTopics.size() == 1 && (overallBoundary = this.findMasterBoundary(topic = rangedTopics.get(0))) == null) {
                this.add((Command)new ModifyRangeCommand((IRange)range, -1, true), false);
                this.add((Command)new ModifyRangeCommand((IRange)range, -1, false), false);
                this.add((Command)new ModifyBoundaryMasterCommand((IBoundary)range, true), false);
                this.addAddRangeCommand(range, topic);
            }
        }
    }

    private void addDeleteRangeCommand(ITopicRange range, ITopic oldParent) {
        if (range instanceof IBoundary) {
            this.add((Command)new DeleteBoundaryCommand((IBoundary)range), false);
        } else if (range instanceof ISummary) {
            this.add((Command)new DeleteSummaryCommand((ISummary)range), false);
        }
        this.removeSubRange(range, oldParent);
    }

    private void addAddRangeCommand(ITopicRange range, ITopic newParent) {
        if (range instanceof IBoundary) {
            this.add((Command)new AddBoundaryCommand((IBoundary)range, newParent), false);
        } else if (range instanceof ISummary) {
            this.add((Command)new AddSummaryCommand((ISummary)range, newParent), false);
        }
        this.addSubRange(range, newParent);
    }

    @Override
    protected void deleteBoundary(IBoundary boundary, boolean sourceCollectable) {
        if (this.rangesToMove == null) {
            this.rangesToMove = new HashSet<ITopicRange>();
        }
        this.rangesToMove.add((ITopicRange)boundary);
    }

    @Override
    protected void deleteSummary(ISummary summary, boolean sourceCollectable) {
        if (this.rangesToMove == null) {
            this.rangesToMove = new HashSet<ITopicRange>();
        }
        this.rangesToMove.add((ITopicRange)summary);
    }

    @Override
    protected void deleteRelationship(IRelationship relationship, boolean sourceCollectable) {
    }

    private Point calculateTargetPosition(ITopic topic) {
        Point position = this.getTargetPosition();
        if (position == null) {
            return null;
        }
        IPart parentPart = this.getViewer().findPart((Object)this.getTargetParent());
        if (parentPart == null) {
            return null;
        }
        Point parentPosition = TopicMoveCommandBuilder.getPosition((IGraphicalPart)parentPart);
        if (parentPosition == null) {
            return null;
        }
        if (this.isRelative()) {
            IPart topicPart = this.getViewer().findPart((Object)topic);
            if (topicPart == null) {
                return null;
            }
            Point oldPosition = TopicMoveCommandBuilder.getPosition((IGraphicalPart)topicPart);
            return TopicMoveCommandBuilder.toNewPosition(parentPosition, oldPosition, position);
        }
        return TopicMoveCommandBuilder.toNewPosition(parentPosition, position);
    }

    protected static Point getPosition(IGraphicalPart part) {
        IFigure figure = part.getFigure();
        if (figure instanceof IReferencedFigure) {
            return ((IReferencedFigure)figure).getReference();
        }
        return figure.getBounds().getLocation();
    }

    private static Point toNewPosition(Point parentPosition, Point oldPosition, Point position) {
        int x = oldPosition.x + position.x - parentPosition.x;
        int y = oldPosition.y + position.y - parentPosition.y;
        return new Point(x, y);
    }

    private static Point toNewPosition(Point parentPosition, Point position) {
        int x = position.x - parentPosition.x;
        int y = position.y - parentPosition.y;
        return new Point(x, y);
    }

    private boolean needsReorganize(ITopic topic, int toIndex, ITopic oldParent, int oldIndex, String oldType) {
        if (!this.getTargetParent().equals(oldParent)) {
            return true;
        }
        if (!(oldType == this.getTargetType() || oldType != null && oldType.equals(this.getTargetType()))) {
            return true;
        }
        return "attached".equals(oldType) && oldIndex != this.getValidAttachedIndex(oldParent, toIndex);
    }

    private int getValidAttachedIndex(ITopic parent, int index) {
        int size = parent.getChildren("attached").size();
        return index >= size ? index - 1 : index;
    }

    protected boolean isCached(ITopic parent) {
        return this.cachedParent != null && this.cachedParent.contains(parent);
    }

    protected void cacheOldRangedTopics(ITopicRange range, ITopic parent) {
        List<ITopic> list;
        if (this.cachedParent == null) {
            this.cachedParent = new HashSet<ITopic>();
        }
        this.cachedParent.add(parent);
        if (this.oldRangedTopics == null) {
            this.oldRangedTopics = new HashMap<ITopicRange, List<ITopic>>();
        }
        if ((list = this.oldRangedTopics.get(range)) == null) {
            list = new ArrayList<ITopic>(range.getEnclosingTopics());
            this.oldRangedTopics.put(range, list);
        }
    }

    protected List<ITopic> getOldRangedTopics(ITopicRange range) {
        List<ITopic> list;
        if (this.oldRangedTopics != null && (list = this.oldRangedTopics.get(range)) != null) {
            return list;
        }
        return EMPTY_TOPICS;
    }

    private void copyTopic(ITopic topic, int toIndex) {
        Point position = this.calculateTargetPosition(topic);
        CloneTopicCommand clone = new CloneTopicCommand(this.getTargetParent().getOwnedWorkbook(), topic);
        this.add((Command)clone, true);
        ITopic clonedTopic = (ITopic)clone.getSource();
        this.add((Command)new ModifyPositionCommand((IPositioned)clonedTopic, MindMapUtils.toModelPosition(position)), false);
        this.addTopic(clonedTopic, this.getTargetParent(), toIndex, this.getTargetType(), true);
    }

    private static class TopicInfo {
        public ITopic oldParent;
        public int oldIndex;
        public String oldType;
        public Point newPosition;
        public boolean needsReorganize;

        private TopicInfo() {
        }
    }
}

