/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editpolicies;

import org.eclipse.draw2d.geometry.Point;
import org.xmind.core.IRelationshipEnd;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.gef.ISourceProvider;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.command.Command;
import org.xmind.gef.part.IPart;
import org.xmind.ui.commands.AddTopicCommand;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.CreateTopicCommand;
import org.xmind.ui.commands.ModifyPositionCommand;
import org.xmind.ui.commands.ModifyTitleTextCommand;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.editpolicies.MindMapPolicyBase;
import org.xmind.ui.internal.editpolicies.PropertyCommandBuilder;
import org.xmind.ui.internal.editpolicies.RelationshipCreateCommandBuilder;
import org.xmind.ui.util.MindMapUtils;

public class SheetCreatablePolicy
extends MindMapPolicyBase {
    public boolean understands(String requestType) {
        return super.understands(requestType) || "create_floating".equals(requestType) || "create_relationship".equals(requestType);
    }

    public void handle(Request request) {
        String reqType = request.getType();
        if ("create_floating".equals(reqType)) {
            this.createFloatingTopic(request);
        } else if ("create_relationship".equals(reqType)) {
            this.createRelationship(request);
        }
    }

    private void createRelationship(Request request) {
        IPart sourceNode = (IPart)request.getParameter("sourceNode");
        if (sourceNode == null) {
            return;
        }
        Object m1 = MindMapUtils.getRealModel(sourceNode);
        if (!(m1 instanceof IRelationshipEnd)) {
            return;
        }
        IRelationshipEnd end1 = (IRelationshipEnd)m1;
        IViewer viewer = request.getTargetViewer();
        if (viewer == null) {
            return;
        }
        ISheet parent = (ISheet)viewer.getAdapter(ISheet.class);
        if (parent == null) {
            return;
        }
        RelationshipCreateCommandBuilder builder = new RelationshipCreateCommandBuilder(viewer, request.getTargetCommandStack(), parent, end1);
        if (builder.canStart()) {
            builder.start();
            IPart targetNode = (IPart)request.getParameter("targetNode");
            if (targetNode != null) {
                Object m2 = MindMapUtils.getRealModel(targetNode);
                if (m2 instanceof IRelationshipEnd) {
                    builder.create((IRelationshipEnd)m2);
                }
            } else {
                Point targetPosition = (Point)request.getParameter("position");
                if (targetPosition != null) {
                    builder.create(targetPosition);
                }
            }
            builder.end();
            this.select(builder.getCommand().getSources(), viewer);
        }
    }

    private void createFloatingTopic(Request request) {
        IViewer viewer = request.getTargetViewer();
        if (viewer == null) {
            return;
        }
        ITopic rootTopic = (ITopic)viewer.getAdapter(ITopic.class);
        if (rootTopic == null) {
            return;
        }
        Point position = (Point)request.getParameter("position");
        if (position == null) {
            return;
        }
        PropertyCommandBuilder builder = new PropertyCommandBuilder(request);
        if (!builder.canStart()) {
            return;
        }
        builder.start();
        builder.setLabel(CommandMessages.Command_CreateFloatingTopic);
        CreateTopicCommand create = new CreateTopicCommand(rootTopic.getOwnedWorkbook());
        builder.add((Command)create, true);
        builder.add((Command)new AddTopicCommand((ISourceProvider)create, rootTopic, -1, "detached"), false);
        builder.add((Command)new ModifyTitleTextCommand((ISourceProvider)create, MindMapMessages.TitleText_FloatingTopic), false);
        builder.add((Command)new ModifyPositionCommand((ISourceProvider)create, MindMapUtils.toModelPosition(position)), false);
        builder.addSource(create.getSource(), true);
        builder.end();
        this.select(builder.getCommand().getSources(), viewer);
    }
}

