/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.net.URI;
import java.util.regex.Pattern;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.Assert;
import org.xmind.gef.ui.editor.Editable;
import org.xmind.ui.mindmap.IWorkbookRef;

public class WorkbookRefPropertyTester
extends PropertyTester {
    private static final String P_URI = "uri";
    private static final String P_URI_SCHEME = "uriScheme";
    private static final String P_EXIST = "exist";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        Assert.isLegal((boolean)(receiver instanceof IWorkbookRef));
        IWorkbookRef workbookRef = (IWorkbookRef)receiver;
        if (P_URI.equals(property)) {
            String uriString = workbookRef.getURI().toString();
            if (expectedValue instanceof String && ((String)expectedValue).startsWith("^")) {
                return Pattern.matches((String)expectedValue, uriString);
            }
            return WorkbookRefPropertyTester.testStringValue(uriString, expectedValue);
        }
        if (P_URI_SCHEME.equals(property)) {
            URI uri = workbookRef.getURI();
            return WorkbookRefPropertyTester.testStringValue(uri == null ? null : uri.getScheme(), expectedValue);
        }
        if (P_EXIST.equals(property)) {
            boolean exists = ((Editable)workbookRef).exists();
            if (expectedValue == null || expectedValue.equals("") || expectedValue.equals(Boolean.TRUE.toString())) {
                return exists;
            }
            if (expectedValue.equals(Boolean.FALSE.toString())) {
                return !exists;
            }
        }
        Assert.isTrue((boolean)false, (String)("Unrecognized property: " + property));
        return false;
    }

    private static boolean testStringValue(String actualValue, Object expectedValue) {
        if ("".equals(expectedValue)) {
            expectedValue = null;
        } else if (expectedValue != null) {
            expectedValue = expectedValue.toString();
        }
        return actualValue == expectedValue || actualValue != null && actualValue.equals(expectedValue);
    }
}

