/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.xmind.core.CoreException;
import org.xmind.core.IEntryStreamNormalizer;
import org.xmind.core.IFileEntry;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.internal.security.PasswordProtectedNormalizer;
import org.xmind.ui.internal.editor.AbstractWorkbookRef;
import org.xmind.ui.internal.editor.IEncryptable;
import org.xmind.ui.internal.editor.IPasswordProvider;

public class WorkbookRefEncryptable
implements IEncryptable {
    private final AbstractWorkbookRef workbookRef;
    private IEntryStreamNormalizer encryptor;
    private String password;
    private String passwordHint;

    public WorkbookRefEncryptable(AbstractWorkbookRef workbookRef) {
        this.workbookRef = workbookRef;
        this.encryptor = new LazyPasswordBasedEncryptor(workbookRef);
    }

    @Override
    public void setPassword(String newPassword) {
        IEntryStreamNormalizer oldEncryptor = this.encryptor;
        IEntryStreamNormalizer newEncryptor = WorkbookRefEncryptable.createEncryptor(newPassword);
        if (WorkbookRefEncryptable.encryptorEquals(oldEncryptor, newEncryptor)) {
            return;
        }
        this.encryptor = newEncryptor;
        IWorkbook workbook = this.workbookRef.getWorkbook();
        if (workbook != null && workbook instanceof ICoreEventSource) {
            ICoreEventSource eventSource = (ICoreEventSource)workbook;
            eventSource.getCoreEventSupport().dispatch(eventSource, new CoreEvent(eventSource, "passwordChange", null));
        }
        this.password = newPassword;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPasswordHint(String passwordHint) {
        this.passwordHint = passwordHint;
    }

    @Override
    public String getPasswordHint() {
        return this.passwordHint;
    }

    @Override
    public boolean testsPassword(String passwordToTest) {
        IEntryStreamNormalizer oldEncryptor = this.encryptor;
        IEntryStreamNormalizer newEncryptor = WorkbookRefEncryptable.createEncryptor(passwordToTest);
        return WorkbookRefEncryptable.encryptorEquals(oldEncryptor, newEncryptor);
    }

    private static boolean encryptorEquals(IEntryStreamNormalizer oldEncryptor, IEntryStreamNormalizer newEncryptor) {
        return oldEncryptor.equals(newEncryptor);
    }

    @Override
    public boolean hasPassword() {
        IEntryStreamNormalizer e = this.encryptor;
        while (e instanceof LazyPasswordBasedEncryptor) {
            e = ((LazyPasswordBasedEncryptor)e).getDelegate();
        }
        return e != IEntryStreamNormalizer.NULL;
    }

    public IEntryStreamNormalizer getEncryptor() {
        return this.encryptor;
    }

    protected void setEncryptor(IEntryStreamNormalizer encryptor) {
        this.encryptor = encryptor;
    }

    public void reset() {
        this.encryptor = new LazyPasswordBasedEncryptor(this.workbookRef);
    }

    private static IEntryStreamNormalizer createEncryptor(String password) {
        return password == null ? IEntryStreamNormalizer.NULL : new PasswordProtectedNormalizer(password);
    }

    private static class LazyPasswordBasedEncryptor
    implements IEntryStreamNormalizer {
        private final AbstractWorkbookRef workbookRef;
        private IEntryStreamNormalizer delegate;

        public LazyPasswordBasedEncryptor(AbstractWorkbookRef workbookRef) {
            this.workbookRef = workbookRef;
            this.delegate = IEntryStreamNormalizer.NULL;
        }

        public IEntryStreamNormalizer getDelegate() {
            return this.delegate;
        }

        public OutputStream normalizeOutputStream(OutputStream stream, IFileEntry fileEntry) throws IOException, CoreException {
            return this.delegate.normalizeOutputStream(stream, fileEntry);
        }

        public InputStream normalizeInputStream(InputStream stream, IFileEntry fileEntry) throws IOException, CoreException {
            IPasswordProvider passwordProvider;
            if (fileEntry.getEncryptionData() != null && this.delegate == IEntryStreamNormalizer.NULL && (passwordProvider = this.workbookRef.getService(IPasswordProvider.class)) != null) {
                String password = passwordProvider.askForPassword(this.workbookRef, null);
                if (password == null) {
                    throw new CoreException(100);
                }
                this.delegate = WorkbookRefEncryptable.createEncryptor(password);
            }
            return this.delegate.normalizeInputStream(stream, fileEntry);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof LazyPasswordBasedEncryptor)) {
                return false;
            }
            LazyPasswordBasedEncryptor that = (LazyPasswordBasedEncryptor)obj;
            return this.delegate.equals(that.delegate);
        }

        public int hashCode() {
            return 0x25 ^ this.delegate.hashCode();
        }
    }
}

