/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;

public class DecryptionDialog
extends TitleAreaDialog {
    private static final String GET_PASSWORD_HINT_COUNT = "ShowPasswordHintCount";
    private String workbookName;
    private String hintMessage;
    private int times;
    private Text passwordInputBox;
    private String password;

    public DecryptionDialog(Shell parent) {
        super(parent);
    }

    public DecryptionDialog(Shell parent, String workbookName, String hintMessage) {
        this(parent);
        this.workbookName = workbookName;
        this.hintMessage = hintMessage;
    }

    public DecryptionDialog(Shell parent, String workbookMessage, String hintMessage, int times) {
        this(parent, workbookMessage, hintMessage);
        this.times = times;
    }

    public void create() {
        super.create();
        this.setTitle(MindMapMessages.DecryptionDialog_title);
        this.setTitleImage(null);
        this.setMessage(MindMapMessages.DecryptionDialog_message);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 20;
        gridLayout.marginHeight = 20;
        gridLayout.verticalSpacing = 20;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.createContentArea(composite);
        this.checkOkButton();
        return composite;
    }

    private void createContentArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setBackground(parent.getBackground());
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = -1;
        gridData.heightHint = -1;
        area.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 5;
        gridLayout.horizontalSpacing = 3;
        area.setLayout((Layout)gridLayout);
        this.createFileNamePart(area);
        this.createPasswordPart(area);
        if ("".equals(this.hintMessage)) {
            this.hintMessage = null;
        }
        if (this.times > 0 && this.times < 4 || this.times >= 4 && this.hintMessage == null) {
            this.createErrorMessagePart(area);
        }
        if (this.times >= 4 && this.hintMessage != null) {
            this.createHintMessagePart(area);
        }
    }

    private void createFileNamePart(Composite area) {
        Label label = new Label(area, 0);
        label.setText(MindMapMessages.DecryptionDialog_FileName_label);
        label.setLayoutData((Object)new GridData(4096, 0x1000000, false, false));
        Label fileName = new Label(area, 0);
        fileName.setText(this.workbookName == null ? MindMapMessages.DecryptionDialog_FileName_untitled : this.workbookName);
    }

    private void createPasswordPart(Composite area) {
        Label label = new Label(area, 0);
        label.setText(MindMapMessages.DecryptionDialog_Password_label);
        label.setLayoutData((Object)new GridData(4096, 0x1000000, false, false));
        this.createPasswordInputBox(area);
    }

    private void createErrorMessagePart(Composite area) {
        new Label(area, 0);
        Label warningLabel = new Label(area, 0);
        warningLabel.setText(MindMapMessages.DecryptionDialog_WarningLabel_text);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = 320;
        gridData.heightHint = -1;
        warningLabel.setLayoutData((Object)gridData);
        warningLabel.setForeground(Display.getCurrent().getSystemColor(3));
    }

    private void createHintMessagePart(Composite parent) {
        new Label(parent, 0);
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        Label hintLabel = new Label(composite, 0);
        hintLabel.setText(MindMapMessages.DecryptionDialog_Hint_label);
        MindMapUIPlugin.getDefault().getUsageDataCollector().increase(GET_PASSWORD_HINT_COUNT);
        GridDataFactory.fillDefaults().align(1, 4).applyTo((Control)hintLabel);
        Label hintMessageLabel = new Label(composite, 64);
        hintMessageLabel.setText(this.hintMessage);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = 320;
        gridData.heightHint = -1;
        hintMessageLabel.setLayoutData((Object)gridData);
    }

    protected void createButtonsForButtonBar(Composite buttonBar) {
        this.createOkButton(buttonBar);
        this.createCloseButton(buttonBar);
    }

    private void createOkButton(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.setOkButtonEnabled(false);
    }

    private void createCloseButton(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private void createPasswordInputBox(Composite parent) {
        this.passwordInputBox = new Text(parent, 0x400804);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.minimumWidth = 320;
        gridData.widthHint = -1;
        gridData.heightHint = -1;
        this.passwordInputBox.setLayoutData((Object)gridData);
        this.hookText(this.passwordInputBox);
        Listener inputChangedListener = new Listener(){

            public void handleEvent(Event event) {
                DecryptionDialog.this.checkOkButton();
            }
        };
        this.passwordInputBox.addListener(24, inputChangedListener);
    }

    protected void okPressed() {
        this.password = this.passwordInputBox.getText();
        this.setReturnCode(0);
        this.close();
    }

    private void hookText(final Text text) {
        text.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                text.selectAll();
            }
        });
    }

    protected String getPassword() {
        return this.password;
    }

    private void checkOkButton() {
        this.setOkButtonEnabled(this.passwordInputBox != null && !"".equals(this.passwordInputBox.getText()));
    }

    private void setOkButtonEnabled(boolean enabled) {
        Button button = this.getButton(0);
        if (button != null && !button.isDisposed()) {
            button.setEnabled(enabled);
        }
    }
}

