/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorators;

import org.eclipse.draw2d.IFigure;
import org.xmind.gef.draw2d.decoration.ICorneredDecoration;
import org.xmind.gef.draw2d.decoration.IDecoration;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.part.Decorator;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.ui.branch.IBranchStructureExtension;
import org.xmind.ui.decorations.ISummaryDecoration;
import org.xmind.ui.internal.figures.SummaryFigure;
import org.xmind.ui.internal.mindmap.SummaryPart;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ISummaryPart;
import org.xmind.ui.style.StyleUtils;

public class SummaryDecorator
extends Decorator {
    private static final SummaryDecorator instance = new SummaryDecorator();

    public void deactivate(IGraphicalPart part, IFigure figure) {
        if (figure instanceof SummaryFigure) {
            SummaryFigure sf = (SummaryFigure)figure;
            sf.setSourceAnchor(null);
            sf.setTargetAnchor(null);
            sf.setConclusionAnchor(null);
        }
        super.deactivate(part, figure);
    }

    public void decorate(IGraphicalPart part, IFigure figure) {
        super.decorate(part, figure);
        IStyleSelector ss = StyleUtils.getStyleSelector(part);
        if (figure instanceof SummaryFigure) {
            this.decorateSummary(part, ss, (SummaryFigure)figure);
        }
    }

    private void decorateSummary(IGraphicalPart part, IStyleSelector ss, SummaryFigure figure) {
        String newDecId;
        ISummaryDecoration decoration = figure.getDecoration();
        if (!StyleUtils.isSameDecoration((IDecoration)decoration, newDecId = StyleUtils.getString(part, ss, "shape-class", "org.xmind.summaryShape.angle"))) {
            decoration = StyleUtils.createSummaryDecoration(part, newDecId);
            figure.setDecoration(decoration);
        }
        if (decoration != null) {
            String decorationId = decoration.getId();
            decoration.setAlpha((IFigure)figure, 255);
            decoration.setLineColor((IFigure)figure, StyleUtils.getColor(part, ss, "line-color", decorationId, "#808080"));
            decoration.setLineStyle((IFigure)figure, StyleUtils.getLineStyle(part, ss, decorationId, 1));
            decoration.setLineWidth((IFigure)figure, StyleUtils.getInteger(part, ss, "line-width", decorationId, 1));
            if (decoration instanceof ICorneredDecoration) {
                ((ICorneredDecoration)decoration).setCornerSize((IFigure)figure, StyleUtils.getInteger(part, ss, "shape-corner", decorationId, 10));
            }
            if (part instanceof SummaryPart) {
                ISummaryPart summary = (ISummaryPart)part;
                this.decorateAnchors(figure, decoration, summary);
            }
            decoration.setVisible((IFigure)figure, figure.isVisible());
        }
        figure.setVisible(this.isSummaryVisible(part));
    }

    private void decorateAnchors(SummaryFigure figure, ISummaryDecoration dec, ISummaryPart summary) {
        IStructure sa;
        figure.setSourceAnchor(summary.getSourceAnchor());
        figure.setTargetAnchor(summary.getTargetAnchor());
        figure.setConclusionAnchor(summary.getNodeAnchor());
        IBranchPart branch = summary.getOwnedBranch();
        if (branch != null && (sa = branch.getBranchPolicy().getStructure(branch)) instanceof IBranchStructureExtension) {
            int direction = ((IBranchStructureExtension)sa).getSummaryDirection(branch, summary);
            dec.setDirection((IFigure)figure, direction);
        }
    }

    private boolean isSummaryVisible(IGraphicalPart part) {
        if (part instanceof SummaryPart) {
            for (IBranchPart subBranch : ((ISummaryPart)part).getEnclosingBranches()) {
                if (!subBranch.getFigure().isShowing()) continue;
                return true;
            }
        }
        return false;
    }

    public static SummaryDecorator getInstance() {
        return instance;
    }
}

