/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorations;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.ui.decorations.AbstractTopicDecoration;

public class ParallelogramTopicDecoration
extends AbstractTopicDecoration {
    private static final float SCALE = 0.5f;

    protected void sketch(IFigure figure, Path shape, Rectangle box, int purpose) {
        if (purpose == 3) {
            float halfLineWidth = (float)this.getLineWidth() * 0.5f;
            shape.moveTo((float)box.x + (float)box.height * 0.5f - halfLineWidth, (float)box.y - halfLineWidth);
            shape.lineTo((float)box.x - halfLineWidth, (float)box.bottom() + halfLineWidth);
            shape.lineTo((float)box.right() - (float)box.height * 0.5f + halfLineWidth, (float)box.bottom() + halfLineWidth);
            shape.lineTo((float)box.right() + halfLineWidth, (float)box.y - halfLineWidth);
        } else {
            float scaledLineWidth = (float)this.getLineWidth() * 0.5f;
            shape.moveTo((float)box.x + (float)box.height * 0.5f, (float)box.y);
            shape.lineTo((float)box.x + scaledLineWidth, (float)box.bottom());
            shape.lineTo((float)box.right() - (float)box.height * 0.5f, (float)box.bottom());
            shape.lineTo((float)box.right() - scaledLineWidth, (float)box.y);
        }
        shape.close();
    }

    @Override
    public Insets getPreferredInsets(IFigure figure, int width, int height) {
        return new Insets(this.getTopMargin() + this.getLineWidth(), this.getLeftMargin() + this.getLineWidth() + Math.round((float)height * 0.5f) + 1, this.getBottomMargin() + this.getLineWidth(), this.getRightMargin() + this.getLineWidth() + Math.round((float)height * 0.5f) + 1);
    }

    public PrecisionPoint getAnchorLocation(IFigure figure, double refX, double refY, double expansion) {
        Rectangle r = this.getOutlineBox(figure);
        double cx = (float)r.x + 0.5f * (float)r.width;
        double cy = (float)r.y + 0.5f * (float)r.height;
        double dx = refX - cx;
        double dy = refY - cy;
        if (dx == 0.0) {
            return new PrecisionPoint(refX, dy > 0.0 ? (double)r.bottom() + expansion : (double)r.y - expansion);
        }
        if (dy == 0.0) {
            return new PrecisionPoint(dx > 0.0 ? (double)((float)r.right() - (float)r.height * 0.5f * 0.5f) + expansion : (double)((float)r.x + (float)r.height * 0.5f * 0.5f) - expansion, refY);
        }
        double scale = 0.5 / Math.max(Math.abs(dx) / (double)r.width, Math.abs(dy) / (double)r.height);
        dx *= scale;
        dx = Math.round(dx);
        dy *= scale;
        if (Math.abs(dy = (double)Math.round(dy)) < (double)(r.height / 2) || dy >= (double)(r.height / 2) && dx > (double)(r.width / 2 - r.height / 2) || dy <= (double)(-r.height / 2) && dx < (double)(-r.width / 2 + r.height / 2)) {
            dx = dx > 0.0 ? dx - ((double)((float)r.height * 0.5f) + dy) * 0.5 : dx + ((double)((float)r.height * 0.5f) - dy) * 0.5;
        }
        return new PrecisionPoint(cx += dx, cy += dy);
    }
}

