/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.comments;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.keys.IBindingService;
import org.xmind.core.IComment;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.ZoomManager;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.comments.CommentTextViewer;
import org.xmind.ui.internal.comments.CommentsPopupActionBarContributor;
import org.xmind.ui.internal.comments.CommentsSelectionProvider;
import org.xmind.ui.internal.comments.ICommentTextViewerContainer;
import org.xmind.ui.internal.comments.TopicCommentsViewer;
import org.xmind.ui.internal.e4models.CommentsPart;
import org.xmind.ui.internal.utils.E4Utils;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;

public class CommentsPopup
extends PopupDialog
implements ICoreEventListener,
ICommentTextViewerContainer {
    public static final Color BG_COLOR = ColorUtils.getColor((String)"#f5f5f5");
    private static final String CONTEXT_ID = "org.xmind.ui.context.commentsPopup";
    private static final String CMD_GOTO_COMMENTS_VIEW = "org.xmind.ui.command.gotoCommentsView";
    private static final String CMD_COMMIT_COMMENTS = "org.xmind.ui.command.commitComments";
    @Inject
    private EPartService partService;
    private IWorkbenchWindow window;
    private ITopicPart topicPart;
    private ITopic topic;
    private boolean showExtraActions;
    private Control control;
    private CommentsPopupActionBarContributor contributor;
    private ISelectionProvider selectionProvider = new CommentsSelectionProvider();
    private PopupKeyboardListener popupKeyBoardListener;
    private IBindingService bindingService;
    private IContextService contextService;
    private IContextActivation contextActivation;
    private Map<TriggerSequence, String> triggerableCommands = new HashMap<TriggerSequence, String>(3);
    private ScrolledComposite sc;
    private Composite contentComposite;
    private TopicCommentsViewer contentViewer;
    private ToolBarManager toolBarManager;
    private ICoreEventRegister eventRegister;
    private ICoreEventRegister globalEventRegister;
    private ControlListener controlListener;
    private IComment latestCreatedComment;
    private IComment selectedComment;
    private IComment editingComment;
    private boolean modified;

    public CommentsPopup(IWorkbenchWindow window, ITopicPart topicPart, boolean showExtraActions) {
        super(window.getShell(), 16, true, true, true, false, false, null, null);
        this.window = window;
        this.topicPart = topicPart;
        this.showExtraActions = showExtraActions;
        this.topic = topicPart.getTopic();
    }

    protected Point getDefaultSize() {
        return new Point(350, 250);
    }

    protected Color getBackground() {
        return BG_COLOR;
    }

    protected Point getInitialLocation(Point initialSize) {
        IViewer viewer = this.topicPart.getSite().getViewer();
        Rectangle bounds = this.topicPart.getFigure().getBounds().getCopy();
        return this.calcInitialLocation((IGraphicalViewer)viewer, bounds);
    }

    private Point calcInitialLocation(IGraphicalViewer viewer, Rectangle bounds) {
        ZoomManager zoom = viewer.getZoomManager();
        bounds = bounds.scale(zoom.getScale()).expand(1, 1).translate(viewer.getScrollPosition().getNegated());
        return viewer.getControl().toDisplay(bounds.x, bounds.y + bounds.height);
    }

    protected List getForegroundColorExclusions() {
        List list = super.getForegroundColorExclusions();
        this.collectColorExclusions(this.control, list);
        return list;
    }

    protected List getBackgroundColorExclusions() {
        List list = super.getBackgroundColorExclusions();
        this.collectColorExclusions(this.control, list);
        return list;
    }

    private void collectColorExclusions(Control control, List list) {
        list.add(control);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.collectColorExclusions(child, list);
                ++n2;
            }
        }
    }

    protected IDialogSettings getDialogSettings() {
        return MindMapUIPlugin.getDefault().getDialogSettings("org.xmind.ui.popupDialog");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.control = composite;
        composite.setBackground(this.getBackground());
        composite.setForeground(this.getForeground());
        this.contributor = new CommentsPopupActionBarContributor(this, this.getTargetEditor());
        Control control = this.createControl(composite);
        this.update();
        this.popupKeyBoardListener = new PopupKeyboardListener();
        this.popupKeyBoardListener.hook(control);
        this.setInfoText(null);
        this.hookTopic();
        this.registerGlobalEvent();
        this.initActions();
        return composite;
    }

    private IGraphicalEditor getTargetEditor() {
        IEditorPart editorPart;
        if (this.window != null && (editorPart = this.window.getActivePage().getActiveEditor()) instanceof IGraphicalEditor) {
            return (IGraphicalEditor)editorPart;
        }
        return null;
    }

    private void registerGlobalEvent() {
        this.globalEventRegister = new CoreEventRegister((ICoreEventSupport)this.topic.getOwnedWorkbook().getAdapter(ICoreEventSupport.class), (ICoreEventListener)this);
        this.globalEventRegister.register("commentContent");
    }

    private void unRegisterGlobalEvent() {
        if (this.globalEventRegister != null) {
            this.globalEventRegister.unregisterAll();
            this.globalEventRegister = null;
        }
    }

    private void hookTopic() {
        if (this.eventRegister == null) {
            this.eventRegister = new CoreEventRegister((Object)this.topic, (ICoreEventListener)this);
        }
        this.eventRegister.register("commentAdd");
        this.eventRegister.register("commentRemove");
    }

    private void unhookTopic() {
        if (this.eventRegister != null) {
            this.eventRegister.unregisterAll();
            this.eventRegister = null;
        }
    }

    public void handleCoreEvent(final CoreEvent event) {
        final String type = event.getType();
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!CommentsPopup.this.contentComposite.isDisposed()) {
                    if ("commentAdd".equals(type) || "commentRemove".equals(type)) {
                        CommentsPopup.this.update();
                    } else if ("commentContent".equals(type)) {
                        IComment comment = (IComment)event.getSource();
                        if (comment.isOrphan()) {
                            return;
                        }
                        if (comment.getOwnedWorkbook().getElementById(comment.getObjectId()) == CommentsPopup.this.topic) {
                            CommentsPopup.this.update();
                        }
                    }
                }
            }
        });
    }

    private void initActions() {
        this.contributor.selectionChanged(this.topic);
    }

    public boolean close() {
        Control control;
        Object object;
        MPart part;
        this.unhookTopic();
        this.unRegisterGlobalEvent();
        if (this.contextActivation != null && this.contextService != null) {
            this.contextService.deactivateContext(this.contextActivation);
            this.contextActivation = null;
        }
        if (this.contributor != null) {
            this.contributor.dispose();
        }
        if (this.sc != null && !this.sc.isDisposed()) {
            this.sc.removeControlListener(this.getControlListener());
        }
        if (this.getReturnCode() == 0) {
            this.saveComment();
        }
        if (this.partService != null && (part = this.partService.findPart("org.xmind.ui.modelPart.comment")).isVisible() && (object = part.getObject()) instanceof CommentsPart && (control = ((CommentsPart)object).getControl()) != null && !control.isDisposed()) {
            control.setData("commentsPopupShown", (Object)false);
        }
        return super.close();
    }

    private Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridData data = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.createToolbar(composite);
        this.contentComposite = this.createContentComposite(composite);
        return composite;
    }

    private void createToolbar(Composite parent) {
        if (this.contributor == null) {
            return;
        }
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(4, 128, true, false);
        gridData.heightHint = 30;
        composite.setLayoutData((Object)gridData);
        composite.setBackground(ColorUtils.getColor((String)"#e0e0e0"));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setBackground(label.getParent().getBackground());
        GridData layoutData = new GridData(16384, 0x1000000, false, true);
        layoutData.horizontalIndent = 10;
        label.setLayoutData((Object)layoutData);
        label.setText(MindMapMessages.Comments_lable);
        label.setFont(FontUtils.getBold((Font)FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)1)));
        this.toolBarManager = new ToolBarManager(0x800000);
        this.contributor.fillToolBar((IToolBarManager)this.toolBarManager);
        composite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                CommentsPopup.this.toolBarManager.update(true);
            }
        });
        ToolBar toolBar = this.toolBarManager.createControl(composite);
        toolBar.setBackground(toolBar.getParent().getBackground());
        toolBar.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
    }

    private Composite createContentComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.sc = new ScrolledComposite(composite, 512);
        this.sc.setBackground(parent.getBackground());
        this.sc.setLayoutData((Object)new GridData(4, 4, true, true));
        this.sc.setExpandHorizontal(true);
        Composite contentComposite = new Composite((Composite)this.sc, 0);
        contentComposite.setBackground(parent.getBackground());
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginBottom = 29;
        contentComposite.setLayout((Layout)gridLayout);
        this.sc.setContent((Control)contentComposite);
        this.sc.getVerticalBar().setIncrement(17);
        this.sc.addControlListener(this.getControlListener());
        return contentComposite;
    }

    private ControlListener getControlListener() {
        if (this.controlListener == null) {
            this.controlListener = new ControlListener(){

                public void controlMoved(ControlEvent e) {
                }

                public void controlResized(ControlEvent e) {
                    e.widget.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (CommentsPopup.this.contentComposite != null && !CommentsPopup.this.contentComposite.isDisposed()) {
                                CommentsPopup.this.contentComposite.pack();
                            }
                        }
                    });
                }
            };
        }
        return this.controlListener;
    }

    private void update() {
        this.resetSelectedComment();
        this.updateComments();
        this.setModified(false);
        this.setEditingComment(null);
    }

    private void resetSelectedComment() {
        this.contributor.selectedCommentChanged(null);
    }

    private void updateComments() {
        this.selectionProvider.setSelection(null);
        this.contentComposite.setRedraw(false);
        this.resetContent();
        this.contentViewer = new TopicCommentsViewer(this.topic, this.contributor, this.selectionProvider, this, false, this.getTargetEditor());
        this.contentViewer.create(this.contentComposite);
        this.contentComposite.pack();
        this.contentComposite.setRedraw(true);
    }

    private void resetContent() {
        Control[] controls = this.contentComposite.getChildren();
        if (controls != null) {
            Control[] controlArray = controls;
            int n = controls.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (control != null && !control.isDisposed()) {
                    control.dispose();
                    Object var2_5 = null;
                }
                ++n2;
            }
        }
    }

    public int open() {
        Control control;
        Object object;
        MPart part;
        int ret;
        IWorkbench workbench = this.window.getWorkbench();
        this.bindingService = (IBindingService)workbench.getAdapter(IBindingService.class);
        this.contextService = (IContextService)workbench.getAdapter(IContextService.class);
        if (this.bindingService != null) {
            this.registerWorkbenchCommands();
        }
        if ((ret = super.open()) == 0) {
            if (this.contextService != null) {
                this.contextActivation = this.contextService.activateContext(CONTEXT_ID);
            }
            if (this.bindingService != null) {
                this.registerDialogCommands();
            }
        }
        if (this.partService != null && (part = this.partService.findPart("org.xmind.ui.modelPart.comment")).isVisible() && (object = part.getObject()) instanceof CommentsPart && (control = ((CommentsPart)object).getControl()) != null && !control.isDisposed()) {
            control.setData("commentsPopupShown", (Object)true);
        }
        return ret;
    }

    private void registerWorkbenchCommands() {
        this.registerCommand("org.eclipse.ui.file.save");
        this.registerCommand("org.eclipse.ui.edit.undo");
        this.registerCommand("org.eclipse.ui.edit.redo");
        this.registerCommand("org.eclipse.ui.edit.cut");
        this.registerCommand("org.eclipse.ui.edit.copy");
        this.registerCommand("org.eclipse.ui.edit.paste");
        this.registerCommand("org.eclipse.ui.edit.selectAll");
    }

    private TriggerSequence registerCommand(String commandId) {
        if (this.bindingService == null) {
            return null;
        }
        TriggerSequence key = this.bindingService.getBestActiveBindingFor(commandId);
        if (key != null) {
            this.triggerableCommands.put(key, commandId);
        }
        return key;
    }

    protected Control getFocusControl() {
        return this.contentComposite;
    }

    private void registerDialogCommands() {
        if (this.showExtraActions) {
            this.registerCommand(CMD_GOTO_COMMENTS_VIEW);
        }
        this.registerCommand(CMD_COMMIT_COMMENTS);
        for (String commandId : this.contributor.getTextCommandIds()) {
            this.registerCommand(commandId);
        }
    }

    private void saveComment() {
        if (this.contentViewer != null) {
            this.contentViewer.save();
        }
    }

    private boolean handleCommand(String commandId) {
        if (CMD_GOTO_COMMENTS_VIEW.equals(commandId)) {
            if (this.showExtraActions) {
                this.gotoCommentsView();
            }
            return true;
        }
        if (CMD_COMMIT_COMMENTS.equals(commandId)) {
            this.saveComment();
            return true;
        }
        if ("org.eclipse.ui.file.save".equals(commandId)) {
            this.saveComment();
            return true;
        }
        IAction action = this.contributor.getActionHandler(commandId);
        if (action != null && action.isEnabled()) {
            if (action.getStyle() == 2) {
                action.setChecked(!action.isChecked());
            }
            action.run();
            return true;
        }
        return false;
    }

    public void gotoCommentsView() {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (CommentsPopup.this.window == null) {
                    return;
                }
                CommentsPopup.this.close();
                E4Utils.showPart("org.xmind.ui.command.showModelPart", CommentsPopup.this.window, "org.xmind.ui.modelPart.comments", null, "org.xmind.ui.stack.right");
            }
        });
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        return this.window;
    }

    public ITopic getTopic() {
        return this.topic;
    }

    public boolean isShowExtraActions() {
        return this.showExtraActions;
    }

    @Override
    public void moveToPreviousTextViewer(CommentTextViewer implementation) {
        List<CommentTextViewer> implementations = this.contentViewer.getImplementations();
        int index = implementations.indexOf(implementation);
        if (index <= 0 || index > implementations.size() - 1) {
            return;
        }
        this.setSelection((ISelection)new StructuredSelection((Object)implementations.get(index - 1)));
    }

    @Override
    public void moveToNextTextViewer(CommentTextViewer implementation) {
        List<CommentTextViewer> implementations = this.contentViewer.getImplementations();
        int index = implementations.indexOf(implementation);
        if (index < 0 || index >= implementations.size() - 1) {
            return;
        }
        this.setSelection((ISelection)new StructuredSelection((Object)implementations.get(index + 1)));
    }

    private void setSelection(ISelection selection) {
        this.selectionProvider.setSelection(selection);
    }

    @Override
    public Composite getContentComposite() {
        return this.contentComposite;
    }

    @Override
    public ScrolledComposite getScrolledComposite() {
        return this.sc;
    }

    @Override
    public void setLatestCreatedComment(IComment latestCreatedComment) {
        this.latestCreatedComment = latestCreatedComment;
    }

    @Override
    public IComment getLatestCreatedComment() {
        return this.latestCreatedComment;
    }

    @Override
    public void setSelectedComment(IComment selectedComment) {
        this.selectedComment = selectedComment;
    }

    @Override
    public IComment getSelectedComment() {
        return this.selectedComment;
    }

    @Override
    public void createComment(String objectId) {
        this.contentViewer.createNewComment();
    }

    @Override
    public void cancelCreateComment() {
        this.contentViewer.cancelCreateNewComment();
    }

    @Override
    public void setEditingComment(IComment editingComment) {
        this.editingComment = editingComment;
    }

    @Override
    public IComment getEditingComment() {
        return this.editingComment;
    }

    @Override
    public void setModified(boolean modified) {
        this.modified = modified;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    private class PopupKeyboardListener
    implements Listener {
        private List<TriggerSequence> currentSequences = null;
        private DisposeListener disposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!e.display.isDisposed()) {
                    e.display.removeFilter(1, (Listener)PopupKeyboardListener.this);
                }
            }
        };
        private int nextKeyIndex = -1;

        private PopupKeyboardListener() {
        }

        public void hook(Control control) {
            control.getDisplay().addFilter(1, (Listener)this);
            control.getShell().addDisposeListener(this.disposeListener);
        }

        public void handleEvent(Event event) {
            if (event.type == 1) {
                this.handleKeyDown(event);
            }
        }

        private void handleKeyDown(Event event) {
            if (CommentsPopup.this.triggerableCommands.isEmpty()) {
                return;
            }
            List<KeyStroke> keys = this.generateKeyStrokes(event);
            if (this.currentSequences == null) {
                this.nextKeyIndex = -1;
                for (TriggerSequence ts : CommentsPopup.this.triggerableCommands.keySet()) {
                    if (!this.matches(keys, ts.getTriggers()[0])) continue;
                    if (this.currentSequences == null) {
                        this.currentSequences = new ArrayList<TriggerSequence>(CommentsPopup.this.triggerableCommands.size());
                    }
                    this.currentSequences.add(ts);
                }
                if (this.currentSequences == null) {
                    return;
                }
            }
            if (this.nextKeyIndex < 0) {
                this.nextKeyIndex = 0;
            }
            Iterator<TriggerSequence> it = this.currentSequences.iterator();
            while (it.hasNext()) {
                TriggerSequence ts = it.next();
                Trigger[] triggers = ts.getTriggers();
                if (this.nextKeyIndex >= triggers.length) {
                    it.remove();
                    continue;
                }
                if (this.matches(keys, triggers[this.nextKeyIndex])) {
                    if (this.nextKeyIndex != triggers.length - 1) continue;
                    if (this.triggerFound(ts)) {
                        event.doit = false;
                    }
                    return;
                }
                it.remove();
            }
            if (this.currentSequences != null && this.currentSequences.isEmpty()) {
                ++this.nextKeyIndex;
            } else {
                this.currentSequences = null;
                this.nextKeyIndex = -1;
            }
        }

        private boolean triggerFound(TriggerSequence triggerSequence) {
            this.currentSequences = null;
            this.nextKeyIndex = -1;
            String commandId = (String)CommentsPopup.this.triggerableCommands.get(triggerSequence);
            if (commandId != null) {
                return CommentsPopup.this.handleCommand(commandId);
            }
            return false;
        }

        private boolean matches(List<KeyStroke> keys, Trigger expected) {
            for (KeyStroke key : keys) {
                if (!key.equals((Object)expected)) continue;
                return true;
            }
            return false;
        }

        private List<KeyStroke> generateKeyStrokes(Event event) {
            int thirdAccelerator;
            ArrayList<KeyStroke> keyStrokes = new ArrayList<KeyStroke>(3);
            if (event.stateMask == 0 && event.keyCode == 0 && event.character == '\u0000') {
                return keyStrokes;
            }
            int firstAccelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((Event)event);
            keyStrokes.add(SWTKeySupport.convertAcceleratorToKeyStroke((int)firstAccelerator));
            if (event.character == '\u007f') {
                return keyStrokes;
            }
            int secondAccelerator = SWTKeySupport.convertEventToUnshiftedModifiedAccelerator((Event)event);
            if (secondAccelerator != firstAccelerator) {
                keyStrokes.add(SWTKeySupport.convertAcceleratorToKeyStroke((int)secondAccelerator));
            }
            if ((thirdAccelerator = SWTKeySupport.convertEventToModifiedAccelerator((Event)event)) != secondAccelerator && thirdAccelerator != firstAccelerator) {
                keyStrokes.add(SWTKeySupport.convertAcceleratorToKeyStroke((int)thirdAccelerator));
            }
            return keyStrokes;
        }
    }
}

