/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.branch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.xmind.ui.branch.IBranchStyleValueProvider;
import org.xmind.ui.internal.branch.BranchPolicyManager;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.util.Logger;

public class OverridedStyle {
    private BranchPolicyManager manager;
    private IConfigurationElement element;
    private String key;
    private String value;
    private List<String> layers;
    private IBranchStyleValueProvider valueProvider;
    private boolean triedLoadingValueProvider;
    private Expression condition;

    public OverridedStyle(BranchPolicyManager manager, IConfigurationElement element) throws CoreException {
        this.manager = manager;
        this.element = element;
        this.key = element.getAttribute("key");
        if (this.key == null) {
            throw new CoreException((IStatus)new Status(4, element.getNamespaceIdentifier(), 0, "Invalid extension (missing style key)", null));
        }
        this.value = element.getAttribute("value");
        this.initializeLayers();
        this.initializeEnablement();
    }

    private void initializeLayers() {
        IConfigurationElement[] children = this.element.getChildren("layer");
        if (children.length > 0) {
            IConfigurationElement[] iConfigurationElementArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement child = iConfigurationElementArray[n2];
                String layerName = child.getAttribute("name");
                if (layerName != null) {
                    if (this.layers == null) {
                        this.layers = new ArrayList<String>();
                    }
                    this.layers.add(layerName);
                }
                ++n2;
            }
        }
        if (this.layers == null) {
            this.layers = Collections.emptyList();
        }
    }

    private void initializeEnablement() {
        IConfigurationElement[] children = this.element.getChildren("enablement");
        if (children.length == 0) {
            return;
        }
        try {
            this.condition = ExpressionConverter.getDefault().perform(children[0]);
        }
        catch (CoreException e) {
            Logger.log(e, "Failed to convert expression: " + children[0]);
        }
    }

    public List<String> getLayers() {
        return this.layers;
    }

    public String getKey() {
        return this.key;
    }

    public String getDefaultValue() {
        return this.value;
    }

    public boolean isOnLayer(String layerName) {
        if (this.layers.isEmpty()) {
            return "beforeDefaultValue".equals(layerName);
        }
        return this.layers.contains(layerName);
    }

    public boolean isApplicableTo(IBranchPart branch) {
        if (this.condition == null) {
            return true;
        }
        return this.isApplicableTo(BranchPolicyManager.createBranchEvaluationContext(branch));
    }

    boolean isApplicableTo(IEvaluationContext context) {
        if (this.condition == null) {
            return true;
        }
        try {
            EvaluationResult result = this.condition.evaluate(context);
            return result == EvaluationResult.TRUE;
        }
        catch (CoreException e) {
            Logger.log(e, "Evaluation failed: " + context);
            return false;
        }
    }

    public String getValue(IBranchPart branch, String layerName) {
        IBranchStyleValueProvider valueProvider = this.getValueProvider();
        if (valueProvider != null) {
            return valueProvider.getValue(branch, layerName, this.key);
        }
        return this.getDefaultValue();
    }

    private IBranchStyleValueProvider getValueProvider() {
        if (this.valueProvider == null && !this.triedLoadingValueProvider) {
            String valueProviderId = this.element.getAttribute("valueProviderId");
            if (valueProviderId != null) {
                this.valueProvider = this.manager.getValueProvider(valueProviderId);
            }
            this.triedLoadingValueProvider = true;
        }
        return this.valueProvider;
    }
}

