/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.actions;

import java.util.ArrayList;
import java.util.List;
import org.xmind.core.ISheet;
import org.xmind.core.IWorkbook;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.ui.actions.EditorAction;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.actions.MindMapActionFactory;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.DeleteSheetCommand;

public class DeleteOtherSheetsAction
extends EditorAction {
    public DeleteOtherSheetsAction(IGraphicalEditor editor) {
        super(MindMapActionFactory.DELETE_OTHER_SHEET.getId(), editor);
    }

    public void run() {
        Object input;
        if (this.isDisposed()) {
            return;
        }
        IGraphicalEditorPage page = this.getActivePage();
        if (page == null) {
            return;
        }
        ISheet activeSheet = (ISheet)page.getAdapter(ISheet.class);
        if (activeSheet == null && (input = page.getInput()) instanceof ISheet) {
            activeSheet = (ISheet)input;
        }
        if (activeSheet != null) {
            IWorkbook workbook = activeSheet.getOwnedWorkbook();
            List sheets = workbook.getSheets();
            ArrayList<DeleteSheetCommand> commands = new ArrayList<DeleteSheetCommand>(sheets.size() - 1);
            for (ISheet sheet : sheets) {
                if (activeSheet.equals(sheet)) continue;
                commands.add(new DeleteSheetCommand(sheet));
            }
            this.saveAndRun((Command)new CompoundCommand(CommandMessages.Command_DeleteSheet, commands));
        }
    }
}

