/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.actions;

import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.xmind.core.ISheet;
import org.xmind.core.IWorkbook;
import org.xmind.core.style.IStyle;
import org.xmind.gef.command.Command;
import org.xmind.gef.ui.actions.EditorAction;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.actions.MindMapActionFactory;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.CreateSheetCommand;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.editor.WorkbookEditorInput;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.style.StyleUtils;

public class CreateSheetAction
extends EditorAction {
    private static final String CREATE_SHEET_COUNT = "CreateSheetCount";
    private IGraphicalEditor editor;

    public CreateSheetAction(IGraphicalEditor editor) {
        super(MindMapActionFactory.NEW_SHEET.getId(), editor);
    }

    public void run() {
        if (this.isDisposed()) {
            return;
        }
        this.editor = this.getEditor();
        if (this.editor != null) {
            IWorkbook workbook = (IWorkbook)this.editor.getAdapter(IWorkbook.class);
            if (workbook == null) {
                IEditorInput input = this.editor.getEditorInput();
                if (input instanceof WorkbookEditorInput) {
                    workbook = ((WorkbookEditorInput)input).getContents();
                } else if (input != null) {
                    workbook = (IWorkbook)input.getAdapter(IWorkbook.class);
                }
            }
            if (workbook == null) {
                return;
            }
            this.saveAndRunCreateSheetCommand(workbook);
        }
    }

    protected void saveAndRunCreateSheetCommand(IWorkbook workbook) {
        CreateSheetCommand command = new CreateSheetCommand(workbook, null);
        command.setLabel(CommandMessages.Command_CreateSheet);
        this.saveAndRun((Command)command);
        ISheet sheet = (ISheet)command.getSource();
        if (sheet != null) {
            this.decorateCreatedSheet(sheet);
        }
    }

    protected void decorateCreatedSheet(ISheet sheet) {
        MindMapUIPlugin.getDefault().getUsageDataCollector().increase(CREATE_SHEET_COUNT);
        sheet.setTitleText(NLS.bind((String)MindMapMessages.TitleText_Sheet, (Object)sheet.getParent().getSheets().size()));
        sheet.getRootTopic().setTitleText(MindMapMessages.TitleText_CentralTopic);
        sheet.getRootTopic().setStructureClass("org.xmind.ui.map.unbalanced");
        IStyle theme = MindMapUI.getResourceManager().getDefaultTheme();
        StyleUtils.setTheme(sheet, theme);
    }
}

