/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.xmind.gef.dnd.DndData;
import org.xmind.gef.dnd.IDndClient;
import org.xmind.gef.dnd.IDndSupport;
import org.xmind.ui.internal.DndClientDescriptor;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.util.Logger;

public class MindMapDndSupport
extends RegistryReader
implements IDndSupport {
    private List<String> ids = null;
    private Map<String, DndClientDescriptor> map = null;
    private Transfer[] transfers = null;

    MindMapDndSupport() {
    }

    public DndData parseData(TransferData[] dataTypes, Object source, boolean usePendingData) {
        List<String> clientIds = this.getClientIds();
        TransferData[] transferDataArray = dataTypes;
        int n = dataTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TransferData dataType = transferDataArray[n2];
            for (String clientId : clientIds) {
                Transfer transfer;
                IDndClient client = this.getDndClient(clientId);
                if (client == null || (transfer = client.getTransfer()) == null || !transfer.isSupportedType(dataType)) continue;
                Object data = this.parseData(client, transfer, dataType, source);
                if (data == null && usePendingData) {
                    data = PENDING_DATA;
                }
                if (data == null) continue;
                return new DndData(clientId, data, dataType);
            }
            ++n2;
        }
        return null;
    }

    private Object parseData(IDndClient dndClient, Transfer transfer, TransferData transferData, Object source) {
        if (source instanceof Clipboard) {
            return ((Clipboard)source).getContents(transfer);
        }
        return dndClient.getData(transfer, transferData);
    }

    public IDndClient getDndClient(String id) {
        DndClientDescriptor desc = this.getDescriptor(id);
        if (desc != null) {
            return desc.getDndClient();
        }
        return null;
    }

    public DndClientDescriptor getDescriptor(String id) {
        return this.getRegistry().get(id);
    }

    public String[] getDndClientIds() {
        return this.getClientIds().toArray(new String[0]);
    }

    private List<String> getClientIds() {
        this.ensureLoaded();
        return this.ids;
    }

    private Map<String, DndClientDescriptor> getRegistry() {
        this.ensureLoaded();
        return this.map;
    }

    public int getStyle() {
        return 21;
    }

    public Transfer[] getTransfers() {
        if (this.transfers == null) {
            List<String> ids = this.getClientIds();
            ArrayList<Transfer> ts = new ArrayList<Transfer>(ids.size());
            for (String id : ids) {
                Transfer t;
                IDndClient dndClient = this.getDndClient(id);
                if (dndClient == null || (t = dndClient.getTransfer()) == null) continue;
                ts.add(t);
            }
            this.transfers = ts.toArray(new Transfer[ts.size()]);
        }
        return this.transfers;
    }

    private void ensureLoaded() {
        if (this.ids != null && this.map != null) {
            return;
        }
        if (Platform.isRunning()) {
            this.readRegistry(Platform.getExtensionRegistry(), "org.xmind.ui", "dndClients");
        }
        if (this.ids == null) {
            this.ids = Collections.emptyList();
        } else {
            this.sortIds();
        }
        if (this.map == null) {
            this.map = Collections.emptyMap();
        }
    }

    private void registerDndClient(DndClientDescriptor descriptor) {
        String id = descriptor.getId();
        if (this.ids == null) {
            this.ids = new ArrayList<String>();
        }
        this.ids.add(id);
        if (this.map == null) {
            this.map = new HashMap<String, DndClientDescriptor>();
        }
        this.map.put(id, descriptor);
    }

    private void sortIds() {
        IPreferenceStore ps;
        String order;
        MindMapUIPlugin plugin = MindMapUIPlugin.getDefault();
        if (plugin != null && (order = (ps = plugin.getPreferenceStore()).getString("dndClientIdOrder")) != null && !"".equals(order)) {
            boolean hasDefault = this.ids.contains("org.xmind.ui.dnd.mindMapElement");
            if (hasDefault) {
                this.ids.remove("org.xmind.ui.dnd.mindMapElement");
            }
            ArrayList<String> notOrdered = new ArrayList<String>(this.ids.size());
            int i = 0;
            while (i < this.ids.size()) {
                String id = this.ids.get(i);
                if (order.contains(id)) {
                    ++i;
                    continue;
                }
                this.ids.remove(i);
                notOrdered.add(id);
            }
            if (this.ids.size() > 1) {
                Collections.sort(this.ids, new Comparator<String>(){

                    @Override
                    public int compare(String id1, String id2) {
                        int index1 = order.indexOf(id1);
                        int index2 = order.indexOf(id2);
                        return index1 - index2;
                    }
                });
            }
            for (String id : notOrdered) {
                this.ids.add(id);
            }
            if (hasDefault) {
                this.ids.add(0, "org.xmind.ui.dnd.mindMapElement");
            }
        }
    }

    protected boolean readElement(IConfigurationElement element) {
        if ("dndClient".equals(element.getName())) {
            this.readDndClient(element);
            return true;
        }
        return false;
    }

    private void readDndClient(IConfigurationElement element) {
        try {
            DndClientDescriptor desc = new DndClientDescriptor(element);
            this.registerDndClient(desc);
        }
        catch (CoreException e) {
            Logger.log(e, "Unable to load dnd client: " + element.toString());
        }
    }
}

