/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.editor;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.xmind.ui.editor.IEditorHistoryItem;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.protocols.FilePathParser;

public class EditorHistoryItem
implements IEditorHistoryItem {
    public static final String KEY_NAME = "name";
    public static final String KEY_OPENED_TIME = "openedTime";
    private static final String defaultName = MindMapMessages.EditorHistoryItem_defaultName;
    private String name;
    private long openedTime;

    public EditorHistoryItem(String name, long openedTime) {
        this.name = name == null || name.trim().equals("") ? defaultName : name;
        this.openedTime = openedTime;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getOpenedTime() {
        return this.openedTime;
    }

    @Override
    public String toJson() {
        JSONObject json = new JSONObject();
        json.put(KEY_NAME, (Object)this.name);
        json.put(KEY_OPENED_TIME, this.openedTime);
        return json.toString();
    }

    public static IEditorHistoryItem readEditorHistoryItem(String uriString, String json) {
        if (json == null || json.trim().equals("")) {
            if (uriString == null || uriString.trim().equals("")) {
                return new EditorHistoryItem(defaultName, System.currentTimeMillis());
            }
            try {
                URI uri = new URI(uriString);
                HashMap<URI, String> labels = new HashMap<URI, String>();
                FilePathParser.calculateFileURILabels(new URI[]{uri}, labels);
                return new EditorHistoryItem((String)labels.get(uri), System.currentTimeMillis());
            }
            catch (URISyntaxException e) {
                MindMapUIPlugin.log(e, "EditorHistoryItem parase uri to file name occur Some error.");
                return null;
            }
        }
        try {
            JSONObject itemJson = new JSONObject(new JSONTokener(json));
            String jName = itemJson.getString(KEY_NAME);
            long jTime = itemJson.getLong(KEY_OPENED_TIME);
            EditorHistoryItem item = new EditorHistoryItem(jName, jTime);
            return item;
        }
        catch (JSONException e) {
            MindMapUIPlugin.log(e, "Read Json of EditorHistoryItem occur Some error.");
            return new EditorHistoryItem(defaultName, System.currentTimeMillis());
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof EditorHistoryItem)) {
            return false;
        }
        EditorHistoryItem that = (EditorHistoryItem)obj;
        return this.name == that.name && this.openedTime == that.openedTime;
    }

    public String toString() {
        this.name = this.name == null ? " " : this.name;
        return "EditorHistoryItem : (" + this.name + "," + Calendar.getInstance().getTime() + ")";
    }
}

