/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.branch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.ReferencedLayoutData;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.ui.branch.IBranchStructureExtension;
import org.xmind.ui.internal.figures.BoundaryFigure;
import org.xmind.ui.mindmap.IBoundaryPart;
import org.xmind.ui.mindmap.IBranchPart;

public class BoundaryLayoutHelper {
    private Map<IBoundaryPart, BoundaryData> boundaries = new HashMap<IBoundaryPart, BoundaryData>();
    private Map<IBranchPart, SubBranchData> subBranches = new HashMap<IBranchPart, SubBranchData>();
    private BoundaryData overallBoundary = null;

    public void reset(IBranchPart branch, IBranchStructureExtension algorithm, Map<IFigure, Rectangle> prefBounds) {
        this.boundaries.clear();
        this.subBranches.clear();
        for (IBoundaryPart boundary : branch.getBoundaries()) {
            BoundaryData boundaryData = new BoundaryData(boundary, algorithm.getRangeGrowthDirection(branch, boundary), prefBounds == null ? null : prefBounds.get(boundary.getFigure()));
            this.boundaries.put(boundary, boundaryData);
            if (!boundaryData.isOverall() || this.getOverallBoundary() != null) continue;
            this.setOverallBoundary(boundaryData);
        }
        if (!this.isEmpty()) {
            Object[] allBoundaries = this.boundaries.values().toArray(new BoundaryData[0]);
            Arrays.sort(allBoundaries);
            for (IBranchPart subBranch : branch.getSubBranches()) {
                SubBranchData data = new SubBranchData(subBranch, (BoundaryData[])allBoundaries);
                if (data.isEmpty()) continue;
                this.subBranches.put(subBranch, data);
            }
        }
        for (IBoundaryPart b : branch.getBoundaries()) {
            BoundaryData boundary = this.getBoundaryData(b);
            for (IBranchPart s : boundary.subBranches) {
                SubBranchData subBranch = this.getSubBranchData(s);
                boundary.setSubBranchInsets(subBranch.subBranch, this.createSubBranchInsets(boundary, subBranch));
            }
        }
    }

    public BoundaryData getOverallBoundary() {
        return this.overallBoundary;
    }

    protected Insets createSubBranchInsets(BoundaryData boundary, SubBranchData subBranch) {
        Insets ins = boundary.createInsets();
        switch (boundary.getDirection()) {
            case 16: {
                if (!boundary.isFirst(subBranch)) {
                    ins.left = 0;
                }
                if (boundary.isLast(subBranch)) break;
                ins.right = 0;
                break;
            }
            case 8: {
                if (!boundary.isFirst(subBranch)) {
                    ins.right = 0;
                }
                if (boundary.isLast(subBranch)) break;
                ins.left = 0;
                break;
            }
            case 4: {
                if (!boundary.isFirst(subBranch)) {
                    ins.top = 0;
                }
                if (boundary.isLast(subBranch)) break;
                ins.bottom = 0;
                break;
            }
            case 1: {
                if (!boundary.isFirst(subBranch)) {
                    ins.bottom = 0;
                }
                if (boundary.isLast(subBranch)) break;
                ins.top = 0;
            }
        }
        return ins;
    }

    public boolean isEmpty() {
        return this.boundaries.isEmpty();
    }

    public boolean hasSubBranch(IBranchPart subBranch) {
        return this.subBranches.containsKey(subBranch);
    }

    public SubBranchData getSubBranchData(IBranchPart subBranch) {
        return this.subBranches.get(subBranch);
    }

    public BoundaryData getBoundaryData(IBoundaryPart boundary) {
        return this.boundaries.get(boundary);
    }

    public Insets getInsets(IBranchPart subBranch) {
        SubBranchData data = this.getSubBranchData(subBranch);
        return data != null ? data.getInsets() : IFigure.NO_INSETS;
    }

    public Rectangle getBorderedBounds(IBranchPart subBranch, ReferencedLayoutData data) {
        Rectangle r = data.get((Object)subBranch.getFigure());
        if (r != null) {
            r = r.getExpanded(this.getInsets(subBranch));
        }
        return r;
    }

    public Dimension getBorderedSize(IBranchPart subBranch) {
        return this.getBorderedSize(subBranch, -1, -1);
    }

    public Dimension getBorderedSize(IBranchPart subBranch, int wHint, int hHint) {
        Dimension s = subBranch.getFigure().getPreferredSize(wHint, hHint);
        Insets ins = this.getInsets(subBranch);
        s = new Dimension(s.width + ins.getWidth(), s.height + ins.getHeight());
        return s;
    }

    public Insets getInnerInsets(SubBranchData subBranch, BoundaryData boundary) {
        return subBranch.calcInnerInsets(boundary);
    }

    public void setOverallBoundary(BoundaryData overallBoundary) {
        this.overallBoundary = overallBoundary;
    }

    public static class BoundaryData
    implements Comparable<BoundaryData> {
        public IBoundaryPart boundary;
        public IFigure boundaryFigure;
        private Insets prefInsets;
        private List<IBranchPart> subBranches;
        private Map<IBranchPart, Insets> branchBorders = new HashMap<IBranchPart, Insets>();
        private int startIndex = -1;
        private int endIndex = -1;
        private int direction;
        private boolean overall;

        public BoundaryData(IBoundaryPart boundary, int direction, Rectangle prefBoundaryBounds) {
            this.boundary = boundary;
            this.boundaryFigure = boundary.getFigure();
            this.prefInsets = this.boundaryFigure.getInsets();
            if (prefBoundaryBounds != null && ((BoundaryFigure)boundary.getFigure()).isTitleVisible() && boundary.getTitle() != null && boundary.getTitle().getFigure() != null) {
                Dimension s = boundary.getTitle().getFigure().getPreferredSize(prefBoundaryBounds.width, -1);
                this.prefInsets = new Insets(this.prefInsets);
                this.prefInsets.top = Math.max(s.height, this.prefInsets.top);
                this.prefInsets.left += 5;
            }
            this.subBranches = boundary.getEnclosingBranches();
            this.direction = direction;
            this.overall = boundary.getBoundary().isMasterBoundary();
        }

        public boolean isOverall() {
            return this.overall;
        }

        public int getDirection() {
            return this.direction;
        }

        public Insets createInsets() {
            return new Insets(this.prefInsets);
        }

        public Rectangle expanded(Rectangle rect) {
            return rect.expand(this.prefInsets);
        }

        public List<IBranchPart> getSubBranches() {
            return this.subBranches;
        }

        public void setSubBranchInsets(IBranchPart subBranch, Insets ins) {
            this.branchBorders.put(subBranch, ins);
        }

        public Insets getSubBranchInsets(IBranchPart subBranch) {
            return this.branchBorders.get(subBranch);
        }

        public boolean isEmpty() {
            return this.subBranches.isEmpty();
        }

        public IBranchPart getFirst() {
            return this.isEmpty() ? null : this.subBranches.get(0);
        }

        public IBranchPart getLast() {
            return this.isEmpty() ? null : this.subBranches.get(this.subBranches.size() - 1);
        }

        public boolean isFirst(SubBranchData subBranch) {
            return this.isFirst(subBranch.subBranch);
        }

        public boolean isLast(SubBranchData subBranch) {
            return this.isLast(subBranch.subBranch);
        }

        public boolean isFirst(IBranchPart subBranch) {
            return subBranch == this.getFirst();
        }

        public boolean isLast(IBranchPart subBranch) {
            return subBranch == this.getLast();
        }

        public boolean contains(BoundaryData another) {
            return this.subBranches.containsAll(another.subBranches);
        }

        public boolean contains(IBranchPart subBranch) {
            return this.subBranches.contains(subBranch);
        }

        public boolean contains(SubBranchData subBranch) {
            return this.contains(subBranch.subBranch);
        }

        public int getStartIndex() {
            if (this.startIndex < 0 && !this.isEmpty()) {
                this.startIndex = this.getFirst().getBranchIndex();
            }
            return this.startIndex;
        }

        public int getEndIndex() {
            if (this.endIndex < 0 && !this.isEmpty()) {
                this.endIndex = this.getLast().getBranchIndex();
            }
            return this.endIndex;
        }

        @Override
        public int compareTo(BoundaryData that) {
            if (this.isOverall()) {
                return 100;
            }
            if (that.isOverall()) {
                return -100;
            }
            if (this.contains(that)) {
                return 10;
            }
            if (that.contains(this)) {
                return -10;
            }
            if (this.isEmpty()) {
                return -100;
            }
            if (that.isEmpty()) {
                return 100;
            }
            return this.getStartIndex() - that.getStartIndex();
        }
    }

    public static interface ISubBranchInsetsCalculator {
        public void calculateSubBranchInsets(BoundaryData var1, SubBranchData var2, Insets var3);
    }

    public static class SubBranchData {
        public IBranchPart subBranch;
        public List<BoundaryData> boundaries = new ArrayList<BoundaryData>();
        private Insets insets = null;

        public SubBranchData(IBranchPart subBranch, BoundaryData[] allBoundaries) {
            this.subBranch = subBranch;
            BoundaryData[] boundaryDataArray = allBoundaries;
            int n = allBoundaries.length;
            int n2 = 0;
            while (n2 < n) {
                BoundaryData b = boundaryDataArray[n2];
                if (b.contains(subBranch)) {
                    this.boundaries.add(b);
                }
                ++n2;
            }
        }

        public boolean isEmpty() {
            return this.boundaries.isEmpty();
        }

        public Insets getInsets() {
            if (this.insets == null) {
                this.insets = this.calcInnerInsets(null);
            }
            return this.insets;
        }

        public Insets calcInnerInsets(BoundaryData boundary) {
            Insets insets = null;
            BoundaryData last = null;
            Insets lastLevelIns = null;
            for (BoundaryData b : this.boundaries) {
                if (last != null && boundary != null && !boundary.contains(last)) {
                    lastLevelIns = null;
                    break;
                }
                if (b == boundary) break;
                if (last != null && b.contains(last)) {
                    insets = Geometry.add((Insets)insets, lastLevelIns);
                    lastLevelIns = null;
                }
                last = b;
                Insets ins = b.getSubBranchInsets(this.subBranch);
                lastLevelIns = Geometry.union(lastLevelIns, (Insets)ins);
            }
            if (lastLevelIns != null) {
                insets = Geometry.add(insets, lastLevelIns);
            }
            return insets == null ? IFigure.NO_INSETS : insets;
        }
    }
}

