/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.branch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.core.util.Point;
import org.xmind.gef.draw2d.IDecoratedFigure;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.draw2d.IRotatableFigure;
import org.xmind.gef.draw2d.ReferencedLayoutData;
import org.xmind.gef.draw2d.decoration.IDecoration;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.draw2d.geometry.PrecisionDimension;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;
import org.xmind.gef.draw2d.geometry.PrecisionRotator;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.BoundaryLayoutHelper;
import org.xmind.ui.branch.IBranchStructure;
import org.xmind.ui.branch.IBranchStructureExtension;
import org.xmind.ui.branch.IInsertableBranchStructureExtension;
import org.xmind.ui.branch.IInsertion;
import org.xmind.ui.branch.INavigableBranchStructureExtension;
import org.xmind.ui.decorations.IBranchConnectionDecoration;
import org.xmind.ui.decorations.IBranchConnections2;
import org.xmind.ui.decorations.ISummaryDecoration;
import org.xmind.ui.decorations.ITopicDecoration;
import org.xmind.ui.internal.figures.BoundaryFigure;
import org.xmind.ui.internal.figures.BranchFigure;
import org.xmind.ui.internal.figures.TopicFigure;
import org.xmind.ui.mindmap.IBoundaryPart;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IBranchRangePart;
import org.xmind.ui.mindmap.IInfoPart;
import org.xmind.ui.mindmap.ILabelPart;
import org.xmind.ui.mindmap.INodePart;
import org.xmind.ui.mindmap.IPlusMinusPart;
import org.xmind.ui.mindmap.ISummaryPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.style.StyleUtils;
import org.xmind.ui.tools.ParentSearchKey;
import org.xmind.ui.util.MindMapUtils;

public abstract class AbstractBranchStructure
implements IBranchStructure,
IBranchStructureExtension,
INavigableBranchStructureExtension,
IInsertableBranchStructureExtension {
    protected static final String CACHE_STRUCTURE_DATA = "org.xmind.ui.branchCache.structureData";
    protected static final String CACHE_BOUNDARY_LAYOUT_HELPER = "org.xmind.ui.branchCache.boundaryLayoutHelper";

    @Override
    public void fillLayoutData(IBranchPart branch, ReferencedLayoutData data) {
        BranchFigure figure = (BranchFigure)branch.getFigure();
        boolean folded = figure.isFolded();
        boolean minimized = figure.isMinimized();
        LayoutInfo info = new LayoutInfo(data, folded, minimized);
        this.fillLayoutInfo(branch, info);
    }

    protected void fillLayoutInfo(IBranchPart branch, LayoutInfo info) {
        String hideCallout;
        IStyleSelector styleSelector = branch.getBranchPolicy().getStyleSelector(branch);
        if (styleSelector != null && Boolean.parseBoolean(hideCallout = styleSelector.getStyleValue((IGraphicalPart)branch, "hide-callout")) && "calloutBranch".equals(branch.getBranchType())) {
            branch.getFigure().setVisible(false);
            return;
        }
        this.fillTopic(branch, info);
        this.fillPlusMinus(branch, info);
        this.fillLabel(branch, info);
        this.fillInformation(branch, info);
        List<IBranchPart> subBranches = branch.getSubBranches();
        List<IBoundaryPart> boundaries = branch.getBoundaries();
        BoundaryLayoutHelper boundaryLayoutHelper = this.getBoundaryLayoutHelper(branch);
        info.hasBoundaryTitles = false;
        ReferencedLayoutData fakeDelegate = info.delegate.copy();
        ReferencedLayoutData realDelegate = info.delegate;
        info.delegate = fakeDelegate;
        this.fillSubBranches(branch, subBranches, info);
        this.fillBoundaries(branch, boundaries, subBranches, info);
        info.delegate = realDelegate;
        if (info.hasBoundaryTitles) {
            HashMap<IFigure, Rectangle> cachedBounds = new HashMap<IFigure, Rectangle>();
            for (IBoundaryPart iBoundaryPart : branch.getBoundaries()) {
                cachedBounds.put(iBoundaryPart.getFigure(), fakeDelegate.get((Object)iBoundaryPart.getFigure()));
            }
            boundaryLayoutHelper.reset(branch, this, cachedBounds);
            this.fillSubBranches(branch, subBranches, info);
            this.fillBoundaries(branch, boundaries, subBranches, info);
        } else {
            for (IBranchPart subBranch : branch.getSubBranches()) {
                info.delegate.put(subBranch.getFigure(), fakeDelegate.get((Object)subBranch.getFigure()));
            }
            for (IBoundaryPart boundary : branch.getBoundaries()) {
                info.delegate.put(boundary.getFigure(), fakeDelegate.get((Object)boundary.getFigure()));
            }
        }
        List<IBranchPart> calloutBranches = branch.getCalloutBranches();
        this.fillCalloutBranches(branch, calloutBranches, info);
        List<ISummaryPart> list = branch.getSummaries();
        ArrayList<IBranchPart> summaryBranches = new ArrayList<IBranchPart>(branch.getSummaryBranches());
        this.fillSummaries(branch, list, summaryBranches, subBranches, info);
        this.fillUnhandledSummaryBranches(branch, summaryBranches, info);
        this.addExtraSpaces(branch, info);
        boundaryLayoutHelper.reset(branch, this, null);
        info.hasBoundaryTitles = false;
        fakeDelegate = info.delegate.copy();
        realDelegate = info.delegate;
        info.delegate = fakeDelegate;
        info.hasBoundaryTitles = false;
        this.fillOverallBoundary(branch, boundaries, info);
        info.delegate = realDelegate;
        if (info.hasBoundaryTitles) {
            HashMap<IFigure, Rectangle> cachedBounds = new HashMap<IFigure, Rectangle>();
            for (IBoundaryPart boundary : branch.getBoundaries()) {
                cachedBounds.put(boundary.getFigure(), fakeDelegate.get((Object)boundary.getFigure()));
            }
            boundaryLayoutHelper.setOverallBoundary(null);
            boundaryLayoutHelper.reset(branch, this, cachedBounds);
            this.fillOverallBoundary(branch, boundaries, info);
        } else {
            for (IBranchPart subBranch : branch.getSubBranches()) {
                info.delegate.put(subBranch.getFigure(), fakeDelegate.get((Object)subBranch.getFigure()));
            }
            for (IBoundaryPart boundary : branch.getBoundaries()) {
                info.delegate.put(boundary.getFigure(), fakeDelegate.get((Object)boundary.getFigure()));
            }
        }
    }

    protected void fillCalloutBranches(IBranchPart branch, List<IBranchPart> calloutBranches, LayoutInfo info) {
        String hideCallout;
        if (calloutBranches.isEmpty()) {
            return;
        }
        IStyleSelector styleSelector = branch.getBranchPolicy().getStyleSelector(branch);
        if (styleSelector != null && Boolean.parseBoolean(hideCallout = styleSelector.getStyleValue((IGraphicalPart)branch, "hide-callout"))) {
            for (IBranchPart calloutBranch : calloutBranches) {
                calloutBranch.getFigure().setVisible(false);
            }
            IBranchConnections2 calloutConnections = branch.getCalloutConnections();
            int index = 0;
            while (index < calloutBranches.size()) {
                IDecoration decoration = calloutConnections.getDecoration(index);
                if (decoration instanceof IBranchConnectionDecoration) {
                    ((IBranchConnectionDecoration)decoration).setVisible(branch.getFigure(), false);
                }
                ++index;
            }
            return;
        }
        if ((info.isFolded() || info.isMinimized()) && this.minimizesSubBranchesToOnePoint()) {
            if (info.isFolded() && !info.isMinimized()) {
                info.setMinArea(info.createInitBounds(this.calcSubBranchesMinPoint(branch, calloutBranches, info)));
            }
            for (IBranchPart calloutBranch : calloutBranches) {
                info.putMinArea(calloutBranch.getFigure());
            }
        } else {
            this.doFillCalloutBranches(branch, calloutBranches, info);
            for (IBranchPart calloutBranch : calloutBranches) {
                IFigure calloutBranchFigure = calloutBranch.getFigure();
                if (info.get(calloutBranchFigure) != null) continue;
                info.putMinArea(calloutBranchFigure);
            }
        }
    }

    protected void doFillCalloutBranches(IBranchPart branch, List<IBranchPart> calloutBranches, LayoutInfo info) {
        if (branch.isCentral()) {
            for (IBranchPart calloutBranch : calloutBranches) {
                calloutBranch.getFigure().setVisible(false);
            }
            IBranchConnections2 calloutConnections = branch.getCalloutConnections();
            int index = 0;
            while (index < calloutBranches.size()) {
                IDecoration decoration = calloutConnections.getDecoration(index);
                if (decoration instanceof IBranchConnectionDecoration) {
                    ((IBranchConnectionDecoration)decoration).setVisible(branch.getFigure(), false);
                }
                ++index;
            }
            return;
        }
        IBranchPart parentBranch = branch.getParentBranch();
        int orientation = this.getChildTargetOrientation(parentBranch, branch);
        boolean left = 16 == orientation;
        boolean right = 8 == orientation;
        boolean south = 1 == orientation;
        boolean north = 4 == orientation;
        for (IBranchPart calloutBranch : calloutBranches) {
            int y;
            Rectangle parentTopicArea = info.get(branch.getTopicPart().getFigure());
            Rectangle parentBranchArea = info.getCheckedClientArea();
            IReferencedFigure calloutBranchFigure = (IReferencedFigure)calloutBranch.getFigure();
            ITopicPart calloutTopicPart = calloutBranch.getTopicPart();
            if (calloutTopicPart == null) continue;
            IFigure calloutFigure = calloutTopicPart.getFigure();
            Dimension calloutSize = calloutFigure.getPreferredSize();
            Point position = calloutBranch.getTopic().getPosition();
            if (position == null) {
                position = new Point();
            }
            boolean originPosition = position.x == 0 && position.y == 0;
            int offsetX = originPosition ? 0 : position.x;
            int offsetY = originPosition ? -calloutSize.height / 2 - parentTopicArea.height / 2 - 10 : position.y;
            boolean upDown = offsetY < 0;
            int dummyCalloutX = parentTopicArea.getCenter().x + offsetX - calloutSize.width / 2;
            if (left) {
                int dx = dummyCalloutX + calloutSize.width - (parentTopicArea.x + parentTopicArea.width);
                offsetX = dx > 0 ? offsetX - dx : offsetX;
            } else if (right) {
                int dx = dummyCalloutX - parentTopicArea.x;
                offsetX = dx < 0 ? offsetX - dx : offsetX;
            }
            org.eclipse.draw2d.geometry.Point reference = info.getReference();
            org.eclipse.draw2d.geometry.Point translated = reference.getTranslated(offsetX, offsetY);
            Rectangle bounds = calloutBranchFigure.getPreferredBounds(translated);
            int subRectX = left || south || north ? parentBranchArea.x : parentBranchArea.x + parentTopicArea.width;
            int subRectY = left || right || north ? parentBranchArea.y : parentBranchArea.y + parentTopicArea.height;
            int subRectWidth = left || right ? parentBranchArea.width - parentTopicArea.width : parentBranchArea.width;
            int subRectHeight = left || right ? parentBranchArea.height : parentBranchArea.height - parentTopicArea.height;
            Rectangle subRect = new Rectangle(subRectX, subRectY, subRectWidth, subRectHeight);
            boolean touchSub = subRect.touches(bounds);
            boolean touchParentTopic = bounds.touches(parentTopicArea);
            if (touchSub) {
                y = upDown ? subRect.y - bounds.height - 10 : subRect.bottom() + 10;
                bounds.setY(y);
            } else if (touchParentTopic) {
                y = upDown ? parentTopicArea.y - bounds.height - 10 : parentTopicArea.bottom() + 10;
                bounds.setY(y);
            }
            info.put((IFigure)calloutBranchFigure, bounds);
        }
    }

    protected void fillTopic(IBranchPart branch, LayoutInfo info) {
        ITopicPart topic = branch.getTopicPart();
        if (topic != null) {
            if (info.isMinimized()) {
                info.putMinArea(topic.getFigure());
            } else {
                this.doFillTopic(branch, topic, info);
            }
        }
    }

    protected void doFillTopic(IBranchPart branch, ITopicPart topicPart, LayoutInfo info) {
        IFigure fig = topicPart.getFigure();
        if (fig instanceof IReferencedFigure) {
            IReferencedFigure refFig = (IReferencedFigure)fig;
            Rectangle bounds = refFig.getPreferredBounds(info.getReference());
            info.put((IFigure)refFig, bounds);
        } else {
            Dimension size = fig.getPreferredSize();
            org.eclipse.draw2d.geometry.Point ref = info.getReference();
            Rectangle r = new Rectangle(ref.x - size.width / 2, ref.y - size.height / 2, size.width, size.height);
            info.put(fig, r);
        }
    }

    protected void fillPlusMinus(IBranchPart branch, LayoutInfo info) {
        IPlusMinusPart plusMinus = branch.getPlusMinus();
        if (plusMinus != null) {
            IFigure pmFigure = plusMinus.getFigure();
            if (info.isMinimized()) {
                info.putMinArea(pmFigure);
            } else {
                this.doFillPlusMinus(branch, plusMinus, info);
                if (info.get(pmFigure) == null) {
                    info.putMinArea(pmFigure);
                }
            }
        }
    }

    protected abstract void doFillPlusMinus(IBranchPart var1, IPlusMinusPart var2, LayoutInfo var3);

    protected void fillLabel(IBranchPart branch, LayoutInfo info) {
        ILabelPart label = branch.getLabel();
        if (label != null) {
            if (info.isMinimized() || !label.getFigure().isVisible()) {
                info.putMinArea(label.getFigure());
            } else {
                this.doFillLabel(branch, label, info);
            }
        }
    }

    protected void doFillLabel(IBranchPart branch, ILabelPart label, LayoutInfo info) {
        IRotatableFigure f;
        double angle;
        IFigure figure = label.getFigure();
        ITopicPart topicPart = branch.getTopicPart();
        Rectangle area = topicPart != null ? info.get(topicPart.getFigure()) : info.createInitBounds();
        if (figure instanceof IRotatableFigure && !Geometry.isSameAngleDegree((double)(angle = (f = (IRotatableFigure)figure).getRotationDegrees()), (double)0.0, (double)1.0E-5)) {
            org.eclipse.draw2d.geometry.Point ref = info.getReference();
            PrecisionRotator r = new PrecisionRotator();
            r.setOrigin((double)ref.x, (double)ref.y);
            r.setAngle(angle);
            PrecisionRectangle rect = r.r(new PrecisionRectangle(area));
            PrecisionDimension size = f.getNormalPreferredSize(-1, -1);
            rect.x += (rect.width - size.width) / 2.0;
            rect.y = rect.bottom() - 2.0;
            rect.width = size.width;
            rect.height = size.height;
            r.t(rect);
            info.put(figure, rect.toDraw2DRectangle());
            return;
        }
        Dimension size = figure.getPreferredSize();
        Rectangle r = new Rectangle(area.x + (area.width - size.width) / 2, area.bottom() - 2, size.width, size.height);
        info.put(figure, r);
    }

    protected void fillInformation(IBranchPart branch, LayoutInfo info) {
        IInfoPart information = branch.getInfoPart();
        if (information != null) {
            if (info.isMinimized() || !information.getFigure().isVisible()) {
                info.putMinArea(information.getFigure());
            } else {
                this.doFillInfomation(branch, information, info);
            }
        }
    }

    protected void doFillInfomation(IBranchPart branch, IInfoPart information, LayoutInfo info) {
        IFigure figure = information.getFigure();
        ITopicPart topicPart = branch.getTopicPart();
        Rectangle area = topicPart != null ? info.get(topicPart.getFigure()) : info.createInitBounds();
        Dimension size = figure.getPreferredSize();
        TopicFigure tf = (TopicFigure)topicPart.getFigure();
        ITopicDecoration decoration = tf.getDecoration();
        String shapeId = decoration.getId();
        int x = "org.xmind.topicShape.roundedRect".equals(shapeId) || "org.xmind.topicShape.rect".equals(shapeId) || "org.xmind.topicShape.underline".equals(shapeId) ? area.x : area.x + (area.width - size.width) / 2;
        int y = area.bottom() - 1;
        if (!"org.xmind.topicShape.underline".equals(shapeId)) {
            --y;
        }
        Rectangle r = new Rectangle(x, y, size.width, size.height);
        info.put(figure, r);
    }

    protected void fillSubBranches(IBranchPart branch, List<IBranchPart> subBranches, LayoutInfo info) {
        if (subBranches.isEmpty()) {
            return;
        }
        if ((info.isFolded() || info.isMinimized()) && this.minimizesSubBranchesToOnePoint()) {
            if (info.isFolded() && !info.isMinimized()) {
                info.setMinArea(info.createInitBounds(this.calcSubBranchesMinPoint(branch, subBranches, info)));
            }
            for (IBranchPart subBranch : subBranches) {
                info.putMinArea(subBranch.getFigure());
            }
        } else {
            this.doFillSubBranches(branch, subBranches, info);
            for (IBranchPart subBranch : subBranches) {
                IFigure subBranchFigure = subBranch.getFigure();
                if (info.get(subBranchFigure) != null) continue;
                info.putMinArea(subBranchFigure);
            }
        }
    }

    protected abstract void doFillSubBranches(IBranchPart var1, List<IBranchPart> var2, LayoutInfo var3);

    protected boolean minimizesSubBranchesToOnePoint() {
        return true;
    }

    protected org.eclipse.draw2d.geometry.Point calcSubBranchesMinPoint(IBranchPart branch, List<IBranchPart> subBranches, LayoutInfo info) {
        Rectangle pmBounds;
        IPlusMinusPart plusMinus = branch.getPlusMinus();
        if (plusMinus != null && (pmBounds = info.get(plusMinus.getFigure())) != null) {
            return pmBounds.getCenter();
        }
        return info.getReference();
    }

    protected void fillBoundaries(IBranchPart branch, List<IBoundaryPart> boundaries, List<IBranchPart> subBranches, LayoutInfo info) {
        if (boundaries.isEmpty()) {
            return;
        }
        if (subBranches.isEmpty() || (info.isFolded() || info.isMinimized()) && this.minimizesSubBranchesToOnePoint()) {
            for (IBoundaryPart b : boundaries) {
                info.putMinArea(b.getFigure());
            }
        } else {
            this.doFillBoundaries(branch, boundaries, info);
        }
    }

    protected void doFillBoundaries(IBranchPart branch, List<IBoundaryPart> boundaries, LayoutInfo info) {
        for (IBoundaryPart boundary : boundaries) {
            this.doFillBoundary(branch, boundary, info);
        }
    }

    protected void doFillBoundary(IBranchPart branch, IBoundaryPart boundary, LayoutInfo info) {
        BoundaryLayoutHelper helper = this.getBoundaryLayoutHelper(branch);
        BoundaryLayoutHelper.BoundaryData boundaryData = helper.getBoundaryData(boundary);
        if (boundary.getFigure() != null && ((BoundaryFigure)boundary.getFigure()).isTitleVisible() && boundary.getTitle() != null) {
            info.hasBoundaryTitles = true;
        }
        if (boundaryData.isOverall()) {
            if (boundaryData != helper.getOverallBoundary()) {
                info.putMinArea(boundary.getFigure());
            }
            return;
        }
        Rectangle area = null;
        for (IBranchPart subBranch : boundaryData.getSubBranches()) {
            Insets ins = helper.getInnerInsets(helper.getSubBranchData(subBranch), boundaryData);
            Rectangle r2 = info.get(subBranch.getFigure());
            area = Geometry.union((Rectangle)area, (Rectangle)r2.getExpanded(ins));
        }
        if (area == null) {
            info.putMinArea(boundary.getFigure());
        } else {
            area = boundaryData.expanded(area);
            info.put(boundary.getFigure(), area);
        }
    }

    protected void fillSummaries(IBranchPart branch, List<ISummaryPart> summaries, List<IBranchPart> summaryBranches, List<IBranchPart> subBranches, LayoutInfo info) {
        if (!summaries.isEmpty()) {
            if (subBranches.isEmpty() || (info.isFolded() || info.isMinimized()) && this.minimizesSubBranchesToOnePoint()) {
                for (ISummaryPart s : summaries) {
                    info.putMinArea(s.getFigure());
                }
            } else {
                this.doFillSummaries(branch, summaries, summaryBranches, info);
            }
        }
    }

    private void doFillSummaries(IBranchPart branch, List<ISummaryPart> summaries, List<IBranchPart> summaryBranches, LayoutInfo info) {
        for (ISummaryPart summary : summaries) {
            this.doFillSummary(branch, summary, summaryBranches, info);
        }
    }

    private void doFillSummary(IBranchPart branch, ISummaryPart summary, List<IBranchPart> summaryBranches, LayoutInfo info) {
        int direction = this.getSummaryDirection(branch, summary);
        Rectangle area = this.getSummaryArea(branch, summary, direction, info);
        if (area != null) {
            info.put(summary.getFigure(), area);
        } else {
            info.putMinArea(summary.getFigure());
        }
        IBranchPart conclusionBranch = this.getConclusionBranch(branch, summary, summaryBranches);
        if (conclusionBranch != null) {
            if (area == null) {
                info.putMinArea(conclusionBranch.getFigure());
            } else {
                int y;
                int x;
                Insets ins = this.getConclusionReferenceDescription(branch, summary, conclusionBranch);
                switch (direction) {
                    case 1: {
                        x = area.x + area.width / 2;
                        y = area.y - ins.bottom;
                        break;
                    }
                    case 4: {
                        x = area.x + area.width / 2;
                        y = area.bottom() + ins.top;
                        break;
                    }
                    case 8: {
                        x = area.x - ins.right;
                        y = area.y + area.height / 2;
                        break;
                    }
                    default: {
                        x = area.right() + ins.left;
                        y = area.y + area.height / 2;
                    }
                }
                info.put(conclusionBranch.getFigure(), Geometry.getExpanded((int)x, (int)y, (Insets)ins));
            }
        }
    }

    private IBranchPart getConclusionBranch(IBranchPart branch, ISummaryPart summary, List<IBranchPart> summaryBranches) {
        IBranchPart conclusionBranch;
        INodePart part = summary.getNode();
        if (part instanceof ITopicPart && (conclusionBranch = ((ITopicPart)((Object)part)).getOwnerBranch()) != null && summaryBranches.contains(conclusionBranch)) {
            summaryBranches.remove(conclusionBranch);
            return conclusionBranch;
        }
        return null;
    }

    private Insets getConclusionReferenceDescription(IBranchPart branch, ISummaryPart summary, IGraphicalPart conclusion) {
        IFigure fig = conclusion.getFigure();
        if (fig instanceof IReferencedFigure) {
            return ((IReferencedFigure)fig).getReferenceDescription();
        }
        Dimension size = fig.getPreferredSize();
        int w = size.width / 2;
        int h = size.height / 2;
        return new Insets(h, w, size.height - h, size.width - w);
    }

    protected Rectangle getSummaryArea(IBranchPart branch, ISummaryPart summary, int direction, ReferencedLayoutData data) {
        Rectangle r = null;
        for (IBranchPart subBranch : summary.getEnclosingBranches()) {
            r = Geometry.union(r, (Rectangle)data.get((Object)subBranch.getFigure()));
        }
        if (r == null) {
            return null;
        }
        Rectangle area = data.createInitBounds();
        int width = this.getPreferredSummaryWidth(summary);
        switch (direction) {
            case 1: {
                area.x = r.x;
                area.width = r.width;
                area.y = r.y - width;
                area.height = width;
                break;
            }
            case 4: {
                area.x = r.x;
                area.width = r.width;
                area.y = r.bottom();
                area.height = width;
                break;
            }
            case 8: {
                area.x = r.x - width;
                area.width = width;
                area.y = r.y;
                area.height = r.height;
                break;
            }
            default: {
                area.x = r.right();
                area.width = width;
                area.y = r.y;
                area.height = r.height;
            }
        }
        IStyleSelector ss = StyleUtils.getStyleSelector(summary);
        String shape = StyleUtils.getString(summary, ss, "shape-class", null);
        int lineWidth = StyleUtils.getInteger(summary, ss, "line-width", shape, 1);
        return area.expand(lineWidth, lineWidth);
    }

    private int getPreferredSummaryWidth(ISummaryPart summary) {
        IDecoration decoration;
        IFigure figure = summary.getFigure();
        if (figure instanceof IDecoratedFigure && (decoration = ((IDecoratedFigure)figure).getDecoration()) instanceof ISummaryDecoration) {
            return ((ISummaryDecoration)decoration).getPreferredWidth(figure);
        }
        return 30;
    }

    protected void fillUnhandledSummaryBranches(IBranchPart branch, List<IBranchPart> summaryBranches, LayoutInfo info) {
        if (!summaryBranches.isEmpty()) {
            for (IBranchPart summaryBranch : summaryBranches) {
                info.putMinArea(summaryBranch.getFigure());
            }
        }
    }

    protected void addExtraSpaces(IBranchPart branch, ReferencedLayoutData data) {
    }

    @Override
    public int getSummaryDirection(IBranchPart branch, ISummaryPart summary) {
        return 16;
    }

    protected void fillOverallBoundary(IBranchPart branch, List<IBoundaryPart> boundaries, LayoutInfo info) {
        BoundaryLayoutHelper helper;
        BoundaryLayoutHelper.BoundaryData overallBoundary;
        if (boundaries.isEmpty()) {
            return;
        }
        IBoundaryPart boundary = branch.getBoundaries().get(boundaries.size() - 1);
        if (boundary.getFigure() != null && ((BoundaryFigure)boundary.getFigure()).isTitleVisible() && boundary.getTitle() != null) {
            info.hasBoundaryTitles = true;
        }
        if ((overallBoundary = (helper = this.getBoundaryLayoutHelper(branch)).getOverallBoundary()) == null) {
            return;
        }
        if (info.isMinimized()) {
            info.putMinArea(overallBoundary.boundaryFigure);
        } else {
            Rectangle area = info.getCheckedClientArea();
            area = overallBoundary.expanded(area.getCopy());
            info.put(overallBoundary.boundaryFigure, area);
        }
    }

    @Override
    public int getRangeGrowthDirection(IBranchPart branch, IBranchRangePart range) {
        return 4;
    }

    public void invalidate(IGraphicalPart part) {
        if (part instanceof IBranchPart) {
            this.invalidateBranch((IBranchPart)part);
        }
    }

    protected void invalidateBranch(IBranchPart branch) {
        IFigure topicFigure;
        MindMapUtils.flushCache((IPart)branch, CACHE_STRUCTURE_DATA);
        MindMapUtils.flushCache((IPart)branch, CACHE_BOUNDARY_LAYOUT_HELPER);
        ITopicPart topic = branch.getTopicPart();
        if (topic != null && (topicFigure = topic.getFigure()) != null) {
            topicFigure.invalidate();
        }
    }

    protected BoundaryLayoutHelper getBoundaryLayoutHelper(IBranchPart branch) {
        BoundaryLayoutHelper helper = (BoundaryLayoutHelper)MindMapUtils.getCache((IPart)branch, CACHE_BOUNDARY_LAYOUT_HELPER);
        if (helper == null) {
            helper = new BoundaryLayoutHelper();
            helper.reset(branch, this, null);
            MindMapUtils.setCache((IPart)branch, CACHE_BOUNDARY_LAYOUT_HELPER, helper);
        }
        return helper;
    }

    protected Dimension getBorderedSize(IBranchPart branch, IBranchPart subBranch) {
        return this.getBoundaryLayoutHelper(branch).getBorderedSize(subBranch);
    }

    protected int getMinorSpacing(IBranchPart branch) {
        return StyleUtils.getInteger(branch, branch.getBranchPolicy().getStyleSelector(branch), "spacing-minor", 5);
    }

    protected int getMajorSpacing(IBranchPart branch) {
        return StyleUtils.getMajorSpacing(branch, 5);
    }

    protected Object getStructureData(IBranchPart branch) {
        Object data = MindMapUtils.getCache((IPart)branch, CACHE_STRUCTURE_DATA);
        if (!this.isValidStructureData(branch, data) && (data = this.createStructureData(branch)) != null) {
            MindMapUtils.setCache((IPart)branch, CACHE_STRUCTURE_DATA, data);
        }
        return data;
    }

    protected Object createStructureData(IBranchPart branch) {
        return null;
    }

    protected boolean isValidStructureData(IBranchPart branch, Object data) {
        return data != null;
    }

    @Override
    public int getSourceOrientation(IBranchPart branch) {
        return 0;
    }

    @Override
    public int getChildTargetOrientation(IBranchPart branch, IBranchPart subBranch) {
        return 0;
    }

    @Override
    public int calcChildIndex(IBranchPart branch, ParentSearchKey key) {
        return this.calcInsIndex(branch, key, false);
    }

    @Override
    public int calcChildDistance(IBranchPart branch, ParentSearchKey key) {
        return -1;
    }

    @Override
    public IInsertion calcInsertion(IBranchPart branch, ParentSearchKey key) {
        return null;
    }

    @Override
    public IPart calcNavigation(IBranchPart branch, String navReqType) {
        return null;
    }

    @Override
    public IPart calcChildNavigation(IBranchPart branch, IBranchPart sourceChild, String navReqType, boolean sequential) {
        if ("navigate_beginning".equals(navReqType)) {
            return this.getSubTopicPart(branch, 0);
        }
        if ("navigate_end".equals(navReqType)) {
            return this.getSubTopicPart(branch, branch.getSubBranches().size() - 1);
        }
        return null;
    }

    @Override
    public void calcSequentialNavigation(IBranchPart branch, IBranchPart startChild, IBranchPart endChild, List<IBranchPart> results) {
        this.addSubBranches(branch, startChild.getBranchIndex(), endChild.getBranchIndex(), results);
    }

    @Override
    public void calcTraversableBranches(IBranchPart branch, IBranchPart sourceChild, List<IBranchPart> results) {
        this.addSubBranch(branch, sourceChild.getBranchIndex() + 1, results);
        results.add(branch);
        this.addSubBranch(branch, sourceChild.getBranchIndex() - 1, results);
    }

    @Override
    public void calcTraversableChildren(IBranchPart branch, List<IBranchPart> results) {
        this.addSubBranches(branch, 0, branch.getSubBranches().size() - 1, results);
    }

    protected void addSubBranches(IBranchPart branch, IBranchPart fromChild, IBranchPart toChild, List<IBranchPart> results) {
        this.addSubBranches(branch, branch.getSubBranches().indexOf(fromChild), branch.getSubBranches().indexOf(toChild), results);
    }

    protected void addSubBranches(IBranchPart branch, int fromIndex, int toIndex, List<IBranchPart> results) {
        boolean decreasing = toIndex < fromIndex;
        int i = fromIndex;
        while (!(decreasing ? i < toIndex : i > toIndex)) {
            this.addSubBranch(branch, i, results);
            if (decreasing) {
                --i;
                continue;
            }
            ++i;
        }
    }

    protected void addSubBranch(IBranchPart branch, int index, List<IBranchPart> results) {
        if (index < 0 || index >= branch.getSubBranches().size()) {
            return;
        }
        results.add(branch.getSubBranches().get(index));
    }

    protected IBranchPart getSubBranch(IBranchPart branch, int index) {
        if (index >= 0 && index < branch.getSubBranches().size()) {
            return branch.getSubBranches().get(index);
        }
        return null;
    }

    protected ITopicPart getSubTopicPart(IBranchPart branch, int index) {
        IBranchPart subBranch = this.getSubBranch(branch, index);
        if (subBranch != null) {
            return subBranch.getTopicPart();
        }
        return null;
    }

    protected IInsertion getCurrentInsertion(IBranchPart branch) {
        return (IInsertion)MindMapUtils.getCache((IPart)branch, "org.xmind.ui.branchCache.insertion");
    }

    @Override
    public int getQuickMoveOffset(IBranchPart branch, IBranchPart child, int direction) {
        return 0;
    }

    protected org.eclipse.draw2d.geometry.Point getChildRef(IBranchPart branch, org.eclipse.draw2d.geometry.Point branchRef, ParentSearchKey key) {
        return key.getCursorPos();
    }

    @Override
    public org.eclipse.draw2d.geometry.Point calcInsertionPosition(IBranchPart branch, IBranchPart child, ParentSearchKey key) {
        if (child == null) {
            return this.calcInsertPosition(branch, child, key);
        }
        if (this.getOldIndex(branch, child) == -1) {
            return this.calcInsertPosition(branch, child, key);
        }
        return this.calcMovePosition(branch, child, key);
    }

    @Override
    public boolean isBranchMoved(IBranchPart branch, IBranchPart child, ParentSearchKey key) {
        int index = this.calcInsIndex(branch, key, true);
        List<Integer> disables = this.getDisableBranches(branch);
        return disables == null || !disables.contains(index) && !disables.contains(index - 1);
    }

    protected int calcInsIndex(IBranchPart branch, ParentSearchKey key, boolean withDisabled) {
        return -1;
    }

    protected org.eclipse.draw2d.geometry.Point calcInsertPosition(IBranchPart branch, IBranchPart child, ParentSearchKey key) {
        List<IBranchPart> subBranches = branch.getSubBranches();
        if (subBranches.isEmpty()) {
            return this.calcFirstChildPosition(branch, key);
        }
        int index = this.calcInsIndex(branch, key, true);
        int minorSpacing = this.getMinorSpacing(branch);
        Dimension insSize = key.getFigure().getSize();
        Dimension inventSize = key.getInvent().getSize();
        List<IBoundaryPart> boundaries = branch.getBoundaries();
        if (index == 0) {
            IBranchPart sub = subBranches.get(0);
            Rectangle bounds = sub.getFigure().getBounds();
            if (!boundaries.isEmpty()) {
                for (IBoundaryPart boundary : boundaries) {
                    Rectangle bBounds = boundary.getFigure().getBounds();
                    List<IBranchPart> enclosingBranches = boundary.getEnclosingBranches();
                    if (enclosingBranches.isEmpty() || !sub.equals(enclosingBranches.get(0))) continue;
                    Rectangle rectangle = bounds = bBounds.contains(bounds) ? bBounds : bounds;
                }
            }
            int x = key.getCursorPos().x > 0 ? bounds.x + inventSize.width / 2 : bounds.right() - inventSize.width / 2;
            int y = bounds.y - minorSpacing - insSize.height / 2;
            return new org.eclipse.draw2d.geometry.Point(x, y);
        }
        if (index == subBranches.size()) {
            IBranchPart sub = subBranches.get(subBranches.size() - 1);
            Rectangle bounds = sub.getFigure().getBounds();
            if (!boundaries.isEmpty()) {
                for (IBoundaryPart boundary : boundaries) {
                    Rectangle bBounds = boundary.getFigure().getBounds();
                    List<IBranchPart> enclosingBranches = boundary.getEnclosingBranches();
                    if (enclosingBranches.isEmpty() || !sub.equals(enclosingBranches.get(enclosingBranches.size() - 1))) continue;
                    Rectangle rectangle = bounds = bBounds.contains(bounds) ? bBounds : bounds;
                }
            }
            int x = key.getCursorPos().x > 0 ? bounds.x + inventSize.width / 2 : bounds.right() - inventSize.width / 2;
            int y = bounds.bottom() + minorSpacing + insSize.height / 2;
            return new org.eclipse.draw2d.geometry.Point(x, y);
        }
        return this.calcInventPosition(subBranches.get(index - 1), subBranches.get(index), key, key.getCursorPos().x > 0);
    }

    protected org.eclipse.draw2d.geometry.Point calcMovePosition(IBranchPart branch, IBranchPart child, ParentSearchKey key) {
        List<IBranchPart> subBranches = branch.getSubBranches();
        List<Integer> disables = this.getDisableBranches(branch);
        int index = this.calcInsIndex(branch, key, true);
        int oldIndex = this.getOldIndex(branch, child);
        if (disables != null) {
            if (disables.contains(index - 1)) {
                oldIndex = --index;
            } else if (disables.contains(index)) {
                oldIndex = index;
            }
        }
        Dimension inventSize = key.getInvent().getSize();
        if (index == oldIndex) {
            IBranchPart sub = subBranches.get(index);
            int delta = this.getTopicSize((IBranchPart)sub).width / 2 - inventSize.width / 2;
            return this.getFigureLocation(sub.getFigure()).getTranslated(key.getCursorPos().x < 0 ? delta : -delta, 0);
        }
        return this.calcInsertPosition(branch, child, key);
    }

    protected org.eclipse.draw2d.geometry.Point calcFirstChildPosition(IBranchPart branch, ParentSearchKey key) {
        int x = this.getTopicSize((IBranchPart)branch).width / 2 + this.getMajorSpacing(branch) + key.getInvent().getSize().width / 2;
        return this.getFigureLocation(branch.getFigure()).getTranslated(key.getCursorPos().x < 0 ? -x : x, 0);
    }

    protected org.eclipse.draw2d.geometry.Point calcInventPosition(IBranchPart orientation, IBranchPart assist, ParentSearchKey key, boolean isRightOrUp) {
        boolean isBefourBounds;
        Rectangle bounds;
        int minorSpacing = this.getMinorSpacing(orientation.getParentBranch());
        Dimension insSize = key.getFigure().getSize();
        Dimension inventSize = key.getInvent().getSize();
        Rectangle oriBounds = orientation.getFigure().getBounds();
        Rectangle assBounds = assist.getFigure().getBounds();
        Rectangle uBounds = oriBounds;
        Rectangle dBounds = assBounds;
        List<IBoundaryPart> boundaries = orientation.getParentBranch().getBoundaries();
        if (!boundaries.isEmpty()) {
            for (IBoundaryPart boundary : boundaries) {
                List<IBranchPart> enclosingBranches = boundary.getEnclosingBranches();
                Rectangle bBounds = boundary.getFigure().getBounds();
                if (!enclosingBranches.isEmpty() && orientation.equals(enclosingBranches.get(enclosingBranches.size() - 1))) {
                    Rectangle rectangle = uBounds = bBounds.contains(uBounds) ? bBounds : uBounds;
                }
                if (enclosingBranches.isEmpty() || !assist.equals(enclosingBranches.get(0))) continue;
                Rectangle rectangle = dBounds = bBounds.contains(dBounds) ? bBounds : dBounds;
            }
        }
        if (uBounds.equals((Object)oriBounds)) {
            bounds = uBounds;
            isBefourBounds = false;
        } else if (dBounds.equals((Object)assBounds)) {
            bounds = dBounds;
            isBefourBounds = true;
        } else if (isRightOrUp) {
            if (uBounds.x > dBounds.x) {
                bounds = uBounds;
                isBefourBounds = false;
            } else {
                bounds = dBounds;
                isBefourBounds = true;
            }
        } else if (uBounds.right() < dBounds.right()) {
            bounds = uBounds;
            isBefourBounds = false;
        } else {
            bounds = dBounds;
            isBefourBounds = true;
        }
        int x = isRightOrUp ? bounds.x + inventSize.width / 2 : bounds.right() - inventSize.width / 2;
        int y = isBefourBounds ? bounds.y - minorSpacing - insSize.height / 2 : bounds.bottom() + minorSpacing + insSize.height / 2;
        return new org.eclipse.draw2d.geometry.Point(x, y);
    }

    protected int getOldIndex(IBranchPart branch, IBranchPart child) {
        List<IBranchPart> subBranches = branch.getSubBranches();
        if (branch.equals(child.getParentBranch())) {
            return child.getBranchIndex();
        }
        for (IBranchPart sub : subBranches) {
            if (sub.getFigure().isEnabled()) continue;
            return sub.getBranchIndex();
        }
        return -1;
    }

    protected org.eclipse.draw2d.geometry.Point getFigureLocation(IFigure figure) {
        if (figure instanceof IReferencedFigure) {
            return ((IReferencedFigure)figure).getReference();
        }
        return figure.getBounds().getLocation();
    }

    protected Dimension getTopicSize(IBranchPart branch) {
        if (branch == null) {
            return new Dimension();
        }
        return branch.getTopicPart().getFigure().getSize();
    }

    protected List<Integer> getDisableBranches(IBranchPart branch) {
        List<IBranchPart> subBranches = branch.getSubBranches();
        ArrayList<Integer> disables = null;
        int i = 0;
        while (i < subBranches.size()) {
            IBranchPart sub = subBranches.get(i);
            if (!sub.getFigure().isEnabled()) {
                if (disables == null) {
                    disables = new ArrayList<Integer>();
                }
                disables.add(i);
            }
            ++i;
        }
        return disables;
    }

    protected static class LayoutInfo
    extends ReferencedLayoutData {
        private ReferencedLayoutData delegate;
        private boolean folded;
        private boolean minimized;
        private Rectangle minArea;
        private boolean hasBoundaryTitles;

        public LayoutInfo(ReferencedLayoutData delegate, boolean folded, boolean minimized) {
            this.delegate = delegate;
            this.folded = folded;
            this.minimized = minimized;
            this.minArea = null;
            this.hasBoundaryTitles = false;
        }

        public boolean isFolded() {
            return this.folded;
        }

        public boolean isMinimized() {
            return this.minimized;
        }

        public Rectangle getMinArea() {
            return this.minArea;
        }

        public void setMinArea(Rectangle minArea) {
            this.minArea = minArea;
        }

        public void putMinArea(IFigure figure) {
            if (this.minArea == null) {
                this.delegate.put(figure, this.delegate.createInitBounds());
            } else {
                this.delegate.put(figure, this.minArea.getCopy());
            }
        }

        public void add(Rectangle blankArea) {
            this.delegate.add(blankArea);
        }

        public void addMargins(Insets margin) {
            this.delegate.addMargins(margin);
        }

        public void addMargins(int top, int left, int bottom, int right) {
            this.delegate.addMargins(top, left, bottom, right);
        }

        public Rectangle createInitBounds() {
            return this.delegate.createInitBounds();
        }

        public Rectangle createInitBounds(org.eclipse.draw2d.geometry.Point ref) {
            return this.delegate.createInitBounds(ref);
        }

        public Rectangle get(Object figure) {
            return this.delegate.get(figure);
        }

        public Rectangle getCheckedClientArea() {
            return this.delegate.getCheckedClientArea();
        }

        public Rectangle getClientArea() {
            return this.delegate.getClientArea();
        }

        public org.eclipse.draw2d.geometry.Point getReference() {
            return this.delegate.getReference();
        }

        public void put(IFigure figure, Rectangle preferredBounds) {
            this.delegate.put(figure, preferredBounds);
        }

        public void translate(int dx, int dy) {
            this.delegate.translate(dx, dy);
        }
    }
}

