/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.blackbox;

import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.xmind.core.util.FileUtils;
import org.xmind.ui.blackbox.BlackBoxLibrary;
import org.xmind.ui.blackbox.BlackBoxVersion;
import org.xmind.ui.blackbox.IBlackBoxLibrary;
import org.xmind.ui.blackbox.IBlackBoxMap;
import org.xmind.ui.blackbox.IBlackBoxVersion;
import org.xmind.ui.internal.MindMapUIPlugin;

public class BlackBoxManager {
    private static BlackBoxManager instance = new BlackBoxManager();
    public static final String FILE_BLACKBOX = "blackbox";
    public static final String FILE_INFO_EXT = ".xbkinfo";
    public static final int MD5_LENGTH = 32;
    public static final int TIMESTAMP_LENGTH = 13;
    public static final String FILE_XMIND_EXT = ".xbkmap";
    private static final String BREAK = ".";
    private static List<IBlackBoxVersion> versionTrashes = new ArrayList<IBlackBoxVersion>();
    private static List<IBlackBoxMap> mapTrashes = new ArrayList<IBlackBoxMap>();
    private static String pluginPath;
    private static String blackboxPath;
    private IBlackBoxLibrary library;

    private BlackBoxManager() {
    }

    public static BlackBoxManager getInstance() {
        return instance;
    }

    public static void log(String message, Throwable e) {
        Status status = new Status(e == null ? 2 : 4, message, "org.xmind.ui.blackbox", e);
        MindMapUIPlugin.getDefault().getLog().log((IStatus)status);
    }

    public static String getPluginPath() {
        if (pluginPath != null) {
            return pluginPath;
        }
        Bundle bundle = MindMapUIPlugin.getDefault().getBundle();
        String parentFile = Platform.getStateLocation((Bundle)bundle).toFile().getParent();
        pluginPath = new File(parentFile, "org.xmind.ui.blackbox").getAbsolutePath();
        return pluginPath;
    }

    public static String getBlackboxPath() {
        if (blackboxPath != null && new File(blackboxPath).exists()) {
            return blackboxPath;
        }
        File blackbox = new File(BlackBoxManager.getPluginPath(), FILE_BLACKBOX);
        FileUtils.ensureDirectory((File)blackbox);
        if (blackbox.exists()) {
            blackboxPath = blackbox.getAbsolutePath();
        }
        return blackboxPath;
    }

    public static void addTrash(IBlackBoxVersion version) {
        if (version == null) {
            return;
        }
        versionTrashes.add(version);
    }

    public static void addTrash(IBlackBoxMap map) {
        if (map == null) {
            return;
        }
        mapTrashes.add(map);
    }

    public static void clearTrashes() {
        if (mapTrashes.size() > 0) {
            for (IBlackBoxMap m : mapTrashes) {
                Set<IBlackBoxVersion> versions = m.getVersions();
                for (IBlackBoxVersion v : versions) {
                    if (versionTrashes.contains(v)) continue;
                    versionTrashes.add(v);
                }
                File metaFile = new File(BlackBoxManager.getBlackboxPath(), String.valueOf(m.getID()) + FILE_INFO_EXT);
                if (metaFile == null || !metaFile.exists()) continue;
                metaFile.delete();
            }
            mapTrashes.clear();
        }
        if (versionTrashes.size() > 0) {
            for (IBlackBoxVersion v : versionTrashes) {
                File trash = v.getFile();
                if (trash == null || !trash.exists()) continue;
                trash.delete();
            }
            versionTrashes.clear();
        }
    }

    public static String convertToMD5(String source) {
        if (source == null) {
            return null;
        }
        String plainText = source;
        try {
            StringBuffer buf = new StringBuffer();
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(plainText.getBytes());
            byte[] b = md.digest();
            int offset = 0;
            while (offset < b.length) {
                int i = b[offset];
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
                ++offset;
            }
            return buf.toString();
        }
        catch (Exception e) {
            BlackBoxManager.log("Error occurred while generate map id.", e);
            return null;
        }
    }

    public void doBackup(String source) {
        if (!this.isEnable() || source == null) {
            return;
        }
        IBlackBoxLibrary library = this.getLibrary();
        IBlackBoxMap map = library.findMapBySource(source);
        String mapID = map == null ? this.getMapID(source) : map.getID();
        String timestamp = String.valueOf(System.currentTimeMillis());
        boolean isReliable = !this.getLibrary().isSavedMap(source);
        File dest = null;
        try {
            dest = this.backup(source, mapID, timestamp, isReliable);
        }
        catch (IOException e) {
            BlackBoxManager.log("Error occurred while backup src file.", e);
            return;
        }
        if (dest != null) {
            BlackBoxVersion version = new BlackBoxVersion(mapID, timestamp, isReliable);
            version.setFile(dest);
            library.addVersion(source, mapID, version);
        }
    }

    public IBlackBoxMap[] getMaps() {
        return this.getLibrary().getMaps();
    }

    public boolean removeMap(IBlackBoxMap map) {
        if (map == null) {
            return false;
        }
        return this.getLibrary().removeMap(map);
    }

    public boolean removeVersion(String source, String timestamp) {
        return this.removeVersion(this.findMapBySource(source), timestamp);
    }

    public boolean removeVersion(IBlackBoxMap map, String timestamp) {
        if (map == null) {
            return false;
        }
        return this.getLibrary().removeVersion(map, timestamp);
    }

    public IBlackBoxMap findMapBySource(String source) {
        if (source != null) {
            return this.getLibrary().findMapBySource(source);
        }
        return null;
    }

    public IBlackBoxMap findMapByID(String id) {
        if (id != null) {
            return this.getLibrary().findMapByID(id);
        }
        return null;
    }

    public IBlackBoxLibrary getLibrary() {
        if (this.library == null) {
            this.library = new BlackBoxLibrary();
        }
        return this.library;
    }

    public void removeSavedMap(String source) {
        if (!this.isEnable() || source == null) {
            return;
        }
        this.getLibrary().removeSavedMap(source);
    }

    private File backup(String source, String mapID, String timestamp, boolean isReliable) throws IOException {
        File src = new File(source);
        if (!src.exists() || mapID == null) {
            return null;
        }
        String destName = this.getDestName(mapID, timestamp, isReliable);
        File dest = new File(this.getDestPath(mapID), destName);
        if (!dest.exists()) {
            dest.createNewFile();
        }
        FileUtils.copy((File)src, (File)dest);
        return dest;
    }

    private String getDestName(String mapID, String timestamp, boolean isReliable) {
        if (isReliable) {
            return String.valueOf(mapID) + BREAK + "a" + BREAK + timestamp + FILE_XMIND_EXT;
        }
        return String.valueOf(mapID) + BREAK + "b" + BREAK + timestamp + FILE_XMIND_EXT;
    }

    private String getDestPath(String mapID) throws IOException {
        return BlackBoxManager.getBlackboxPath();
    }

    private String getMapID(String source) {
        return BlackBoxManager.convertToMD5(source);
    }

    private boolean isEnable() {
        return MindMapUIPlugin.getDefault().getPreferenceStore().getBoolean("autoBackupEnable");
    }
}

