/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap.filtering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import net.xmind.verify.ui.VerifyUI20141031;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.xmind.core.ILegend;
import org.xmind.core.ISheet;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.marker.IMarker;
import org.xmind.core.util.IMarkerRefCounter;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.mindmap.filtering.AdvancedFilterDialog;
import org.xmind.ui.internal.mindmap.filtering.FilterPlugin;
import org.xmind.ui.internal.mindmap.filtering.FilterService;
import org.xmind.ui.internal.mindmap.filtering.IPropertyFilterListener;
import org.xmind.ui.internal.mindmap.filtering.MarkerFilter;
import org.xmind.ui.internal.mindmap.filtering.Messages;
import org.xmind.ui.internal.mindmap.filtering.PropertyFilter;
import org.xmind.ui.util.MarkerImageDescriptor;

public class MiniFilterItem
extends ContributionItem
implements IPageChangedListener,
ICoreEventListener,
IPropertyFilterListener {
    private static final String FUNNEL_ICON_PATH = "funnel.png";
    private static final int MARKER_HEIGHT = 16;
    private ToolBar widgetBar;
    private ToolItem widget;
    private IGraphicalEditor editor;
    private FilterService filterService;
    private MenuManager markerMenu;
    private MenuManager dropdownMenu;
    private ICoreEventRegister register;
    private Collection<String> markerIds;
    private Image image = null;
    private Image disabledImage = null;
    private Image markerImage = null;

    public MiniFilterItem(IGraphicalEditor editor) {
        this.editor = editor;
        this.setId("org.xmind.ui.MiniFilterItem");
        editor.addPageChangedListener((IPageChangedListener)this);
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                MiniFilterItem.this.setActivePage(MiniFilterItem.this.getActivePage());
            }
        });
    }

    private IGraphicalEditorPage getActivePage() {
        return this.editor.getActivePageInstance();
    }

    public void dispose() {
        this.setFilterService(null);
        if (this.register != null) {
            this.register.unregisterAll();
            this.register = null;
        }
        this.editor.removePageChangedListener((IPageChangedListener)this);
        if (this.markerImage != null) {
            this.markerImage.dispose();
            this.markerImage = null;
        }
        if (this.disabledImage != null) {
            this.disabledImage.dispose();
            this.disabledImage = null;
        }
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        if (this.markerMenu != null) {
            this.markerMenu.dispose();
            this.markerMenu = null;
        }
        if (this.dropdownMenu != null) {
            this.dropdownMenu.dispose();
            this.dropdownMenu = null;
        }
        if (this.widget != null) {
            this.widget.dispose();
            this.widget = null;
        }
        super.dispose();
    }

    public void pageChanged(PageChangedEvent event) {
        this.setActivePage(this.editor.getActivePageInstance());
    }

    private void setActivePage(IGraphicalEditorPage page) {
        ISheet sheet;
        this.setFilterService(this.getFilterService(page));
        IMarkerRefCounter counter = null;
        ILegend legend = null;
        ISheet iSheet = sheet = page == null ? null : (ISheet)page.getAdapter(ISheet.class);
        if (sheet != null) {
            counter = (IMarkerRefCounter)sheet.getAdapter(IMarkerRefCounter.class);
            legend = sheet.getLegend();
        }
        if (this.register != null) {
            this.register.unregisterAll();
        } else {
            this.register = new CoreEventRegister((ICoreEventListener)this);
        }
        if (counter != null) {
            this.register.setNextSourceFrom((Object)counter);
            this.register.register("resourceRefs");
            this.markerIds = counter.getCountedRefs();
        } else {
            this.markerIds = null;
        }
        if (legend != null) {
            this.register.setNextSourceFrom((Object)legend);
            this.register.register("markerDescription");
        }
        this.update();
    }

    private void setFilterService(FilterService service) {
        FilterService oldService = this.filterService;
        if (oldService != null) {
            oldService.removeFilterListener(this);
        }
        this.filterService = service;
        if (service != null) {
            service.addFilterListener(this);
        }
    }

    private FilterService getFilterService(IGraphicalEditorPage page) {
        IGraphicalViewer viewer;
        if (page != null && (viewer = page.getViewer()) != null) {
            return (FilterService)viewer.getService(FilterService.class);
        }
        return null;
    }

    public void handleCoreEvent(final CoreEvent event) {
        if (this.widget == null || this.widget.isDisposed()) {
            return;
        }
        this.widget.getDisplay().syncExec(new Runnable(){

            public void run() {
                String markerId;
                if ("resourceRefs".equals(event.getType())) {
                    IMarkerRefCounter counter = (IMarkerRefCounter)event.getSource();
                    MiniFilterItem.this.markerIds = counter.getCountedRefs();
                    MiniFilterItem.this.update();
                } else if ("markerDescription".equals(event.getType()) && (markerId = (String)event.getTarget()).equals(MiniFilterItem.this.getSingleMarkerId())) {
                    MiniFilterItem.this.update();
                }
            }
        });
    }

    private String getSingleMarkerId() {
        MarkerFilter filter;
        if (this.filterService != null && this.filterService.isSingleFilter() && (filter = this.filterService.getMarkerFilter()).isSingleFilter()) {
            return (String)filter.getPropertyFilters().iterator().next();
        }
        return null;
    }

    public boolean isDynamic() {
        return true;
    }

    public void fill(ToolBar parent, int index) {
        if (this.widget != null && !this.widget.isDisposed()) {
            return;
        }
        ToolItem separator = index < 0 ? new ToolItem(parent, 2) : new ToolItem(parent, 2, index++);
        this.widgetBar = new ToolBar((Composite)parent, 0x800000);
        this.widget = new ToolItem(this.widgetBar, 8);
        if (this.image == null) {
            this.image = FilterPlugin.imageFrom(FUNNEL_ICON_PATH).createImage(false);
        }
        this.widget.setImage(this.image);
        if (this.disabledImage == null) {
            this.disabledImage = FilterPlugin.imageDisabled(FUNNEL_ICON_PATH).createImage(false);
        }
        this.widget.setDisabledImage(this.disabledImage);
        separator.setWidth(this.widgetBar.computeSize((int)-1, (int)-1, (boolean)true).x);
        separator.setControl((Control)this.widgetBar);
        this.widget.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MiniFilterItem.this.handleWidgetSelection();
            }
        });
        this.dropdownMenu = new MenuManager("#PopupMenu");
        this.fillDropdownMenu(this.dropdownMenu);
        this.widgetBar.setMenu(this.dropdownMenu.createContextMenu((Control)this.widgetBar));
        this.update(null);
    }

    private void handleWidgetSelection() {
        if (!this.filterService.hasFilter()) {
            this.showMarkerMenu();
        }
        if (this.filterService.hasFilter()) {
            this.filterService.removeAllFilters();
            this.filterService.setDarker(true);
        }
    }

    private void showMarkerMenu() {
        if (this.markerMenu == null) {
            this.markerMenu = new MenuManager();
        }
        this.markerMenu.removeAll();
        this.fillMarkerMenu((IMenuManager)this.markerMenu);
        if (this.markerMenu.isEmpty()) {
            return;
        }
        Rectangle itemBounds = this.widget.getBounds();
        Menu menuWidget = this.markerMenu.createContextMenu((Control)this.widgetBar);
        menuWidget.setLocation(this.widgetBar.toDisplay(itemBounds.x, itemBounds.y));
        menuWidget.setVisible(true);
    }

    private void fillDropdownMenu(MenuManager menu) {
        ShowAllAction showAllAction = new ShowAllAction();
        showAllAction.setEnabled(this.filterService != null && this.filterService.isActive() && this.filterService.hasFilter());
        menu.add((IAction)showAllAction);
        menu.add((IAction)new AdvancedFilterAction());
        menu.addMenuListener(new IMenuListener((IAction)showAllAction){
            private final /* synthetic */ IAction val$showAllAction;
            {
                this.val$showAllAction = iAction;
            }

            public void menuAboutToShow(IMenuManager manager) {
                this.val$showAllAction.setEnabled(MiniFilterItem.this.filterService != null && MiniFilterItem.this.filterService.isActive() && MiniFilterItem.this.filterService.hasFilter());
            }
        });
    }

    private void fillMarkerMenu(IMenuManager menu) {
        final HashMap names = new HashMap();
        ArrayList<String> list = new ArrayList<String>(this.markerIds);
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String name1 = this.getName(o1);
                String name2 = this.getName(o2);
                return name1.compareToIgnoreCase(name2);
            }

            private String getName(String markerId) {
                String name = (String)names.get(markerId);
                if (name == null) {
                    name = MiniFilterItem.this.getMarkerName(markerId);
                    names.put(markerId, name);
                }
                return name;
            }
        });
        for (String markerId : list) {
            String text = (String)names.get(markerId);
            if (text == null) {
                text = this.getMarkerName(markerId);
            }
            ImageDescriptor image = this.getMarkerImageDescriptor(markerId, false);
            menu.add((IAction)new ShowSingleMarkerAction(markerId, text, image));
        }
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)new AdvancedFilterAction());
    }

    public void filterChanged(PropertyFilter filter) {
        this.update();
    }

    public void update() {
        this.update(null);
    }

    public void update(String id) {
        Image newImage;
        if (this.widget == null || this.widget.isDisposed()) {
            return;
        }
        if (this.filterService == null) {
            this.setFilterService(this.getFilterService(this.getActivePage()));
        }
        boolean enabled = this.filterService != null && this.filterService.isActive() && this.markerIds != null && !this.markerIds.isEmpty();
        this.widget.setEnabled(enabled);
        String markerId = this.getSingleMarkerId();
        if (markerId != null) {
            if (this.markerImage != null) {
                this.markerImage.dispose();
            }
            newImage = this.markerImage = this.createMarkerImage(markerId);
        } else {
            newImage = this.image;
        }
        this.widget.setImage(newImage);
    }

    private String getMarkerName(String markerId) {
        ISheet sheet;
        IGraphicalEditorPage page = this.editor.getActivePageInstance();
        if (page != null && (sheet = (ISheet)page.getAdapter(ISheet.class)) != null) {
            return sheet.getLegend().getMarkerDescription(markerId);
        }
        return "";
    }

    private ImageDescriptor getMarkerImageDescriptor(String markerId, boolean originalSize) {
        ISheet sheet;
        IGraphicalEditorPage page = this.editor.getActivePageInstance();
        if (page != null && (sheet = (ISheet)page.getAdapter(ISheet.class)) != null) {
            IMarker marker = sheet.getOwnedWorkbook().getMarkerSheet().findMarker(markerId);
            if (marker != null && originalSize) {
                return MarkerImageDescriptor.createFromMarker((IMarker)marker);
            }
            return MarkerImageDescriptor.createFromMarker((IMarker)marker, (int)16, (int)16);
        }
        return null;
    }

    private Image createMarkerImage(String markerId) {
        ImageDescriptor imageDescriptor = this.getMarkerImageDescriptor(markerId, false);
        if (imageDescriptor == null) {
            return null;
        }
        return imageDescriptor.createImage(false, (Device)Display.getCurrent());
    }

    private class AdvancedFilterAction
    extends Action {
        private boolean dialogOpened;

        public AdvancedFilterAction() {
            super(Messages.MiniItem_AdvancedFilter_text, FilterPlugin.imageFrom("advanced_filter.png"));
            this.dialogOpened = false;
        }

        public void run() {
            VerifyUI20141031.runAction20141031((String)"AdvancedFilter", (String)Messages.MiniFilterItem_Verify_Message, (int)7, (Runnable)new Runnable(){

                public void run() {
                    AdvancedFilterDialog dialog = new AdvancedFilterDialog(Display.getDefault().getActiveShell()){

                        public int open() {
                            AdvancedFilterAction.this.dialogOpened = true;
                            return super.open();
                        }

                        public boolean close() {
                            AdvancedFilterAction.this.dialogOpened = false;
                            return super.close();
                        }
                    };
                    if (!AdvancedFilterAction.this.dialogOpened) {
                        dialog.open();
                    }
                }
            }, null);
        }
    }

    private class ShowAllAction
    extends Action {
        public ShowAllAction() {
            super(Messages.MiniItem_ShowAll_text, FilterPlugin.imageFrom("showall.gif"));
        }

        public void run() {
            if (MiniFilterItem.this.filterService == null) {
                return;
            }
            MiniFilterItem.this.filterService.removeAllFilters();
        }
    }

    private class ShowSingleMarkerAction
    extends Action {
        private String markerId;

        public ShowSingleMarkerAction(String markerId, String text, ImageDescriptor image) {
            super(text, image);
            this.setId(markerId);
            this.markerId = markerId;
        }

        public void run() {
            this.showSingleMarker(this.markerId);
        }

        private void showSingleMarker(String markerId) {
            if (MiniFilterItem.this.filterService == null) {
                return;
            }
            MiniFilterItem.this.filterService.removeAllFilters();
            MiniFilterItem.this.filterService.setDarker(true);
            MarkerFilter filter = MiniFilterItem.this.filterService.getMarkerFilter();
            filter.addPropertyFilter(markerId);
        }
    }
}

