/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.xmind.gef.IViewer;
import org.xmind.gef.draw2d.ITextFigure;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IRootPart;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gantt.GanttMessages;
import org.xmind.ui.gantt2.gefext.GraphicalEditPart;
import org.xmind.ui.gantt2.viewer.Colors;
import org.xmind.ui.gantt2.viewer.DateRange;
import org.xmind.ui.gantt2.viewer.GanttEditDomain;
import org.xmind.ui.gantt2.viewer.IHasOffset;
import org.xmind.ui.gantt2.viewer.IHasOffset2;
import org.xmind.ui.gantt2.viewer.OffsetFigure;
import org.xmind.ui.gantt2.viewer.Tick;
import org.xmind.ui.gantt2.viewer.TickFigure;
import org.xmind.ui.gantt2.viewer.TimelineModel;
import org.xmind.ui.gantt2.viewer.TimelineSectionPart;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;

public class TimelineTickPart
extends GraphicalEditPart
implements PropertyChangeListener {
    private ITextFigure majorTitle = null;
    private OffsetFigure majorTitleContainer = null;
    private PropertyChangeListener propertiesListener;

    public TimelineTickPart(Object model) {
        this.setModel(model);
        this.setFigure(this.createFigure());
    }

    public Tick getTick() {
        return (Tick)this.getModel();
    }

    protected IFigure createFigure() {
        TickFigure tickFigure = new TickFigure();
        tickFigure.setForegroundColor(Colors.timelineTick());
        tickFigure.setBackgroundColor(Colors.header());
        tickFigure.setMajority(this.getTick().getMajority());
        return tickFigure;
    }

    private TimelineModel getTimeline() {
        return ((GanttEditDomain)this.getSite().getDomain()).getTimelineModel();
    }

    public void addNotify() {
        super.addNotify();
        this.installMajorTitle();
    }

    public void removeNotify() {
        super.removeNotify();
        this.uninstallMajorTitle();
    }

    private void installMajorTitle() {
        if (this.getParent() != null && this.getTick().getMajority() >= 1) {
            if (this.majorTitleContainer == null) {
                this.createMajorTitle();
            }
            if (this.majorTitleContainer.getParent() == null) {
                ((TimelineSectionPart)this.getParent()).getMajorTitleLayer().add((IFigure)this.majorTitleContainer);
            }
        }
    }

    private void createMajorTitle() {
        this.majorTitle = new RotatableWrapLabel();
        this.majorTitle.setFont(FontUtils.getNewHeight((String)"org.eclipse.jface.defaultfont", (int)9));
        this.majorTitle.setForegroundColor(ColorUtils.getColor((String)"#808080"));
        this.majorTitleContainer = new OffsetFigure();
        this.majorTitleContainer.setLayoutManager((LayoutManager)new StackLayout());
        this.majorTitleContainer.add((IFigure)this.majorTitle);
    }

    private void uninstallMajorTitle() {
        if (this.getParent() != null && this.majorTitleContainer != null && this.majorTitleContainer.getParent() != null) {
            ((TimelineSectionPart)this.getParent()).getMajorTitleLayer().remove((IFigure)this.majorTitleContainer);
        }
    }

    protected void updateView(Object property) {
        super.updateView(property);
        TimelineModel timeline = this.getTimeline();
        Tick tick = this.getTick();
        DateRange parentRange = (DateRange)this.getParent().getModel();
        int sectionOffset = timeline.getPixelsFromMillis(parentRange.start.getTimeInMillis() - timeline.getOriginDate().getTimeInMillis());
        int tickOffset = timeline.getPixelsFromMillis(tick.start.getTimeInMillis() - timeline.getOriginDate().getTimeInMillis());
        ((IHasOffset2)this.getFigure()).setOffsetValue(tickOffset - sectionOffset);
        int width = timeline.getPixelsFromMillis(tick.end.getTimeInMillis() - tick.start.getTimeInMillis());
        this.getFigure().setPreferredSize(new Dimension(width, 0));
        int majority = tick.getMajority();
        ((TickFigure)this.getFigure()).setMajority(majority);
        if (majority >= 1) {
            this.installMajorTitle();
        } else {
            this.uninstallMajorTitle();
        }
        if (this.majorTitleContainer != null && this.majorTitleContainer.getParent() != null) {
            double p = timeline.getPrecision();
            String format = null;
            String text = null;
            if (p <= 0.08333333333333333) {
                format = "%1$tH:%1$tM:%1$tS";
            } else if (p <= 5.0) {
                format = "%1$tH:%1$tM";
            } else if (p <= 144.0) {
                format = "%1$tk";
            } else if (p <= 3323.0) {
                text = WEEKS.get(tick.start.get(7) - 1).getText();
            } else if (p <= 3456.0) {
                format = "%1$te";
            } else if (p <= 15120.0) {
                format = "%1$te";
            } else if (p <= 64800.0) {
                text = MONTHS.get(tick.start.get(2)).getText();
            } else {
                format = "%1$tB";
            }
            if (text == null) {
                text = String.format(format, tick.start);
            }
            if (this.getTimeline().getPrecision() == 15120.0 && this.getTick().getMajority() == 3 && tick.start.get(7) != 1) {
                text = null;
            }
            this.majorTitle.setText(text);
            this.majorTitleContainer.setOffsetValue(((IHasOffset)this.getFigure()).getOffset());
        }
    }

    protected void installModelListeners() {
        super.installModelListeners();
        this.getTimeline().getPropertyChangeSupport().addPropertyChangeListener("precision", this);
    }

    protected void uninstallModelListeners() {
        this.getTimeline().getPropertyChangeSupport().removePropertyChangeListener("precision", this);
        super.uninstallModelListeners();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.update();
    }

    protected void onActivated() {
        super.onActivated();
        if (this.getProperties() != null) {
            this.getProperties().addPropertyChangeListener("renderTextAsPath", this.getPropertiesListener());
        }
    }

    protected void onDeactivated() {
        if (this.getProperties() != null) {
            this.getProperties().removePropertyChangeListener("renderTextAsPath", this.getPropertiesListener());
        }
        super.onDeactivated();
    }

    private Properties getProperties() {
        IPart parent = this.getParent();
        while (parent != null && !(parent instanceof IRootPart)) {
            parent = parent.getParent();
        }
        if (parent == null) {
            return null;
        }
        IViewer viewer = ((IRootPart)parent).getViewer();
        return viewer == null ? null : viewer.getProperties();
    }

    private PropertyChangeListener getPropertiesListener() {
        if (this.propertiesListener == null) {
            this.propertiesListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (TimelineTickPart.this.getProperties() != null) {
                        boolean useAdvancedRenderer = TimelineTickPart.this.getProperties().getBoolean("renderTextAsPath", false);
                        if (TimelineTickPart.this.majorTitle != null) {
                            ((RotatableWrapLabel)TimelineTickPart.this.majorTitle).setRenderStyle(useAdvancedRenderer ? 1 : 0);
                        }
                    }
                }
            };
        }
        return this.propertiesListener;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MONTHS {
        JAN(GanttMessages.Timeline_January),
        FEB(GanttMessages.Timeline_February),
        MAR(GanttMessages.Timeline_March),
        APR(GanttMessages.Timeline_April),
        MAY(GanttMessages.Timeline_May),
        JUN(GanttMessages.Timeline_June),
        JUL(GanttMessages.Timeline_July),
        AUG(GanttMessages.Timeline_August),
        SEP(GanttMessages.Timeline_September),
        OCT(GanttMessages.Timeline_October),
        NOV(GanttMessages.Timeline_November),
        DEC(GanttMessages.Timeline_December);

        private String text;

        private MONTHS(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public static MONTHS get(int index) {
            return MONTHS.values()[index];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum WEEKS {
        SUN(GanttMessages.Timeline_Sunday),
        MON(GanttMessages.Timeline_Monday),
        TUE(GanttMessages.Timeline_Tuesday),
        WED(GanttMessages.Timeline_Wednesday),
        THU(GanttMessages.Timeline_Thursday),
        FRI(GanttMessages.Timeline_Friday),
        SAT(GanttMessages.Timeline_Saturaday);

        public String text;

        private WEEKS(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public static WEEKS get(int index) {
            return WEEKS.values()[index];
        }
    }
}

