/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Font;
import org.xmind.gef.IViewer;
import org.xmind.gef.draw2d.ITextFigure;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IRootPart;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gantt2.gefext.GraphicalEditPart;
import org.xmind.ui.gantt2.viewer.Colors;
import org.xmind.ui.gantt2.viewer.DateRange;
import org.xmind.ui.gantt2.viewer.GanttEditDomain;
import org.xmind.ui.gantt2.viewer.GanttViewer;
import org.xmind.ui.gantt2.viewer.IHasOffset;
import org.xmind.ui.gantt2.viewer.IOffsetProvider;
import org.xmind.ui.gantt2.viewer.OffsetLayer;
import org.xmind.ui.gantt2.viewer.Tick;
import org.xmind.ui.gantt2.viewer.TickFigure;
import org.xmind.ui.gantt2.viewer.TimelineModel;
import org.xmind.ui.resources.FontUtils;

public class TimelineSectionPart
extends GraphicalEditPart
implements PropertyChangeListener {
    public static final int TICK_HEIGHT = 20;
    private static final Rectangle AREA = new Rectangle();
    private static final Rectangle RECT = new Rectangle();
    private ITextFigure title;
    private IFigure ticksLayer;
    private IFigure majorTitleLayer;
    private TickFigure tickFigure;
    private PropertyChangeListener propertiesListener;

    public TimelineSectionPart(Object model) {
        this.setModel(model);
        this.setFigure(this.createFigure());
    }

    protected IFigure createFigure() {
        OffsetLayer layer = new OffsetLayer();
        layer.setLayoutManager((LayoutManager)new TimelineSectionLayout());
        this.tickFigure = new TickFigure();
        this.tickFigure.setForegroundColor(Colors.timelineTick());
        layer.add((IFigure)this.tickFigure);
        this.title = new TimelineLabel();
        this.title.setForegroundColor(Colors.timelineLabel());
        this.title.setBackgroundColor(Colors.timeline());
        this.title.setFont(FontUtils.getNewHeight((String)"org.eclipse.jface.defaultfont", (int)10));
        layer.add((IFigure)this.title);
        this.ticksLayer = new Layer();
        this.ticksLayer.setLayoutManager((LayoutManager)new TicksLayout());
        layer.add(this.ticksLayer);
        this.majorTitleLayer = new Layer();
        this.majorTitleLayer.setLayoutManager((LayoutManager)new TicksLayout());
        layer.add(this.majorTitleLayer);
        return layer;
    }

    public IFigure getContentPane() {
        return this.ticksLayer;
    }

    public IFigure getMajorTitleLayer() {
        return this.majorTitleLayer;
    }

    public DateRange getDateRange() {
        return (DateRange)this.getModel();
    }

    protected void updateView(Object property) {
        super.updateView(property);
        DateRange dateRange = this.getDateRange();
        TimelineModel timeline = this.getTimeline();
        double p = timeline.getPrecision();
        String format = p <= 0.08333333333333333 ? "%1$tH:%1$tM %1$tb %1$te, %1$tY" : (p <= 5.0 ? "%1$tH:00 %1$tb %1$te, %1$tY" : (p <= 144.0 ? "%1$tb %1$te, %1$tY" : (p <= 3323.0 ? "%1$tB %1$td %1$tY" : (p <= 3456.0 ? "%1$tB %1$tY" : (p < 64800.0 ? "%1$tb %1$tY" : "%1$tY")))));
        this.title.setText(String.format(format, dateRange.start));
    }

    public ITextFigure getTitle() {
        return this.title;
    }

    public TimelineModel getTimeline() {
        return ((GanttEditDomain)this.getSite().getDomain()).getTimelineModel();
    }

    protected void installModelListeners() {
        super.installModelListeners();
        this.getTimeline().getPropertyChangeSupport().addPropertyChangeListener("precision", this);
    }

    protected void uninstallModelListeners() {
        this.getTimeline().getPropertyChangeSupport().removePropertyChangeListener("precision", this);
        super.uninstallModelListeners();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.getFigure().revalidate();
    }

    protected Object[] getModelChildren(Object model) {
        int dayOfWeek;
        DateRange dateRange = this.getDateRange();
        TimelineModel timeline = this.getTimeline();
        int[] tickField = this.getTickField(timeline);
        ArrayList<Tick> childrenRanges = new ArrayList<Tick>(60);
        int loop = 0;
        Calendar start = dateRange.start;
        if (tickField[0] == 5 && tickField[1] == 7 && (dayOfWeek = start.get(7)) != 1) {
            if (((DateRange)this.getModel()).isFirst()) {
                childrenRanges.add(Tick.tickStartedFrom(start, tickField[0], tickField[1], -1));
            }
            ++loop;
            start = DateRange.rollDate(start, 5, 7 - dayOfWeek + 1);
        }
        Tick tick = null;
        while (tick == null || tick.end.before(dateRange.end)) {
            tick = Tick.tickStartedFrom(tick == null ? start : tick.end, tickField[0], tickField[1], childrenRanges.isEmpty() ? 3 : (loop == 0 ? 2 : 1));
            childrenRanges.add(tick);
            if (++loop < tickField[2]) continue;
            loop = 0;
        }
        return childrenRanges.toArray();
    }

    private int[] getTickField(TimelineModel timeline) {
        double p = timeline.getPrecision();
        if (p <= 0.08333333333333333) {
            return new int[]{13, 1, 10};
        }
        if (p <= 5.0) {
            return new int[]{12, 1, 10};
        }
        if (p <= 144.0) {
            return new int[]{10, 1, 12};
        }
        if (p <= 3323.0) {
            return new int[]{5, 1, Integer.MAX_VALUE};
        }
        if (p <= 3456.0) {
            return new int[]{5, 1, 10};
        }
        if (p <= 15120.0) {
            return new int[]{5, 7, Integer.MAX_VALUE};
        }
        return new int[]{2, 1, 6};
    }

    protected void onActivated() {
        super.onActivated();
        if (this.getProperties() != null) {
            this.getProperties().addPropertyChangeListener("renderTextAsPath", this.getPropertiesListener());
        }
    }

    protected void onDeactivated() {
        if (this.getProperties() != null) {
            this.getProperties().removePropertyChangeListener("renderTextAsPath", this.getPropertiesListener());
        }
        super.onDeactivated();
    }

    private Properties getProperties() {
        IPart parent = this.getParent();
        while (parent != null && !(parent instanceof IRootPart)) {
            parent = parent.getParent();
        }
        if (parent == null) {
            return null;
        }
        IViewer viewer = ((IRootPart)parent).getViewer();
        return viewer == null ? null : viewer.getProperties();
    }

    private PropertyChangeListener getPropertiesListener() {
        if (this.propertiesListener == null) {
            this.propertiesListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (TimelineSectionPart.this.getProperties() != null) {
                        boolean useAdvancedRenderer = TimelineSectionPart.this.getProperties().getBoolean("renderTextAsPath", false);
                        ((RotatableWrapLabel)TimelineSectionPart.this.title).setRenderStyle(useAdvancedRenderer ? 1 : 0);
                    }
                }
            };
        }
        return this.propertiesListener;
    }

    private static class TicksLayout
    extends AbstractLayout {
        private TicksLayout() {
        }

        protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
            if (wHint > -1) {
                wHint = Math.max(0, wHint - container.getInsets().getWidth());
            }
            if (hHint > -1) {
                hHint = Math.max(0, hHint - container.getInsets().getHeight());
            }
            Dimension d = new Dimension();
            List children = container.getChildren();
            int i = 0;
            while (i < children.size()) {
                IFigure child = (IFigure)children.get(i);
                if (!this.isObservingVisibility() || child.isVisible()) {
                    d.union(child.getPreferredSize(wHint, hHint));
                }
                ++i;
            }
            d.expand(container.getInsets().getWidth(), container.getInsets().getHeight());
            d.union(this.getBorderPreferredSize(container));
            return d;
        }

        public void layout(IFigure container) {
            List children = container.getChildren();
            Rectangle clientArea = container.getClientArea(AREA);
            int x = clientArea.x;
            int i = 0;
            while (i < children.size()) {
                IFigure child = (IFigure)children.get(i);
                Dimension childSize = child.getPreferredSize();
                int offset = ((IHasOffset)child).getOffset();
                Rectangle r = RECT;
                r.setLocation(x + offset, clientArea.y);
                r.setSize(childSize.width, clientArea.height);
                child.setBounds(r);
                ++i;
            }
        }
    }

    private static class TimelineLabel
    extends RotatableWrapLabel {
        private TimelineLabel() {
        }

        protected void paintText(Graphics graphics, String token, float x, float y, float width, float height, Font f) {
            super.paintText(graphics, token, x, y, width, height, f);
        }
    }

    private class TimelineSectionLayout
    extends AbstractLayout
    implements IOffsetProvider {
        private Integer offset = null;

        private TimelineSectionLayout() {
        }

        protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
            int height = GanttViewer.DEFAULT_HEADER_HEIGHT;
            DateRange dateRange = TimelineSectionPart.this.getDateRange();
            TimelineModel timeline = TimelineSectionPart.this.getTimeline();
            return new Dimension(timeline.getPixelsFromMillis(dateRange.end.getTimeInMillis() - dateRange.start.getTimeInMillis()), height);
        }

        public void layout(IFigure container) {
            boolean isExportMode;
            Rectangle clientArea = container.getClientArea(AREA);
            Rectangle r = RECT;
            Dimension size1 = TimelineSectionPart.this.title.getPreferredSize();
            r.setSize(size1);
            Rectangle clientArea2 = new Rectangle(clientArea);
            if (TimelineSectionPart.this.getTimeline().getPrecision() == 15120.0) {
                DateRange dateRange = TimelineSectionPart.this.getDateRange();
                TimelineModel timeline = TimelineSectionPart.this.getTimeline();
                Calendar end = DateRange.copyDate(dateRange.end);
                end.set(5, 1);
                clientArea2.width = timeline.getPixelsFromMillis(end.getTimeInMillis() - dateRange.start.getTimeInMillis());
            }
            if (!(isExportMode = TimelineSectionPart.this.getTimeline().isExportMode())) {
                r.setLocation(Math.max(Math.min(Math.max(clientArea2.x + 10, 10), clientArea2.x + clientArea2.width - size1.width - 10), clientArea2.x + 10), clientArea2.y + 1);
            } else {
                int exportStart = TimelineSectionPart.this.getTimeline().getExportStart();
                int dateRangeStart = this.getOffset(container);
                int dateRangeLength = TimelineSectionPart.this.getTimeline().getPixelsFromMillis(TimelineSectionPart.this.getDateRange().end.getTimeInMillis() - TimelineSectionPart.this.getDateRange().start.getTimeInMillis());
                int dateRangeEnd = dateRangeStart + dateRangeLength;
                int x = clientArea2.x + 10;
                if (exportStart > dateRangeStart && exportStart < dateRangeEnd) {
                    x = Math.max(Math.min(Math.max(exportStart + 10, 10), clientArea2.x + clientArea2.width - size1.width - 10), exportStart + 10);
                }
                r.setLocation(x, clientArea2.y + 1);
            }
            TimelineSectionPart.this.title.setBounds(r);
            r.setSize(clientArea.width, 20);
            r.setLocation(clientArea.x, GanttViewer.DEFAULT_HEADER_HEIGHT - 20);
            TimelineSectionPart.this.ticksLayer.setBounds(r);
            r.setSize(clientArea.width, ((TimelineSectionPart)TimelineSectionPart.this).majorTitleLayer.getPreferredSize().height);
            r.setLocation(clientArea.x + 5, clientArea.y + ((TimelineSectionPart)TimelineSectionPart.this).title.getPreferredSize().height + 3);
            TimelineSectionPart.this.majorTitleLayer.setBounds(r);
            TimelineSectionPart.this.tickFigure.setBounds(new Rectangle(clientArea.x, clientArea.y, 2, size1.height));
        }

        public int getOffset(IFigure container) {
            if (this.offset == null) {
                this.offset = this.calculateOffset(container);
            }
            return this.offset;
        }

        private Integer calculateOffset(IFigure container) {
            DateRange dateRange = TimelineSectionPart.this.getDateRange();
            TimelineModel timeline = TimelineSectionPart.this.getTimeline();
            int offset = timeline.getPixelsFromMillis(dateRange.start.getTimeInMillis() - timeline.getOriginDate().getTimeInMillis());
            return offset;
        }

        public boolean hasOffset(IFigure container) {
            return true;
        }

        public void invalidate() {
            super.invalidate();
            this.offset = null;
        }
    }
}

