/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.gef.command.ICommandStack;
import org.xmind.ui.dialogs.PopupFilteredList;
import org.xmind.ui.gantt2.viewer.TaskTreeEditableTracker;
import org.xmind.ui.gantt2.viewer.TaskTreeItemPart;
import org.xmind.ui.internal.taskinfo.TaskInfoUtils;
import org.xmind.ui.internal.taskinfo.TaskMessages;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MarkerImageDescriptor;
import org.xmind.ui.viewers.ImageCachedLabelProvider;
import org.xmind.ui.viewers.MComboViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskTreeProgressEditableTracker
extends TaskTreeEditableTracker {
    private static final int MARKER_HEIGHT = 16;
    private static final Object NONE = new Object();
    private List<Object> defaultProgressComboInput = null;

    public TaskTreeProgressEditableTracker(IFigure target, FigureCanvas canvas, TaskTreeItemPart host) {
        super(target, canvas, host);
    }

    @Override
    protected void edit() {
        this.editProgress();
    }

    private void editProgress() {
        MComboViewer progressCombo = this.createProgressCombo((Composite)this.canvas);
        final Control control = progressCombo.getControl();
        this.locateEditor(control, this.target, this.canvas.getViewport());
        control.forceFocus();
        progressCombo.open();
        PopupFilteredList popupList = progressCombo.getPopupList();
        if (popupList != null) {
            popupList.getShell().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    TaskTreeProgressEditableTracker.this.preCancelEditing();
                    e.display.asyncExec(new Runnable(){

                        public void run() {
                            if (control != null && !control.isDisposed()) {
                                control.dispose();
                            }
                        }
                    });
                }
            });
        }
    }

    private MComboViewer createProgressCombo(Composite parent) {
        MComboViewer progressCombo = new MComboViewer(parent, 1024);
        progressCombo.setEmptySelectionImitation((Object)this);
        progressCombo.getControl().setBackground(parent.getBackground());
        progressCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        progressCombo.setLabelProvider((IBaseLabelProvider)new ProgressComboLabelProvider());
        progressCombo.setPatternFilter((PopupFilteredList.PatternFilter)new ProgressPatternFilter());
        progressCombo.setInput(this.getDefaultProgressComboInput());
        progressCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (TaskTreeProgressEditableTracker.this.topic != null) {
                    TaskTreeProgressEditableTracker.this.changeProgressByMarker(((IStructuredSelection)event.getSelection()).getFirstElement());
                }
            }
        });
        progressCombo.setPermitsUnprovidedElement(true);
        return progressCombo;
    }

    private List<Object> getDefaultProgressComboInput() {
        if (this.defaultProgressComboInput == null) {
            IMarkerSheet sheet = MindMapUI.getResourceManager().getSystemMarkerSheet();
            this.defaultProgressComboInput = new ArrayList<Object>(sheet.findMarkerGroup("taskMakers").getMarkers());
            this.defaultProgressComboInput.remove(sheet.findMarker("task-pause"));
            this.defaultProgressComboInput.add(0, NONE);
        }
        return this.defaultProgressComboInput;
    }

    private void changeProgressByMarker(Object selection) {
        if (selection == NONE) {
            this.deleteProgress();
        } else if (selection instanceof IMarker) {
            if (this.getCommandStack() == null || this.topic == null) {
                return;
            }
            IMarker marker = (IMarker)selection;
            String markerId = marker.getId();
            int percentage = TaskInfoUtils.getPercentage((String)markerId);
            this.changeProgress(percentage, marker);
        } else {
            this.changeProgressByPercentage(selection);
        }
    }

    private void changeProgressByPercentage(Object selection) {
        if (selection instanceof String) {
            String string = (String)selection;
            int i = string.indexOf(37);
            if (i >= 0) {
                string = string.substring(0, i);
            }
            string = string.trim();
            try {
                int percentage = Integer.parseInt(string);
                this.changeProgress(percentage);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (selection instanceof Integer) {
            this.changeProgress((Integer)selection);
        }
    }

    private void changeProgress(int value) {
        this.changeProgress(value, TaskInfoUtils.findPercentageMarker((int)value, (boolean)true));
    }

    private void changeProgress(int value, IMarker marker) {
        TaskInfoUtils.changeProgress((ITopic)this.topic, (ICommandStack)this.getCommandStack(), (int)value, (IMarker)marker);
    }

    private void deleteProgress() {
        TaskInfoUtils.deleteProgress((ITopic)this.topic, (ICommandStack)this.getCommandStack());
    }

    private class MarkerLabelProvider
    extends ImageCachedLabelProvider {
        private MarkerLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IMarker) {
                ISheet sheet;
                if (TaskTreeProgressEditableTracker.this.topic != null && (sheet = TaskTreeProgressEditableTracker.this.topic.getOwnedSheet()) != null) {
                    return sheet.getLegend().getMarkerDescription(((IMarker)element).getId());
                }
                return ((IMarker)element).getName();
            }
            return super.getText(element);
        }

        protected Image createImage(Object element) {
            if (element instanceof IMarker) {
                return MarkerImageDescriptor.createFromMarker((IMarker)((IMarker)element), (int)16, (int)16).createImage(false);
            }
            return null;
        }
    }

    private class ProgressComboLabelProvider
    extends MarkerLabelProvider
    implements IColorProvider {
        private ProgressComboLabelProvider() {
        }

        public String getText(Object element) {
            if (element == NONE) {
                return TaskMessages.NoneProgress_text;
            }
            if (element == TaskTreeProgressEditableTracker.this) {
                return TaskMessages.EnterProgress_text;
            }
            if (element instanceof IMarker) {
                String text = super.getText(element);
                int percentage = TaskInfoUtils.getPercentage((String)((IMarker)element).getId());
                return NLS.bind((String)"{0} - {1}%", (Object)text, (Object)percentage);
            }
            return super.getText(element);
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            if (element == TaskTreeProgressEditableTracker.this) {
                return invalidColor;
            }
            return validColor;
        }
    }

    private class ProgressPatternFilter
    extends PopupFilteredList.PatternFilter {
        private ProgressPatternFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            String pattern = this.getPatternText();
            if (pattern != null) {
                int index = pattern.indexOf(37);
                if (index >= 0) {
                    pattern = pattern.substring(0, index);
                }
                pattern = pattern.trim();
                int percentage = -1;
                try {
                    percentage = Integer.parseInt(pattern);
                }
                catch (NumberFormatException numberFormatException) {}
                if (percentage >= 0 && percentage <= 100 && element instanceof IMarker) {
                    String id = ((IMarker)element).getId();
                    return id.equals(TaskInfoUtils.getPercentageMarkerId((int)percentage, (boolean)true));
                }
            }
            return super.select(viewer, parentElement, element);
        }
    }
}

