/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.ui.gantt2.gefext.IConnection;
import org.xmind.ui.gantt2.gefext.IConnectionRouter;
import org.xmind.ui.gantt2.gefext.IPathShape;
import org.xmind.ui.gantt2.gefext.PathDescriptor;
import org.xmind.ui.gantt2.viewer.DependencyFigure;

public class DependencyPathRouter
implements IConnectionRouter {
    private static final int EXPANSION = 9;
    private static final int HALF_BAR_HEIGHT = 9;

    public void route(IConnection connection) {
        if (!(connection instanceof IPathShape)) {
            return;
        }
        PathDescriptor path = new PathDescriptor();
        this.getPoints(connection, path);
        if (path.isEmpty()) {
            path.moveTo(0.0, 0.0);
            path.lineTo(0.0, 0.0);
        }
        ((IPathShape)((Object)connection)).setOutlinePath(path);
    }

    private void getPoints(IConnection connection, PathDescriptor path) {
        DependencyFigure figure = (DependencyFigure)connection;
        if (figure.getSourceAnchor() == null || figure.getTargetAnchor() == null) {
            return;
        }
        int sourceOrientation = figure.getSourceOrientation();
        int targetOrientation = figure.getTargetOrientation();
        if (sourceOrientation == 0 || targetOrientation == 0) {
            return;
        }
        PrecisionPoint sourceLocation = figure.getSourceAnchor().getLocation(sourceOrientation, 0.0);
        PrecisionPoint targetLocation = figure.getTargetAnchor().getLocation(targetOrientation, 0.0);
        path.moveTo(sourceLocation);
        sourceLocation.x = sourceOrientation == 16 ? (sourceLocation.x += 9.0) : (sourceLocation.x -= 9.0);
        double targetX = targetOrientation == 16 ? targetLocation.x + 9.0 : targetLocation.x - 9.0;
        if (sourceOrientation == targetOrientation) {
            sourceLocation.x = sourceOrientation == 16 ? Math.max(sourceLocation.x, targetX) : Math.min(sourceLocation.x, targetX);
        } else if (sourceOrientation == 16 && sourceLocation.x > targetX || sourceOrientation == 8 && sourceLocation.x < targetX) {
            path.lineTo(sourceLocation);
            sourceLocation.y = targetLocation.y > sourceLocation.y ? (sourceLocation.y += 9.0) : (sourceLocation.y -= 9.0);
            path.lineTo(sourceLocation);
            sourceLocation.x = targetX;
        } else {
            sourceLocation.x = (sourceLocation.x + targetX) * 0.5;
        }
        path.lineTo(sourceLocation);
        sourceLocation.y = targetLocation.y;
        path.lineTo(sourceLocation);
        path.lineTo(targetLocation);
    }

    public void invalidate(IConnection connection) {
    }
}

