/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.gef.ILayerManager;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IRootPart;
import org.xmind.ui.gantt2.gefext.ConnectionManager;
import org.xmind.ui.gantt2.gefext.IConnection;
import org.xmind.ui.gantt2.gefext.IConnectionRouter;
import org.xmind.ui.gantt2.viewer.TaskBarViewer;
import org.xmind.ui.mindmap.IConnectionPart;
import org.xmind.ui.mindmap.IMindMap;

public class DependencyConnectionManager
extends ConnectionManager {
    private IConnectionRouter connectionRouter;

    public DependencyConnectionManager(IPart parent, ILayerManager layerManager, IConnectionRouter connectionRouter) {
        super(parent, layerManager);
        this.connectionRouter = connectionRouter;
    }

    protected Layer getConnectionLayer(IConnectionPart connection) {
        return this.getLayer(TaskBarViewer.LAYER_DEPENDENCIES);
    }

    private IWorkbook getWorkbook() {
        IMindMap mindmap;
        ISheet sheet;
        ITopic topic;
        IRootPart root = this.getParent().getSite().getRoot();
        IWorkbook workbook = (IWorkbook)root.getAdapter(IWorkbook.class);
        if (workbook == null && (topic = (ITopic)root.getAdapter(ITopic.class)) != null) {
            workbook = topic.getOwnedWorkbook();
        }
        if (workbook == null && (sheet = (ISheet)root.getAdapter(ISheet.class)) != null) {
            workbook = sheet.getOwnedWorkbook();
        }
        if (workbook == null && (mindmap = (IMindMap)root.getAdapter(IMindMap.class)) != null) {
            workbook = mindmap.getSheet().getOwnedWorkbook();
        }
        return workbook;
    }

    protected IPart findPart(Object model) {
        IWorkbook workbook;
        if (model instanceof String && (workbook = this.getWorkbook()) != null) {
            model = workbook.getElementById((String)model);
        }
        return super.findPart(model);
    }

    protected void addConnectionView(IConnectionPart connection) {
        super.addConnectionView(connection);
        IFigure figure = connection.getFigure();
        if (figure instanceof IConnection) {
            ((IConnection)figure).setConnectionRouter(this.connectionRouter);
        }
    }

    protected void removeConnectionView(IConnectionPart connection) {
        IFigure figure = connection.getFigure();
        if (figure instanceof IConnection) {
            ((IConnection)figure).setConnectionRouter(null);
        }
        super.removeConnectionView(connection);
    }
}

