/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt.export;

import org.xmind.ui.gantt2.viewer.GanttViewer;
import org.xmind.ui.gantt2.viewer.TaskTreeItemPart;
import org.xmind.ui.gantt2.viewer.TaskTreeWidthsSupport;

public class ExportConstants {
    public static final String TASK_BETWEEN = "timeRange";
    public static final String START_TIME = "startTime";
    public static final String END_TIME = "endTime";
    public static final String ORIENTATION = "orientation";
    public static final String LEFT_MARGIN = "leftMargin";
    public static final String RIGHT_MARGIN = "rightMargin";
    public static final String TOP_MARGIN = "topMargin";
    public static final String BOTTOM_MARGIN = "bottomMargin";
    public static final String WIDTH_PAGES = "widthPages";
    public static final String HEIGHT_PAGES = "heightPages";
    public static final String FILL_HEIGHT = "fillHeight";
    public static final String ASPECT_RATIO_LOCKED = "aspectRatioLocked";
    public static final String HEADER_TEXT = "headerText";
    public static final String HEADER_ALIGN = "headerAlign";
    public static final String HEADER_FONT = "headerFont";
    public static final String FOOTER_TEXT = "footerText";
    public static final String FOOTER_ALIGN = "footerAlign";
    public static final String FOOTER_FONT = "footerFont";
    public static final String LEFT = "left";
    public static final String CENTER = "center";
    public static final String RIGHT = "right";
    public static final String NO_BORDER = "noBorder";
    public static final String NO_PAGE_NUMBER = "noPageNumber";
    public static final String IN_BLACK_AND_WHITE = "inBlackAndWhite";
    public static final int DEFAULT_ORIENTATION = 2;
    public static final double DEFAULT_MARGIN = 0.25;
    public static final int DEFAULT_WIDTH_PAGES = 1;
    public static final int DEFAULT_HEIGHT_PAGES = 1;
    public static final String DEFAULT_HEADER_ALIGN = "center";
    public static final String DEFAULT_FOOTER_ALIGN = "right";
    public static final String DEFAULT_HEADER_TEXT = "";
    public static final String DEFAULT_FOOTER_TEXT = "";
    public static final int DEFAULT_DPI = 120;
    public static final int PAGE_SHORT = 992;
    public static final int PAGE_LENGTH = 1403;
    public static final int HEADER_HEIGHT = GanttViewer.DEFAULT_HEADER_HEIGHT;
    public static final int ITEM_HEIGHT = TaskTreeItemPart.HEIGHT + 7;
    public static final int TASK_BAR_EXTRA_WIDTH_IN_PIXEL = 50;
    public static final int MAX_IMAGE_SIZE = 100000000;

    public static int toDraw2DAlignment(String alignValue, int defaultAlignment) {
        if (LEFT.equals(alignValue)) {
            return 1;
        }
        if ("center".equals(alignValue)) {
            return 2;
        }
        if ("right".equals(alignValue)) {
            return 4;
        }
        return defaultAlignment;
    }

    public static int toPixel(double inch) {
        return (int)(inch * 120.0);
    }

    public static int round(int width, TaskTreeWidthsSupport widthsSupport) {
        if (width <= widthsSupport.sum(0)) {
            return widthsSupport.sum(0);
        }
        int i = 0;
        while (i < widthsSupport.getSize() - 1) {
            if (width <= widthsSupport.sum(i + 1)) {
                int mid = (widthsSupport.sum(i) + widthsSupport.sum(i + 1)) / 2;
                width = width < mid ? widthsSupport.sum(i) : widthsSupport.sum(i + 1);
                return width;
            }
            ++i;
        }
        return widthsSupport.sum();
    }
}

