/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spreadsheet.structures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.draw2d.geometry.Point;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.ui.branch.BranchStructureData;
import org.xmind.ui.internal.spreadsheet.structures.Cell2;
import org.xmind.ui.internal.spreadsheet.structures.Column2;
import org.xmind.ui.internal.spreadsheet.structures.Item2;
import org.xmind.ui.internal.spreadsheet.structures.Row2;
import org.xmind.ui.internal.spreadsheet.structures.RowHead;
import org.xmind.ui.internal.spreadsheet.structures.RowOrder;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IInfoPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.style.StyleUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chart2
extends BranchStructureData {
    private List<Column2> cols = null;
    private List<Row2> rows = null;
    private int titleAreaHeight = -1;
    private int colHeadHeight = -1;
    private int rowHeadWidth = -1;
    private int lineWidth = -1;
    private RowOrder prefRowOrder = null;

    public Chart2(IBranchPart branch) {
        super(branch);
    }

    void setContent(Column2 col, Row2 ... row) {
        this.cols = Collections.singletonList(col);
        this.rows = Arrays.asList(row);
    }

    void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public IBranchPart getTitle() {
        return super.getBranch();
    }

    public List<Row2> getRows() {
        this.ensureBuilt();
        return this.rows;
    }

    public List<Column2> getColumns() {
        this.ensureBuilt();
        return this.cols;
    }

    public boolean hasRows() {
        return !this.getRows().isEmpty();
    }

    public boolean hasColumns() {
        return !this.getColumns().isEmpty();
    }

    public int getNumRows() {
        return this.getRows().size();
    }

    public int getNumColumns() {
        return this.getColumns().size();
    }

    public int getNumValidRows() {
        int num = 0;
        for (Row2 row : this.getRows()) {
            if (RowHead.EMPTY.equals(row.getHead()) || row.getCells().isEmpty()) continue;
            ++num;
        }
        return num;
    }

    public Row2 getFirstRow() {
        return this.getRow(0);
    }

    public Row2 getRow(int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.getRows().size()) {
            return null;
        }
        return this.getRows().get(rowIndex);
    }

    public Column2 getColumn(int colIndex) {
        if (colIndex < 0 || colIndex >= this.getColumns().size()) {
            return null;
        }
        return this.getColumns().get(colIndex);
    }

    private void ensureBuilt() {
        if (this.rows != null && this.cols != null) {
            return;
        }
        this.rows = null;
        this.cols = null;
        this.lazyBuild();
        if (this.cols == null) {
            this.cols = Collections.emptyList();
        }
        if (this.rows == null) {
            this.rows = Collections.emptyList();
        }
    }

    private void lazyBuild() {
        if (this.getTitle() == null) {
            return;
        }
        HashMap<Column2, ArrayList<Item2>> colItems = null;
        HashMap<Row2, ArrayList<Item2>> rowItems = null;
        ArrayList<Row2> rows2 = new ArrayList<Row2>();
        for (IBranchPart colHead : this.getTitle().getSubBranches()) {
            ArrayList<Item2> items = new ArrayList<Item2>();
            Column2 col = this.buildCol(colHead, items);
            if (items.isEmpty()) continue;
            if (colItems == null) {
                colItems = new HashMap<Column2, ArrayList<Item2>>();
            }
            colItems.put(col, items);
            for (Item2 item : items) {
                ArrayList<Item2> list;
                Row2 row;
                RowHead prefHead = item.getPrefRowHead();
                if (prefHead == null) continue;
                Row2 row2 = row = rowItems == null ? null : this.findRow(rowItems.keySet(), prefHead);
                if (row == null) {
                    row = new Row2(this, prefHead);
                    rows2.add(row);
                    list = new ArrayList();
                    list.add(item);
                    if (rowItems == null) {
                        rowItems = new HashMap<Row2, ArrayList<Item2>>();
                    }
                    rowItems.put(row, list);
                    continue;
                }
                list = (ArrayList<Item2>)rowItems.get(row);
                if (list == null) {
                    list = new ArrayList<Item2>();
                    rowItems.put(row, list);
                }
                list.add(item);
            }
        }
        int i = 0;
        while (i < rows2.size()) {
            ((Row2)rows2.get(i)).getHead().setIndex(i);
            ++i;
        }
        if (rowItems != null) {
            this.rows = new ArrayList(new TreeSet(rowItems.keySet()));
        }
        this.buildCells(colItems, rowItems);
    }

    private void buildCells(Map<Column2, List<Item2>> colItems, Map<Row2, List<Item2>> rowItems) {
        if (this.rows == null || this.cols == null) {
            return;
        }
        for (Column2 col : this.cols) {
            for (Row2 row : this.rows) {
                this.buildCell(col, row, colItems, rowItems);
            }
        }
    }

    private void buildCell(Column2 col, Row2 row, Map<Column2, List<Item2>> colItems, Map<Row2, List<Item2>> rowItems) {
        List<Item2> rItems;
        Cell2 cell = new Cell2(this, col, row);
        col.addCell(cell);
        row.addCell(cell);
        List<Item2> cItems = colItems == null ? null : colItems.get((Object)col);
        List<Item2> list = rItems = rowItems == null ? null : rowItems.get(row);
        if (cItems != null && rItems != null) {
            for (Item2 item : rItems) {
                if (!cItems.contains((Object)item)) continue;
                cell.addItem(item);
            }
        }
    }

    private Row2 findRow(Collection<Row2> rows, RowHead rowHead) {
        for (Row2 row : rows) {
            if (!rowHead.equals(row.getHead())) continue;
            return row;
        }
        return null;
    }

    private Column2 buildCol(IBranchPart colHead, List<Item2> colItems) {
        Column2 col = new Column2(colHead, this);
        if (this.cols == null) {
            this.cols = new ArrayList<Column2>();
        }
        this.cols.add(col);
        for (IBranchPart child : colHead.getSubBranches()) {
            Item2 item = new Item2(this, child);
            colItems.add(item);
        }
        return col;
    }

    public int getTitleAreaHeight() {
        if (this.titleAreaHeight < 0) {
            this.titleAreaHeight = this.calcTitleAreaHeight();
        }
        return this.titleAreaHeight;
    }

    private int calcTitleAreaHeight() {
        int h = 0;
        int y = this.getBranch().getFigure().getBounds().y;
        IInfoPart info = this.getBranch().getInfoPart();
        if (info != null && info.getFigure().isVisible()) {
            h = info.getFigure().getBounds().bottom() - y;
        } else {
            ITopicPart topicPart = this.getBranch().getTopicPart();
            if (topicPart != null && topicPart.getFigure().isVisible()) {
                h = topicPart.getFigure().getBounds().bottom() - y;
            }
        }
        return h;
    }

    public int getColHeadHeight() {
        if (this.colHeadHeight < 0) {
            this.colHeadHeight = this.calcColHeadHeight();
        }
        return this.colHeadHeight;
    }

    private int calcColHeadHeight() {
        int maxTopicHeight = 0;
        int maxInfoHeight = 0;
        for (Column2 col : this.getColumns()) {
            IInfoPart infoPart;
            IBranchPart head = col.getHead();
            ITopicPart topicPart = head.getTopicPart();
            if (topicPart != null) {
                maxTopicHeight = Math.max(maxTopicHeight, topicPart.getFigure().getBounds().height);
            }
            if ((infoPart = head.getInfoPart()) == null) continue;
            maxInfoHeight = Math.max(maxInfoHeight, infoPart.getFigure().getBounds().height);
        }
        return maxTopicHeight + maxInfoHeight;
    }

    public int getRowHeadWidth() {
        if (this.rowHeadWidth < 0) {
            this.rowHeadWidth = this.calcRowHeadWidth();
        }
        return this.rowHeadWidth;
    }

    private int calcRowHeadWidth() {
        int sum = 0;
        for (Row2 row : this.getRows()) {
            sum = Math.max(sum, row.getHead().getPrefSize().width);
        }
        return sum;
    }

    public int getLineWidth() {
        if (this.lineWidth < 0) {
            IStyleSelector ss = StyleUtils.getStyleSelector((IGraphicalPart)this.getBranch());
            String decorationId = StyleUtils.getString((IGraphicalPart)this.getBranch(), (IStyleSelector)ss, (String)"shape-class", null);
            this.lineWidth = StyleUtils.getInteger((IGraphicalPart)this.getBranch(), (IStyleSelector)ss, (String)"line-width", (String)decorationId, (int)1);
        }
        return this.lineWidth;
    }

    public int getMajorSpacing() {
        if (this.getBranch() == null) {
            return 5;
        }
        return super.getMajorSpacing();
    }

    public int getMinorSpacing() {
        if (this.getBranch() == null) {
            return 1;
        }
        return super.getMinorSpacing();
    }

    public Column2 getPreviousColumn(Column2 col) {
        int index = this.getColumnIndex(col);
        if (index > 0) {
            return this.getColumns().get(index - 1);
        }
        return null;
    }

    public Column2 getNextColumn(Column2 col) {
        int index = this.getColumnIndex(col);
        if (index < this.getColumns().size() - 1) {
            return this.getColumns().get(index + 1);
        }
        return null;
    }

    public int getRowIndex(Row2 row) {
        return this.getRows().indexOf(row);
    }

    public Row2 getPreviousRow(Row2 row) {
        int index = this.getRowIndex(row);
        if (index > 0) {
            return this.getRows().get(index - 1);
        }
        return null;
    }

    public Row2 getNextRow(Row2 row) {
        int index = this.getRowIndex(row);
        if (index < this.getRows().size() - 1) {
            return this.getRows().get(index + 1);
        }
        return null;
    }

    public int getColumnIndex(Column2 col) {
        return this.getColumns().indexOf((Object)col);
    }

    public Cell2 findCell(Point point) {
        for (Column2 col : this.getColumns()) {
            for (Cell2 cell : col.getCells()) {
                if (!cell.getBounds().contains(point)) continue;
                return cell;
            }
        }
        return null;
    }

    public RowHead findRowHead(Point point) {
        int x;
        if (this.hasRows() && point.x > (x = this.getTitle().getTopicPart().getFigure().getBounds().x - this.getMajorSpacing()) && point.x < x + this.getRowHeadWidth() + this.getMajorSpacing() * 2) {
            for (Row2 row : this.getRows()) {
                int y = row.getTop();
                if (point.y <= y || point.y >= y + row.getHeight()) continue;
                return row.getHead();
            }
        }
        return null;
    }

    public Row2 findRow(RowHead colHead) {
        for (Row2 row : this.getRows()) {
            if (!row.getHead().equals(colHead)) continue;
            return row;
        }
        return null;
    }

    public RowOrder getPrefRowOrder() {
        if (this.prefRowOrder == null) {
            this.prefRowOrder = RowOrder.createFromTopic(this.getTitle().getTopic());
        }
        return this.prefRowOrder;
    }
}

