/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.sharing;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.coobird.thumbnailator.Thumbnails;
import org.eclipse.core.runtime.Platform;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xmind.core.internal.sharing.AbstractSharedMap;
import org.xmind.core.internal.sharing.Base64;
import org.xmind.core.internal.sharing.DOMUtils;
import org.xmind.core.internal.sharing.LocalNetworkSharing;
import org.xmind.core.internal.sharing.LocalNetworkSharingService;
import org.xmind.core.internal.sharing.LocalSharedMap;
import org.xmind.core.sharing.ILocalSharedLibrary;
import org.xmind.core.sharing.ISharedMap;
import org.xmind.core.sharing.ISharingService;
import org.xmind.core.sharing.SharingEvent;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalSharedLibrary
implements ILocalSharedLibrary {
    private static final String FILE_SHARED_MAPS = "shared_maps.xml";
    private static final String TAG_SHARED_MAPS = "shared-maps";
    private static final String TAG_NAME = "name";
    private static final String TAG_MAPS = "maps";
    private static final String TAG_MAP = "map";
    private static final String TAG_THUMBNAIL = "thumbnail";
    private static final String TAG_RECEIVERS = "receivers";
    private static final String TAG_RECEIVER = "receiver";
    private static final String ATT_ID = "id";
    private static final String ATT_RESOURCE = "resource";
    private static final String ATT_MODIFIED_TIME = "modified-time";
    private static final String ATT_ADDED_TIME = "added-time";
    private static final String XMIND_2014_THUMBNAIL = "images/thumbnail.png";
    private static boolean DEBUGGING = LocalNetworkSharing.isDebugging("/debug");
    private LocalNetworkSharingService service;
    private String defaultName = System.getProperty("user.name");
    private String name = null;
    private String contactId = null;
    private List<ISharedMap> maps = new ArrayList<ISharedMap>();
    private Thread monitorThread = null;
    private File metaFile = null;
    private String encodedXMind2014Thumbnail = null;

    public LocalSharedLibrary(LocalNetworkSharingService service) {
        this.service = service;
        this.load();
        this.runMonitor();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ISharingService.class) {
            return this.service;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public void dispose() {
        Thread t = this.monitorThread;
        this.monitorThread = null;
        if (t != null) {
            t.interrupt();
        }
    }

    private DocumentBuilder getDocumentBuilder() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setAttribute("http://apache.org/xml/features/continue-after-fatal-error", true);
        }
        catch (Exception exception) {}
        try {
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (Exception exception) {}
        try {
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (Exception exception) {}
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        }
        catch (Exception exception) {}
        factory.setXIncludeAware(false);
        factory.setExpandEntityReferences(false);
        factory.setNamespaceAware(true);
        factory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        documentBuilder.setErrorHandler(new ErrorHandler(){

            public void warning(SAXParseException exception) throws SAXException {
            }

            public void fatalError(SAXParseException exception) throws SAXException {
            }

            public void error(SAXParseException exception) throws SAXException {
            }
        });
        return documentBuilder;
    }

    private void load() {
        block19: {
            long start = System.currentTimeMillis();
            try {
                File metaFile = this.getMetaFile();
                if (!metaFile.exists()) {
                    return;
                }
                try {
                    Element[] mapElements;
                    Element mapsElement;
                    Document doc = this.getDocumentBuilder().parse(metaFile);
                    Element root = doc.getDocumentElement();
                    Element nameElement = DOMUtils.getFirstChildElementByTag(root, TAG_NAME);
                    if (nameElement != null) {
                        this.name = nameElement.getTextContent();
                    }
                    if ((mapsElement = DOMUtils.getFirstChildElementByTag(root, TAG_MAPS)) == null) break block19;
                    Element[] elementArray = mapElements = DOMUtils.childElementArrayByTag(mapsElement, TAG_MAP);
                    int n = mapElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Element thumbnailElement;
                        String addedTime;
                        Element mapElement = elementArray[n2];
                        LocalSharedMap map = new LocalSharedMap(this, mapElement.getAttribute(ATT_ID));
                        map.setResourcePath(mapElement.getAttribute(ATT_RESOURCE));
                        String modifiedTime = mapElement.getAttribute(ATT_MODIFIED_TIME);
                        if (modifiedTime != null && !"".equals(modifiedTime)) {
                            try {
                                map.setResourceModifiedTime(Long.parseLong(modifiedTime, 10));
                            }
                            catch (NumberFormatException e) {
                                LocalNetworkSharing.log("Invalid 'modified-time': " + modifiedTime, e);
                            }
                        }
                        if ((addedTime = mapElement.getAttribute(ATT_ADDED_TIME)) != null && !"".equals(addedTime)) {
                            try {
                                map.setAddedTime(Long.parseLong(addedTime, 10));
                            }
                            catch (NumberFormatException e) {
                                LocalNetworkSharing.log("Invalid 'added-time': " + addedTime, e);
                            }
                        }
                        map.setEncodedThumbnailData((thumbnailElement = DOMUtils.getFirstChildElementByTag(mapElement, TAG_THUMBNAIL)) == null ? null : thumbnailElement.getTextContent());
                        Element receiverIDsEle = DOMUtils.getFirstChildElementByTag(mapElement, TAG_RECEIVERS);
                        if (receiverIDsEle != null) {
                            Element[] receiverIdEles;
                            Element[] elementArray2 = receiverIdEles = DOMUtils.childElementArrayByTag(receiverIDsEle, TAG_RECEIVER);
                            int n3 = receiverIdEles.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                Element receiverIdElement = elementArray2[n4];
                                String id = receiverIdElement.getAttribute(ATT_ID);
                                if (id != null && !"".equals(id)) {
                                    map.addReceiver(id);
                                }
                                ++n4;
                            }
                        }
                        this.maps.add(map);
                        ++n2;
                    }
                }
                catch (Throwable e) {
                    LocalNetworkSharing.log("Error occurred while loading local shared library info.", e);
                }
            }
            finally {
                long end = System.currentTimeMillis();
                if (DEBUGGING) {
                    System.out.println("Local shared library loaded: " + (end - start) + " ms");
                }
            }
        }
    }

    private File getMetaFile() {
        if (this.metaFile == null) {
            this.metaFile = new File(LocalNetworkSharing.getDefault().getDataDirectory(), FILE_SHARED_MAPS);
        }
        return this.metaFile;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public synchronized ISharedMap[] getMaps() {
        return this.maps.toArray(new ISharedMap[this.maps.size()]);
    }

    @Override
    public boolean hasMaps() {
        return !this.maps.isEmpty();
    }

    @Override
    public int getMapCount() {
        return this.maps.size();
    }

    @Override
    public ISharedMap findMapByID(String resourceID) {
        if (resourceID != null) {
            for (ISharedMap map : this.maps) {
                if (!resourceID.equals(map.getID())) continue;
                return map;
            }
        }
        return null;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return this.defaultName;
        }
        return this.name;
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    public String getLocalName() {
        return this.name;
    }

    @Override
    public String getContactID() {
        if (this.contactId == null) {
            this.contactId = this.service.getContactManager().getMyselfContact().getID();
        }
        return this.contactId;
    }

    public void setDefaultName(String name) {
        assert (name != null);
        this.defaultName = name;
    }

    @Override
    public void setName(String name) {
        if (name == null || name.equals(this.name)) {
            return;
        }
        this.name = name;
        this.save();
        this.service.fireSharingEvent(new SharingEvent(SharingEvent.Type.LIBRARY_NAME_CHANGED, this));
    }

    @Override
    public synchronized ISharedMap addSharedMap(File file) {
        return this.addSharedMap(file, Collections.<String>emptyList());
    }

    @Override
    public synchronized ISharedMap addSharedMap(File file, List<String> receivers) {
        String resourcePath = file.getAbsolutePath();
        LocalSharedMap map = null;
        for (ISharedMap m : this.maps) {
            if (!resourcePath.equals(((LocalSharedMap)m).getResourcePath())) continue;
            this.removeSharedMap(m);
            map = (LocalSharedMap)m;
            map.getReceiverIDs().clear();
            map.addReceivers(receivers);
            break;
        }
        if (map == null) {
            map = new LocalSharedMap(this, UUID.randomUUID().toString());
            map.setResourcePath(resourcePath);
            map.setAddedTime(System.currentTimeMillis());
            for (String receiver : receivers) {
                map.addReceiver(receiver);
            }
        }
        this.maps.add(map);
        Collections.sort(this.maps, AbstractSharedMap.MAP_COMPARATOR);
        this.checkMap(map);
        this.save();
        this.service.fireSharingEvent(new SharingEvent(SharingEvent.Type.SHARED_MAP_ADDED, this, map));
        return map;
    }

    /*
     * Exception decompiling
     */
    private byte[] createThumbnailData(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 8[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private byte[] createThumbnailData(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream(4096);
        Thumbnails.of((InputStream[])new InputStream[]{input}).size(200, 120).outputFormat("jpeg").outputQuality(1.0f).toOutputStream((OutputStream)output);
        return output.toByteArray();
    }

    @Override
    public synchronized boolean removeSharedMap(ISharedMap map) {
        if (this.maps.remove(map)) {
            this.save();
            this.service.fireSharingEvent(new SharingEvent(SharingEvent.Type.SHARED_MAP_REMOVED, this, map));
            return true;
        }
        return false;
    }

    private synchronized void save() {
        long start = System.currentTimeMillis();
        try {
            try {
                Document doc = this.getDocumentBuilder().newDocument();
                Element root = DOMUtils.createElement(doc, TAG_SHARED_MAPS);
                Element nameElement = DOMUtils.createElement(root, TAG_NAME);
                nameElement.setTextContent(this.getName());
                Element mapsElement = DOMUtils.createElement(root, TAG_MAPS);
                for (ISharedMap map : this.maps) {
                    List<String> receiverIds;
                    Element mapElement = DOMUtils.createElement(mapsElement, TAG_MAP);
                    LocalSharedMap localMap = (LocalSharedMap)map;
                    mapElement.setAttribute(ATT_ID, localMap.getID());
                    mapElement.setAttribute(ATT_RESOURCE, localMap.getResourcePath());
                    mapElement.setAttribute(ATT_MODIFIED_TIME, Long.toString(localMap.getResourceModifiedTime(), 10));
                    mapElement.setAttribute(ATT_ADDED_TIME, Long.toString(localMap.getAddedTime(), 10));
                    String thumbnailData = localMap.getEncodedThumbnailData();
                    if (thumbnailData != null) {
                        Element thumbnailElement = DOMUtils.createElement(mapElement, TAG_THUMBNAIL);
                        thumbnailElement.setTextContent(thumbnailData);
                    }
                    if ((receiverIds = localMap.getReceiverIDs()).isEmpty()) continue;
                    Element receiversElement = DOMUtils.createElement(mapElement, TAG_RECEIVERS);
                    for (String id : receiverIds) {
                        Element receiverElement = DOMUtils.createElement(receiversElement, TAG_RECEIVER);
                        receiverElement.setAttribute(ATT_ID, id);
                    }
                }
                File metaFile = this.getMetaFile();
                metaFile.getParentFile().mkdirs();
                FileOutputStream output = new FileOutputStream(metaFile);
                try {
                    DOMUtils.save(doc, output, true);
                }
                finally {
                    output.close();
                }
            }
            catch (Throwable e) {
                LocalNetworkSharing.log("Error occurred while saving local shared library info.", e);
                long end = System.currentTimeMillis();
                if (DEBUGGING) {
                    System.out.println("Local shared library saved: " + (end - start) + " ms");
                }
            }
        }
        finally {
            long end = System.currentTimeMillis();
            if (DEBUGGING) {
                System.out.println("Local shared library saved: " + (end - start) + " ms");
            }
        }
    }

    private void runMonitor() {
        Thread t = new Thread(new Runnable(){

            public void run() {
                LocalSharedLibrary.this.monitorLoop();
            }
        });
        t.setDaemon(true);
        t.setPriority(1);
        this.monitorThread = t;
        t.start();
        if (DEBUGGING) {
            System.out.println("Local shared maps monitor started.");
        }
    }

    private void monitorLoop() {
        try {
            try {
                while (this.monitorThread != null) {
                    Thread.sleep(5000L);
                    if (this.monitorThread == null) {
                        break;
                    }
                    this.check();
                }
            }
            catch (InterruptedException interruptedException) {
                if (DEBUGGING) {
                    System.out.println("Local shared maps monitor stopped.");
                }
            }
        }
        finally {
            if (DEBUGGING) {
                System.out.println("Local shared maps monitor stopped.");
            }
        }
    }

    private synchronized void check() {
        ArrayList<ISharedMap> modifiedMaps = null;
        for (ISharedMap map : this.maps) {
            boolean modified = this.checkMap((LocalSharedMap)map);
            if (!modified) continue;
            if (modifiedMaps == null) {
                modifiedMaps = new ArrayList<ISharedMap>(this.maps.size());
            }
            modifiedMaps.add(map);
        }
        if (modifiedMaps != null && !modifiedMaps.isEmpty()) {
            this.save();
            for (ISharedMap map : modifiedMaps) {
                this.service.fireSharingEvent(new SharingEvent(SharingEvent.Type.SHARED_MAP_UPDATED, this, map));
            }
        }
    }

    private boolean checkMap(LocalSharedMap map) {
        long newModifiedTime;
        boolean newMissing;
        String path = map.getResourcePath();
        boolean oldMissing = map.isMissing();
        long oldModifiedTime = map.getResourceModifiedTime();
        boolean modified = false;
        File file = new File(path);
        boolean bl = newMissing = !file.exists();
        if (oldMissing != newMissing) {
            if (DEBUGGING) {
                System.out.println("Local shared map " + (newMissing ? "is missing: " : "is found: ") + path);
            }
            map.setMissing(newMissing);
            modified = true;
        }
        if (oldModifiedTime < (newModifiedTime = file.lastModified())) {
            if (DEBUGGING) {
                System.out.println("Local shared map is modified: " + path);
            }
            map.setResourceModifiedTime(newModifiedTime);
            map.setThumbnailData(this.createThumbnailData(file));
            modified = true;
        }
        return modified;
    }

    @Override
    public void sortMaps(Comparator<ISharedMap> c) {
        Collections.sort(this.maps, c);
    }

    public String getEncodedXMind2014Thumbnail() {
        if (this.encodedXMind2014Thumbnail == null) {
            byte[] thumbnail = this.createXMind2014Thumbnail();
            this.encodedXMind2014Thumbnail = Base64.byteArrayToBase64(thumbnail);
        }
        return this.encodedXMind2014Thumbnail;
    }

    private byte[] createXMind2014Thumbnail() {
        URL url = Platform.getBundle((String)"org.xmind.core.sharing.localnetwork").getEntry(XMIND_2014_THUMBNAIL);
        if (url != null) {
            try {
                InputStream input = url.openStream();
                ByteArrayOutputStream output = new ByteArrayOutputStream(4096);
                byte[] buff = new byte[4096];
                int len = 0;
                while ((len = input.read(buff, 0, buff.length)) > 0) {
                    output.write(buff, 0, len);
                }
                return output.toByteArray();
            }
            catch (IOException e) {
                LocalNetworkSharing.log("Create XMind 2014 thumbnail failed: ", e);
            }
        }
        return new byte[0];
    }
}

