/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.texteditor;

import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.xmind.gef.GraphicalViewer;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IZoomListener;
import org.xmind.gef.ZoomManager;
import org.xmind.gef.ZoomObject;
import org.xmind.ui.texteditor.FloatingTextEditor;
import org.xmind.ui.texteditor.IFloatingTextEditorListener;
import org.xmind.ui.texteditor.TextEvent;

public abstract class FloatingTextEditorHelperBase
implements IFloatingTextEditorListener,
IZoomListener,
Listener {
    private static final int GAP = 20;
    private FloatingTextEditor editor = null;
    private IGraphicalViewer viewer = null;
    private ZoomManager zoomManager = null;
    private int minWidth = -1;
    private int maxWidth = -1;
    private int prefWidth = -1;
    private boolean extendsBidirectionalHorizontal;
    private int expansion = 100;

    public FloatingTextEditorHelperBase() {
        this(false);
    }

    public FloatingTextEditorHelperBase(boolean extendsBidirectionalHorizontal) {
        this.extendsBidirectionalHorizontal = extendsBidirectionalHorizontal;
    }

    public boolean isExtendsBidirectionalHorizontal() {
        return this.extendsBidirectionalHorizontal;
    }

    public void setExtendsBidirectionalHorizontal(boolean extendsBidirectionalHorizontal) {
        this.extendsBidirectionalHorizontal = extendsBidirectionalHorizontal;
    }

    public FloatingTextEditor getEditor() {
        return this.editor;
    }

    public IGraphicalViewer getViewer() {
        return this.viewer;
    }

    public ZoomManager getZoomManager() {
        return this.zoomManager;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public void setMinWidth(int minWidth) {
        this.minWidth = minWidth;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public void setEditor(FloatingTextEditor editor) {
        this.editor = editor;
    }

    public void setViewer(IGraphicalViewer viewer) {
        this.viewer = viewer;
    }

    public int getPrefWidth() {
        return this.prefWidth;
    }

    public void setPrefWidth(int prefWidth) {
        this.prefWidth = prefWidth;
    }

    public int getExpansion() {
        return this.expansion;
    }

    public void setExpansion(int expansion) {
        this.expansion = expansion;
    }

    public void activate() {
        if (this.editor != null) {
            this.editor.addFloatingTextEditorListener((IFloatingTextEditorListener)this);
        }
        if (this.viewer != null) {
            Control control = this.viewer.getControl();
            if (control != null && !control.isDisposed()) {
                control.addListener(11, (Listener)this);
            }
            this.zoomManager = this.viewer.getZoomManager();
            this.zoomManager.addZoomListener((IZoomListener)this);
        }
    }

    public void deactivate() {
        if (this.editor != null) {
            this.editor.removeFloatingTextEditorListener((IFloatingTextEditorListener)this);
            this.editor = null;
        }
        if (this.zoomManager != null) {
            this.zoomManager.removeZoomListener((IZoomListener)this);
            this.zoomManager = null;
        }
        if (this.viewer != null) {
            Control control = this.viewer.getControl();
            if (control != null && !control.isDisposed()) {
                control.removeListener(11, (Listener)this);
            }
            this.viewer = null;
        }
    }

    public void refreshEditor(boolean updateFont) {
        if (this.editor == null || this.editor.isClosed()) {
            return;
        }
        if (updateFont) {
            this.updateEditorFont();
        }
        this.updateEditorBounds();
        this.ensureEditorVisible();
    }

    private void updateEditorBounds() {
        int minWidth;
        if (this.editor == null || this.editor.isClosed()) {
            return;
        }
        Rectangle r = this.getPreferredBounds();
        if (r == null) {
            return;
        }
        this.translateToControl(r);
        StyledText textWidget = this.editor.getTextViewer().getTextWidget();
        org.eclipse.swt.graphics.Rectangle trim = textWidget.computeTrim(0, 0, 0, 0);
        int widthHint = this.getPrefWidth() < 0 ? -1 : Math.max(1, (int)((double)this.getPrefWidth() * this.getScale()) - trim.width);
        org.eclipse.swt.graphics.Point prefSize = textWidget.computeSize(widthHint, -1);
        int prefWidth = prefSize.x - trim.width;
        int prefHeight = prefSize.y - trim.height;
        Rectangle clientArea = this.getViewerClientArea();
        int maxWidth = -1;
        int maxHeight = -1;
        if (clientArea != null) {
            org.eclipse.swt.graphics.Rectangle trim2 = this.editor.computeTrim(0, 0, 0, 0);
            int gap = (int)(20.0 * this.getScale());
            maxWidth = clientArea.width - trim2.width - gap;
            maxHeight = clientArea.height - trim2.height - gap;
            if (this.getMaxWidth() > 0 && this.getMaxWidth() < maxWidth) {
                maxWidth = (int)((double)this.getMaxWidth() * this.getScale());
            }
            if (prefWidth > maxWidth) {
                prefWidth = maxWidth;
            }
            if (prefHeight > maxHeight) {
                prefHeight = maxHeight;
            }
        }
        if (prefWidth < (minWidth = this.getMinWidth() > 0 ? (int)((double)this.getMinWidth() * this.getScale()) : (this.getPrefWidth() < 0 ? r.width : (int)(20.0 * this.getScale())))) {
            prefWidth = minWidth;
        }
        prefSize = textWidget.computeSize(prefWidth, -1);
        prefSize.x -= trim.width;
        prefSize.y -= trim.height;
        if (this.getPrefWidth() < 0) {
            int f = (int)((double)this.getExpansion() * this.getScale());
            prefWidth = (prefSize.x + f - 1) / f * f + f * 2 / 5;
        }
        prefHeight = prefSize.y;
        if (maxWidth > 0) {
            prefWidth = Math.min(maxWidth, prefWidth);
        }
        if (maxHeight > 0) {
            prefHeight = Math.min(maxHeight, prefHeight);
        }
        if (this.extendsBidirectionalHorizontal) {
            r.x += (r.width - prefWidth) / 2;
        }
        r.y += (r.height - prefHeight) / 2;
        r.width = prefWidth;
        r.height = prefHeight;
        this.editor.getControl().setBounds(this.editor.computeTrim(r.x, r.y, r.width, r.height));
        this.updateScrollBars(prefWidth < prefSize.x, prefHeight < prefSize.y);
    }

    protected Rectangle getViewerClientArea() {
        if (this.viewer != null) {
            return new Rectangle(this.viewer.getCanvas().getClientArea());
        }
        return null;
    }

    private void updateScrollBars(boolean hVisible, boolean vVisible) {
        ScrollBar vBar;
        if (this.editor == null) {
            return;
        }
        StyledText textWidget = this.editor.getTextViewer().getTextWidget();
        ScrollBar hBar = textWidget.getHorizontalBar();
        if (hBar != null) {
            hBar.setVisible(hVisible);
        }
        if ((vBar = textWidget.getVerticalBar()) != null) {
            vBar.setVisible(vVisible);
        }
    }

    private void translateToControl(Rectangle r) {
        r.scale(this.getScale());
        Viewport viewport = this.getViewport();
        if (viewport != null) {
            Point viewLocation = viewport.getViewLocation();
            r.translate(-viewLocation.x, -viewLocation.y);
        }
    }

    protected Viewport getViewport() {
        if (this.viewer != null) {
            return this.viewer.getCanvas().getViewport();
        }
        return null;
    }

    private void updateEditorFont() {
        if (this.editor == null) {
            return;
        }
        ITextViewer textViewer = this.editor.getTextViewer();
        if (textViewer == null) {
            return;
        }
        Font font = this.getPreferredFont();
        if (font != null && !font.isDisposed()) {
            textViewer.getTextWidget().setFont(font);
        }
    }

    protected abstract Font getPreferredFont();

    protected StyleRange createStyleRange(TextStyle style, IDocument document) {
        if (style == null || document == null) {
            return new StyleRange();
        }
        StyleRange range = new StyleRange(0, document.getLength(), null, null);
        range.font = style.font;
        range.strikeout = style.strikeout;
        range.underline = style.underline;
        return range;
    }

    protected void ensureEditorVisible() {
        if (this.editor != null && this.viewer instanceof GraphicalViewer) {
            Rectangle r = new Rectangle(this.editor.getControl().getBounds());
            int gap = (int)(20.0 / this.getScale());
            r.expand(gap, gap);
            ((GraphicalViewer)this.viewer).ensureControlVisible(r);
        }
    }

    protected double getScale() {
        if (this.zoomManager != null) {
            return this.zoomManager.getScale();
        }
        return 1.0;
    }

    protected abstract Rectangle getPreferredBounds();

    public void editingStarted(TextEvent e) {
        this.refreshEditor(true);
    }

    public void textChanged(TextEvent e) {
        this.refreshEditor(false);
    }

    public void editingAboutToCancel(TextEvent e) {
    }

    public void editingAboutToFinish(TextEvent e) {
    }

    public void editingAboutToStart(TextEvent e) {
    }

    public void editingCanceled(TextEvent e) {
    }

    public void editingFinished(TextEvent e) {
    }

    public void textAboutToChange(TextEvent e) {
    }

    public void scaleChanged(ZoomObject source, double oldValue, double newValue) {
        this.refreshEditor(true);
    }

    public void handleEvent(Event event) {
        this.refreshEditor(false);
    }
}

