/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gallery;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class NavigationItemLayout
extends AbstractLayout {
    private static final int H_SPACING = 10;
    private static final int BIG_TOP_MARGIN = 10;
    private static final int SMALL_TOP_MARGIN = 25;
    private IFigure center = null;
    private Map<IFigure, Rectangle> cache = null;
    private int centerX = -1;
    private int childrenWidth = -1;
    private int offset = 0;
    private int maxOffset = -1;
    private int minOffset = -1;

    public void layout(IFigure container) {
        this.buildCache(container);
        Rectangle r = container.getClientArea(Rectangle.SINGLETON);
        int x = r.x + r.width / 2 - this.centerX + this.offset;
        int y = r.y + 10;
        for (Map.Entry<IFigure, Rectangle> en : this.cache.entrySet()) {
            IFigure child = en.getKey();
            Rectangle b = en.getValue();
            child.setBounds(b.getTranslated(x, y));
        }
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        if (wHint >= 0 && hHint >= 0) {
            return new Dimension(wHint, hHint);
        }
        this.buildCache(container);
        int width = this.childrenWidth + 10 + 10;
        int height = 90;
        return new Dimension(width, height);
    }

    private void buildCache(IFigure container) {
        if (this.cache != null) {
            return;
        }
        this.cache = new HashMap<IFigure, Rectangle>();
        List children = container.getChildren();
        int x = 0;
        int min = 1000;
        int max = 0;
        int i = 0;
        while (i < children.size()) {
            int y;
            IFigure child = (IFigure)children.get(i);
            Dimension size = child.getPreferredSize();
            int cx = x + size.width / 2;
            if (child == this.center) {
                this.centerX = cx;
                y = 0;
            } else {
                y = 15;
            }
            this.cache.put(child, new Rectangle(x, y, size.width, size.height));
            x += size.width + 10;
            min = Math.min(min, cx);
            max = Math.max(max, cx);
            ++i;
        }
        this.childrenWidth = x - 10;
        if (this.centerX < 0) {
            this.centerX = this.childrenWidth / 2;
        }
        this.minOffset = this.centerX - max;
        this.maxOffset = this.centerX - min;
    }

    public void setConstraint(IFigure child, Object constraint) {
        if (child == constraint) {
            this.center = child;
        }
        super.setConstraint(child, constraint);
    }

    public void invalidate() {
        super.invalidate();
        this.cache = null;
        this.centerX = -1;
        this.childrenWidth = -1;
        this.maxOffset = -1;
        this.minOffset = -1;
    }

    public void addOffset(IFigure container, int offset) {
        this.buildCache(container);
        this.offset = Math.max(this.minOffset, Math.min(this.maxOffset, offset += this.offset));
    }

    public void resetOffset(IFigure container) {
        this.offset = 0;
    }
}

