/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.datepicker;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.draw2d.graphics.AlphaGraphics;
import org.xmind.ui.datepicker.PreselectFeedbackLayer;
import org.xmind.ui.datepicker.PressFeedbackLayer;
import org.xmind.ui.datepicker.SelectFeedbackLayer;
import org.xmind.ui.datepicker.TextLayer;

public class BaseFigure
extends Figure {
    public static Object PRESELECTED = "PRESELECTED";
    public static Object SELECTED = "SELECTED";
    public static Object PRESSED = "PRESSED";
    public static Object CONTENT = "CONTENT";
    private double alpha = 255.0;
    private LayeredPane pane = new LayeredPane();

    public BaseFigure() {
        this.setLayoutManager((LayoutManager)new StackLayout());
        this.setOpaque(false);
        this.add((IFigure)this.pane);
        this.addLayers();
        this.setCursor(Display.getCurrent().getSystemCursor(21));
    }

    protected void addLayers() {
        this.addFeedbackLayers();
        this.addContentLayer();
    }

    protected void addFeedbackLayers() {
        this.addSelectFeedbackLayer();
        this.addPressFeedbackLayer();
        this.addPreselectFeedbackLayer();
    }

    protected void addPreselectFeedbackLayer() {
        this.pane.add((IFigure)new PreselectFeedbackLayer(), PRESELECTED, -1);
    }

    protected void addPressFeedbackLayer() {
        this.pane.add((IFigure)new PressFeedbackLayer(), PRESSED, -1);
    }

    protected void addSelectFeedbackLayer() {
        this.pane.add((IFigure)new SelectFeedbackLayer(), SELECTED, -1);
    }

    protected void addContentLayer() {
        this.pane.add((IFigure)new TextLayer(), CONTENT, -1);
    }

    public void setContentLayer(IFigure content) {
        this.removeOldContent();
        this.pane.add(content, CONTENT, -1);
    }

    private void removeOldContent() {
        Layer content = this.pane.getLayer(CONTENT);
        if (content != null) {
            this.pane.remove((IFigure)content);
        }
    }

    public void setContentLayerAfter(Layer content, Object after) {
        this.removeOldContent();
        this.pane.addLayerAfter(content, CONTENT, after);
    }

    public void setContentLayerBefore(Layer content, Object before) {
        this.removeOldContent();
        this.pane.addLayerBefore(content, CONTENT, before);
    }

    public IFigure getContent() {
        return this.pane.getLayer(CONTENT);
    }

    public String getText() {
        IFigure content = this.getContent();
        if (content instanceof TextLayer) {
            return ((TextLayer)content).getText();
        }
        return null;
    }

    public void setText(String text) {
        IFigure content = this.getContent();
        if (content instanceof TextLayer) {
            ((TextLayer)content).setText(text);
        }
    }

    public void setTextCandidates(String[] candidates) {
        IFigure content = this.getContent();
        if (content instanceof TextLayer) {
            ((TextLayer)content).setCandidates(candidates);
        }
    }

    public void setTextAlpha(int alpha) {
        IFigure content = this.getContent();
        if (content instanceof TextLayer) {
            ((TextLayer)content).setAlpha(alpha);
        }
    }

    public void paint(Graphics graphics) {
        AlphaGraphics g = new AlphaGraphics(graphics);
        g.setMainAlpha((int)this.alpha);
        g.setAntialias(1);
        super.paint((Graphics)g);
        g.dispose();
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
        this.repaint();
    }

    public double getAlpha() {
        return this.alpha;
    }

    public boolean isPreselected() {
        Layer layer = this.pane.getLayer(PRESELECTED);
        return layer != null && layer.isVisible();
    }

    public void setPreselected(boolean value) {
        Layer layer = this.pane.getLayer(PRESELECTED);
        if (layer != null) {
            layer.setVisible(value);
        }
    }

    public boolean isSelected() {
        Layer layer = this.pane.getLayer(SELECTED);
        return layer != null && layer.isVisible();
    }

    public void setSelected(boolean value) {
        Layer layer = this.pane.getLayer(SELECTED);
        if (layer != null) {
            layer.setVisible(value);
            this.setForegroundColor(value ? ColorConstants.white : ColorConstants.black);
        }
    }

    public boolean isPressed() {
        Layer layer = this.pane.getLayer(PRESSED);
        return layer != null && layer.isVisible();
    }

    public void setPressed(boolean value) {
        IFigure content;
        Layer layer = this.pane.getLayer(PRESSED);
        if (layer != null) {
            layer.setVisible(value);
        }
        if ((content = this.getContent()) instanceof TextLayer) {
            ((TextLayer)content).setOffset(value ? 1 : 0, value ? 1 : 0);
        }
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        int h;
        Object constraint;
        LayoutManager layout;
        Dimension psize = super.getPreferredSize(wHint, hHint);
        if (this.getParent() != null && (layout = this.getParent().getLayoutManager()) != null && (constraint = layout.getConstraint((IFigure)this)) instanceof GridData && (h = ((GridData)constraint).horizontalSpan) > 1) {
            psize = psize.getCopy();
            psize.width /= h;
        }
        return psize;
    }
}

