/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.views;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.services.IEvaluationService;
import org.xmind.ui.internal.ToolkitPlugin;
import org.xmind.ui.viewers.Messages;
import org.xmind.ui.views.DefaultContributedContentPage;
import org.xmind.ui.views.IContributedContentPageFactory;

public class ContributedContentsView
extends PageBookView
implements IContributedContentsView {
    private static final String EXT_INSPECTORS = "org.xmind.ui.toolkit.contributedContentsViews";
    private static final Map<String, Map<String, IContributedContentPageFactory>> pageFactoryCache = new HashMap<String, Map<String, IContributedContentPageFactory>>();
    private String pageType = null;

    protected IPage createDefaultPage(PageBook book) {
        DefaultContributedContentPage page = new DefaultContributedContentPage(true);
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)book);
        page.setMessage(Messages.ContentsView_NoContent);
        return page;
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        IPage page;
        IContributedContentPageFactory pageFactory = this.getPageFactory(part);
        if (pageFactory != null && (page = pageFactory.createInspectorPage(this.pageType, part)) != null) {
            if (page instanceof IPageBookViewPage) {
                this.initPage((IPageBookViewPage)page);
            }
            page.createControl((Composite)this.getPageBook());
            return new PageBookView.PageRec(part, page);
        }
        return null;
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        IPage page = pageRecord.page;
        if (page != null) {
            page.dispose();
        }
        pageRecord.dispose();
    }

    protected IWorkbenchPart getBootstrapPart() {
        IWorkbenchPage wbPage = this.getSite().getPage();
        if (wbPage != null) {
            return wbPage.getActiveEditor();
        }
        return null;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part != null && part instanceof IEditorPart;
    }

    public IWorkbenchPart getContributingPart() {
        return this.getCurrentContributingPart();
    }

    public <T> T getAdapter(Class<T> key) {
        if (key == IContributedContentsView.class) {
            return key.cast((Object)this);
        }
        return (T)super.getAdapter(key);
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        super.setInitializationData(cfig, propertyName, data);
        if (data != null && data instanceof String) {
            this.pageType = (String)data;
        }
    }

    protected IContributedContentPageFactory getPageFactory(IWorkbenchPart part) {
        if (this.pageType == null) {
            return null;
        }
        return ContributedContentsView.getOrCreatePageFactory(part, this.pageType);
    }

    private static synchronized IContributedContentPageFactory getOrCreatePageFactory(IWorkbenchPart part, String targetPageType) {
        IContributedContentPageFactory pageFactory = null;
        String targetEditorId = part.getSite().getId();
        Map<String, IContributedContentPageFactory> pageFactoriesByType = pageFactoryCache.get(targetEditorId);
        if (pageFactoriesByType != null && (pageFactory = pageFactoriesByType.get(targetPageType)) != null) {
            return pageFactory;
        }
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(EXT_INSPECTORS);
        if (extPoint != null) {
            IExtension[] exts;
            IExtension[] iExtensionArray = exts = extPoint.getExtensions();
            int n = exts.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] extElements;
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extElements = ext.getConfigurationElements();
                int n3 = extElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement extElement = iConfigurationElementArray[n4];
                    if ("pageFactory".equals(extElement.getName())) {
                        String editorId = extElement.getAttribute("editorId");
                        String pageTypes = extElement.getAttribute("types");
                        List<String> pageTypeList = Arrays.asList(pageTypes.split(","));
                        if (targetEditorId.equals(editorId) && pageTypes != null && pageTypeList.contains(targetPageType)) {
                            try {
                                pageFactory = (IContributedContentPageFactory)extElement.createExecutableExtension("class");
                            }
                            catch (CoreException e) {
                                ToolkitPlugin.getDefault().getLog().log((IStatus)new Status(4, ext.getNamespaceIdentifier(), "Failed to create class " + extElement.getAttribute("class"), (Throwable)e));
                            }
                            if (pageFactory != null) {
                                if (pageFactoriesByType == null) {
                                    pageFactoriesByType = new HashMap<String, IContributedContentPageFactory>();
                                    pageFactoryCache.put(targetEditorId, pageFactoriesByType);
                                }
                                for (String pageType : pageTypeList) {
                                    pageFactoriesByType.put(pageType, pageFactory);
                                }
                                return pageFactory;
                            }
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return ContributedContentsView.getAdapter(part, IContributedContentPageFactory.class);
    }

    private static <T> T getAdapter(Object obj, Class<T> adapter) {
        Object result;
        if (adapter.isInstance(obj)) {
            return adapter.cast(obj);
        }
        if (obj instanceof IAdaptable && (result = ((IAdaptable)obj).getAdapter(adapter)) != null) {
            return (T)result;
        }
        if (!(obj instanceof PlatformObject) && (result = Platform.getAdapterManager().getAdapter(obj, adapter)) != null) {
            return (T)result;
        }
        return null;
    }

    public void partActivated(IWorkbenchPart part) {
        IEvaluationService evaluationService;
        IWorkbenchPart oldContributingPart = this.getCurrentContributingPart();
        super.partActivated(part);
        IWorkbenchPart newContributingPart = this.getCurrentContributingPart();
        if (newContributingPart != oldContributingPart && (evaluationService = (IEvaluationService)this.getSite().getService(IEvaluationService.class)) != null) {
            evaluationService.requestEvaluation("org.xmind.ui.contributedContentsView.contributingPartId");
        }
    }
}

